/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf.impl;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.sis.internal.netcdf.DataType;
import org.apache.sis.internal.netcdf.Variable;
import org.apache.sis.internal.netcdf.impl.Dimension;
import org.apache.sis.internal.netcdf.impl.GridGeometryInfo;
import org.apache.sis.internal.storage.io.ChannelDataInput;
import org.apache.sis.internal.storage.io.HyperRectangleReader;
import org.apache.sis.internal.storage.io.Region;
import org.apache.sis.math.Vector;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.resources.Errors;

final class VariableInfo
extends Variable
implements Comparable<VariableInfo> {
    private static final Number[] EMPTY = new Number[0];
    private static final String[] DESCRIPTION_ATTRIBUTES = new String[]{"long_name", "description", "title", "standard_name"};
    private final HyperRectangleReader reader;
    private final String name;
    final Dimension[] dimensions;
    private final Map<String, Object> attributes;
    private final DataType dataType;
    GridGeometryInfo gridGeometry;
    private final boolean isCoordinateSystemAxis;
    private transient Vector values;
    private final String[] meanings;

    VariableInfo(ChannelDataInput channelDataInput, String string, Dimension[] dimensionArray, Map<String, Object> map, DataType dataType, int n, long l) throws DataStoreException {
        Object object;
        Object object2 = map.get("_Unsigned");
        if (object2 != null) {
            dataType = dataType.unsigned(VariableInfo.booleanValue(object2));
        }
        this.name = string;
        this.dimensions = dimensionArray;
        this.attributes = map;
        this.dataType = dataType;
        this.reader = dataType != null && dataType.number >= 3 && dataType.number <= 8 ? new HyperRectangleReader(dataType.number, channelDataInput, l) : null;
        if (dimensionArray.length == 1) {
            object = this.getAttributeValue("_CoordinateAliasForDimension", "_coordinatealiasfordimension");
            if (object == null && (object = this.getAttributeValue("_CoordinateVariableAlias", "_coordinatevariablealias")) == null) {
                object = string;
            }
            this.isCoordinateSystemAxis = dimensionArray[0].name.equals(object);
        } else {
            this.isCoordinateSystemAxis = false;
        }
        if (!map.isEmpty()) {
            object = VariableInfo.stringValues(map.remove("flag_meanings"));
            switch (((String[])object).length) {
                case 0: {
                    object = null;
                    break;
                }
                case 1: {
                    object = (String[])CharSequences.split(object[0], ' ');
                }
            }
            this.meanings = object;
        } else {
            this.meanings = null;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        for (String string : DESCRIPTION_ATTRIBUTES) {
            Object object = this.getAttributeValue(string);
            if (!(object instanceof String)) continue;
            return (String)object;
        }
        return null;
    }

    @Override
    public String getUnitsString() {
        Object object = this.getAttributeValue("units");
        return object instanceof String ? (String)object : null;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    public boolean isEnumeration() {
        return this.meanings != null;
    }

    @Override
    public boolean isCoordinateSystemAxis() {
        return this.isCoordinateSystemAxis;
    }

    final String getAxisType() {
        Object object = this.getAttributeValue("_CoordinateAxisType", "_coordinateaxistype");
        return object instanceof String ? (String)object : null;
    }

    @Override
    public String[] getGridDimensionNames() {
        String[] stringArray = new String[this.dimensions.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.dimensions[i].name;
        }
        return stringArray;
    }

    @Override
    public int[] getGridEnvelope() {
        int[] nArray = new int[this.dimensions.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.dimensions[i].length;
        }
        return nArray;
    }

    @Override
    public Collection<String> getAttributeNames() {
        return Collections.unmodifiableSet(this.attributes.keySet());
    }

    private Object getAttributeValue(String string, String string2) {
        Object object = this.attributes.get(string);
        if (object == null) {
            object = this.attributes.get(string2);
        }
        return object;
    }

    final Object getAttributeValue(String string) {
        return this.attributes.get(string);
    }

    @Override
    public Object[] getAttributeValues(String string, boolean bl) {
        Object object = this.getAttributeValue(string);
        return bl ? VariableInfo.numberValues(object) : VariableInfo.stringValues(object);
    }

    static String[] stringValues(Object object) {
        if (object == null) {
            return CharSequences.EMPTY_ARRAY;
        }
        if (object.getClass().isArray()) {
            String[] stringArray = new String[Array.getLength(object)];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = Array.get(object, i).toString();
            }
            return stringArray;
        }
        return new String[]{object.toString()};
    }

    static Number[] numberValues(Object object) {
        if (object != null) {
            if (object.getClass().isArray()) {
                Number[] numberArray = new Number[Array.getLength(object)];
                for (int i = 0; i < numberArray.length; ++i) {
                    numberArray[i] = (Number)Array.get(object, i);
                }
                return numberArray;
            }
            if (object instanceof Number) {
                return new Number[]{(Number)object};
            }
        }
        return EMPTY;
    }

    private static boolean booleanValue(Object object) {
        return object instanceof String && Boolean.valueOf((String)object) != false;
    }

    @Override
    public Vector read() throws IOException, DataStoreException {
        if (this.values == null) {
            if (this.reader == null) {
                throw new DataStoreContentException(this.unknownType());
            }
            long l = 1L;
            boolean bl = false;
            for (Dimension dimension : this.dimensions) {
                if ((l *= dimension.length()) <= Integer.MAX_VALUE) continue;
                bl = true;
            }
            if (bl) {
                throw new DataStoreContentException(Errors.format((short)36, this.name, l));
            }
            int n = this.dimensions.length;
            long[] lArray = new long[n];
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = 1;
                lArray[i] = this.dimensions[n - 1 - i].length();
            }
            this.values = Vector.create(this.reader.read(new Region(lArray, new long[n], lArray, nArray)), this.dataType.isUnsigned).compress(0.0);
        }
        return this.values;
    }

    @Override
    public Vector read(int[] nArray, int[] nArray2, int[] nArray3) throws IOException, DataStoreException {
        if (this.reader == null) {
            throw new DataStoreContentException(this.unknownType());
        }
        int n = this.dimensions.length;
        long[] lArray = new long[n];
        long[] lArray2 = new long[n];
        long[] lArray3 = new long[n];
        int[] nArray4 = new int[n];
        for (int i = 0; i < n; ++i) {
            int n2 = n - 1 - i;
            lArray2[i] = (long)nArray[n2] & 0xFFFFFFFFL;
            lArray3[i] = (long)nArray2[n2] & 0xFFFFFFFFL;
            nArray4[i] = nArray3[n2];
            lArray[i] = this.dimensions[n2].length();
        }
        return Vector.create(this.reader.read(new Region(lArray, lArray2, lArray3, nArray4)), this.dataType.isUnsigned);
    }

    public String meaning(int n) {
        return n >= 0 && n < this.meanings.length ? this.meanings[n] : null;
    }

    private String unknownType() {
        return Errors.format((short)149, "NetCDF:" + (Object)((Object)this.dataType));
    }

    @Override
    public int compareTo(VariableInfo variableInfo) {
        int n = Long.compare(this.reader.origin, variableInfo.reader.origin);
        if (n == 0) {
            n = this.name.compareTo(variableInfo.name);
        }
        return n;
    }
}

