/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import java.lang.reflect.Array;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.measure.IncommensurableException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import org.apache.sis.internal.referencing.EPSGParameterDomain;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.system.Semaphores;
import org.apache.sis.measure.Range;
import org.apache.sis.measure.Units;
import org.apache.sis.parameter.DefaultParameterDescriptor;
import org.apache.sis.parameter.DefaultParameterValue;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.ReferenceIdentifier;

final class Verifier {
    private final short errorKey;
    private final boolean internal;
    private final boolean needsValue;
    private final Object[] arguments;

    private Verifier(boolean bl, short s, boolean bl2, Object ... objectArray) {
        this.errorKey = s;
        this.internal = bl;
        this.needsValue = bl2;
        this.arguments = objectArray;
    }

    static <T> T ensureValidValue(ParameterDescriptor<T> parameterDescriptor, Object object, Unit<?> unit) throws InvalidParameterValueException {
        Class<?> clazz;
        Object object2;
        Class<T> clazz2 = parameterDescriptor.getValueClass();
        UnitConverter unitConverter = null;
        Object object3 = object;
        if (unit != null) {
            object2 = parameterDescriptor.getUnit();
            if (object2 == null && (object2 = Verifier.getCompatibleUnit(Parameters.getValueDomain(parameterDescriptor), unit)) == null) {
                String string = Verifier.getDisplayName(parameterDescriptor);
                throw new InvalidParameterValueException(Resources.format((short)65, string), string, unit);
            }
            if (!unit.equals(object2)) {
                short s = Verifier.getUnitMessageID(object2);
                if (Verifier.getUnitMessageID(unit) != s) {
                    throw new IllegalArgumentException(Errors.format(s, unit));
                }
                if (object != null) {
                    if (!clazz2.isInstance(object)) {
                        String string = Verifier.getDisplayName(parameterDescriptor);
                        throw new InvalidParameterValueException(Resources.format((short)24, string, clazz2, object.getClass()), string, object);
                    }
                    try {
                        unitConverter = unit.getConverterToAny((Unit<?>)object2);
                    }
                    catch (IncommensurableException incommensurableException) {
                        throw new IllegalArgumentException(Errors.format((short)66, unit, object2), incommensurableException);
                    }
                    clazz = clazz2.getComponentType();
                    if (clazz == null) {
                        Double d = unitConverter.convert(((Number)object).doubleValue());
                        try {
                            object3 = Numbers.cast(d, clazz2.asSubclass(Number.class));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw new InvalidParameterValueException(illegalArgumentException.getLocalizedMessage(), Verifier.getDisplayName(parameterDescriptor), object);
                        }
                    }
                    int n = Array.getLength(object);
                    object3 = Array.newInstance(clazz, n);
                    clazz = Numbers.primitiveToWrapper(clazz);
                    for (int i = 0; i < n; ++i) {
                        Number number = (Number)Array.get(object, i);
                        number = unitConverter.convert(number.doubleValue());
                        try {
                            number = Numbers.cast(number, clazz.asSubclass(Number.class));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw new InvalidParameterValueException(illegalArgumentException.getLocalizedMessage(), Verifier.getDisplayName(parameterDescriptor) + '[' + i + ']', object);
                        }
                        Array.set(object3, i, number);
                    }
                }
            }
        }
        if (object3 != null) {
            Set<T> set = parameterDescriptor.getValidValues();
            object2 = parameterDescriptor instanceof DefaultParameterDescriptor ? Verifier.ensureValidValue(clazz2, set, ((DefaultParameterDescriptor)parameterDescriptor).getValueDomain(), object3) : Verifier.ensureValidValue(clazz2, set, parameterDescriptor.getMinimumValue(), parameterDescriptor.getMaximumValue(), object3);
            if (object2 != null) {
                super.convertRange(unitConverter);
                clazz = Verifier.getDisplayName(parameterDescriptor);
                String string = ((Verifier)object2).message(null, (String)((Object)clazz), object);
                if (!Semaphores.query(16)) {
                    throw new InvalidParameterValueException(string, (String)((Object)clazz), object);
                }
                LogRecord logRecord = new LogRecord(Level.WARNING, string);
                logRecord.setLoggerName("org.apache.sis.referencing.operation");
                Logging.log(DefaultParameterValue.class, "setValue", logRecord);
            }
        }
        return clazz2.cast(object3);
    }

    static <T> Verifier ensureValidValue(Class<T> clazz, Set<T> set, Range<?> range, Object object) {
        Verifier verifier = Verifier.ensureValidValue(clazz, set, null, null, object);
        if (verifier == null && range != null) {
            if (!clazz.isArray()) {
                assert (range.getElementType() == clazz) : range;
                if (!range.contains((Comparable)object)) {
                    return new Verifier(false, 166, true, null, range.getMinValue(), range.getMaxValue(), object);
                }
            } else {
                assert (range.getElementType() == Numbers.primitiveToWrapper(clazz.getComponentType())) : range;
                int n = Array.getLength(object);
                for (int i = 0; i < n; ++i) {
                    Object object2 = Array.get(object, i);
                    if (range.contains((Comparable)object2)) continue;
                    return new Verifier(false, 166, true, i, range.getMinValue(), range.getMaxValue(), object2);
                }
            }
        }
        return verifier;
    }

    private static <T> Verifier ensureValidValue(Class<T> clazz, Set<T> set, Comparable<T> comparable, Comparable<T> comparable2, Object object) {
        if (!clazz.isInstance(object)) {
            return new Verifier(true, 24, false, null, clazz, object.getClass());
        }
        if (set != null && !set.contains(object)) {
            return new Verifier(true, 25, true, null, object);
        }
        if (comparable != null && comparable.compareTo(object) > 0 || comparable2 != null && comparable2.compareTo(object) < 0) {
            return new Verifier(false, 166, true, null, comparable, comparable2, object);
        }
        return null;
    }

    private void convertRange(UnitConverter unitConverter) {
        if (unitConverter != null && !this.internal && this.errorKey == 166) {
            unitConverter = unitConverter.inverse();
            Object object = this.arguments[1];
            Object object2 = this.arguments[2];
            object = object != null ? Double.valueOf(unitConverter.convert(((Number)object).doubleValue())) : "\u2212\u221e";
            object2 = object2 != null ? Double.valueOf(unitConverter.convert(((Number)object2).doubleValue())) : "\u221e";
            this.arguments[1] = object;
            this.arguments[2] = object2;
        }
    }

    private static Unit<?> getCompatibleUnit(Range<?> range, Unit<?> unit) {
        if (range instanceof EPSGParameterDomain) {
            for (Unit<?> unit2 : ((EPSGParameterDomain)range).units) {
                if (!unit.isCompatible(unit2)) continue;
                return unit2;
            }
        }
        return null;
    }

    String message(Map<?, ?> map, String string, Object object) {
        Object object2 = this.arguments[0];
        if (object2 != null) {
            string = string + '[' + object2 + ']';
            object = Array.get(object, (Integer)object2);
        }
        this.arguments[0] = string;
        if (this.needsValue) {
            this.arguments[this.arguments.length - 1] = object;
        }
        return (this.internal ? Resources.forProperties(map) : Errors.getResources(map)).getString(this.errorKey, this.arguments);
    }

    static String getDisplayName(GeneralParameterDescriptor generalParameterDescriptor) {
        String string;
        ReferenceIdentifier referenceIdentifier;
        if (generalParameterDescriptor != null && (referenceIdentifier = generalParameterDescriptor.getName()) != null && (string = referenceIdentifier.getCode()) != null) {
            return string;
        }
        return Vocabulary.format((short)108);
    }

    static short getUnitMessageID(Unit<?> unit) {
        if (Units.isLinear(unit)) {
            return 103;
        }
        if (Units.isAngular(unit)) {
            return 100;
        }
        if (Units.isTemporal(unit)) {
            return 107;
        }
        if (Units.isScale(unit)) {
            return 105;
        }
        return 65;
    }
}

