use strict;

use charnames qw(:full);
use Unicode::Semantics qw(us);

my %tests;  # regex => [ char, char, char, ... ]

my $current_regex;
while (defined($_ = readline *DATA)) {
    m[^/(.*)/$] and do { $current_regex = $1; $tests{ $current_regex } = {}; };
    m[^U\+(\w+)] and $tests{ $current_regex }{ $1 } = 1;
}

print "1..", 128 * keys %tests, "\n";
my $i;
for my $re (sort keys %tests) {
    for my $cp (128..255) {
        my $hcp = sprintf "%04x", $cp;
        my $char = chr $cp;
        us $char;
        my $result = $char =~ /$re/;
        my $expected = exists $tests{ $re }{ $hcp };
        print +($result == $expected ? "ok " : "not ok "), ++$i, 
            " # (chr(0x$hcp) =~ /$re/) == $expected\n";
    }
}

__DATA__
/\w/
U+00aa FEMININE ORDINAL INDICATOR
U+00b2 SUPERSCRIPT TWO
U+00b3 SUPERSCRIPT THREE
U+00b5 MICRO SIGN
U+00b9 SUPERSCRIPT ONE
U+00ba MASCULINE ORDINAL INDICATOR
U+00bc VULGAR FRACTION ONE QUARTER
U+00bd VULGAR FRACTION ONE HALF
U+00be VULGAR FRACTION THREE QUARTERS
U+00c0 LATIN CAPITAL LETTER A WITH GRAVE
U+00c1 LATIN CAPITAL LETTER A WITH ACUTE
U+00c2 LATIN CAPITAL LETTER A WITH CIRCUMFLEX
U+00c3 LATIN CAPITAL LETTER A WITH TILDE
U+00c4 LATIN CAPITAL LETTER A WITH DIAERESIS
U+00c5 LATIN CAPITAL LETTER A WITH RING ABOVE
U+00c6 LATIN CAPITAL LETTER AE
U+00c7 LATIN CAPITAL LETTER C WITH CEDILLA
U+00c8 LATIN CAPITAL LETTER E WITH GRAVE
U+00c9 LATIN CAPITAL LETTER E WITH ACUTE
U+00ca LATIN CAPITAL LETTER E WITH CIRCUMFLEX
U+00cb LATIN CAPITAL LETTER E WITH DIAERESIS
U+00cc LATIN CAPITAL LETTER I WITH GRAVE
U+00cd LATIN CAPITAL LETTER I WITH ACUTE
U+00ce LATIN CAPITAL LETTER I WITH CIRCUMFLEX
U+00cf LATIN CAPITAL LETTER I WITH DIAERESIS
U+00d0 LATIN CAPITAL LETTER ETH
U+00d1 LATIN CAPITAL LETTER N WITH TILDE
U+00d2 LATIN CAPITAL LETTER O WITH GRAVE
U+00d3 LATIN CAPITAL LETTER O WITH ACUTE
U+00d4 LATIN CAPITAL LETTER O WITH CIRCUMFLEX
U+00d5 LATIN CAPITAL LETTER O WITH TILDE
U+00d6 LATIN CAPITAL LETTER O WITH DIAERESIS
U+00d8 LATIN CAPITAL LETTER O WITH STROKE
U+00d9 LATIN CAPITAL LETTER U WITH GRAVE
U+00da LATIN CAPITAL LETTER U WITH ACUTE
U+00db LATIN CAPITAL LETTER U WITH CIRCUMFLEX
U+00dc LATIN CAPITAL LETTER U WITH DIAERESIS
U+00dd LATIN CAPITAL LETTER Y WITH ACUTE
U+00de LATIN CAPITAL LETTER THORN
U+00df LATIN SMALL LETTER SHARP S
U+00e0 LATIN SMALL LETTER A WITH GRAVE
U+00e1 LATIN SMALL LETTER A WITH ACUTE
U+00e2 LATIN SMALL LETTER A WITH CIRCUMFLEX
U+00e3 LATIN SMALL LETTER A WITH TILDE
U+00e4 LATIN SMALL LETTER A WITH DIAERESIS
U+00e5 LATIN SMALL LETTER A WITH RING ABOVE
U+00e6 LATIN SMALL LETTER AE
U+00e7 LATIN SMALL LETTER C WITH CEDILLA
U+00e8 LATIN SMALL LETTER E WITH GRAVE
U+00e9 LATIN SMALL LETTER E WITH ACUTE
U+00ea LATIN SMALL LETTER E WITH CIRCUMFLEX
U+00eb LATIN SMALL LETTER E WITH DIAERESIS
U+00ec LATIN SMALL LETTER I WITH GRAVE
U+00ed LATIN SMALL LETTER I WITH ACUTE
U+00ee LATIN SMALL LETTER I WITH CIRCUMFLEX
U+00ef LATIN SMALL LETTER I WITH DIAERESIS
U+00f0 LATIN SMALL LETTER ETH
U+00f1 LATIN SMALL LETTER N WITH TILDE
U+00f2 LATIN SMALL LETTER O WITH GRAVE
U+00f3 LATIN SMALL LETTER O WITH ACUTE
U+00f4 LATIN SMALL LETTER O WITH CIRCUMFLEX
U+00f5 LATIN SMALL LETTER O WITH TILDE
U+00f6 LATIN SMALL LETTER O WITH DIAERESIS
U+00f8 LATIN SMALL LETTER O WITH STROKE
U+00f9 LATIN SMALL LETTER U WITH GRAVE
U+00fa LATIN SMALL LETTER U WITH ACUTE
U+00fb LATIN SMALL LETTER U WITH CIRCUMFLEX
U+00fc LATIN SMALL LETTER U WITH DIAERESIS
U+00fd LATIN SMALL LETTER Y WITH ACUTE
U+00fe LATIN SMALL LETTER THORN
U+00ff LATIN SMALL LETTER Y WITH DIAERESIS

/\s/
U+0085 NEXT LINE (NEL)
U+00a0 NO-BREAK SPACE

/\d/
# none

/[[:alpha:]]/
U+00aa FEMININE ORDINAL INDICATOR
U+00b5 MICRO SIGN
U+00ba MASCULINE ORDINAL INDICATOR
U+00c0 LATIN CAPITAL LETTER A WITH GRAVE
U+00c1 LATIN CAPITAL LETTER A WITH ACUTE
U+00c2 LATIN CAPITAL LETTER A WITH CIRCUMFLEX
U+00c3 LATIN CAPITAL LETTER A WITH TILDE
U+00c4 LATIN CAPITAL LETTER A WITH DIAERESIS
U+00c5 LATIN CAPITAL LETTER A WITH RING ABOVE
U+00c6 LATIN CAPITAL LETTER AE
U+00c7 LATIN CAPITAL LETTER C WITH CEDILLA
U+00c8 LATIN CAPITAL LETTER E WITH GRAVE
U+00c9 LATIN CAPITAL LETTER E WITH ACUTE
U+00ca LATIN CAPITAL LETTER E WITH CIRCUMFLEX
U+00cb LATIN CAPITAL LETTER E WITH DIAERESIS
U+00cc LATIN CAPITAL LETTER I WITH GRAVE
U+00cd LATIN CAPITAL LETTER I WITH ACUTE
U+00ce LATIN CAPITAL LETTER I WITH CIRCUMFLEX
U+00cf LATIN CAPITAL LETTER I WITH DIAERESIS
U+00d0 LATIN CAPITAL LETTER ETH
U+00d1 LATIN CAPITAL LETTER N WITH TILDE
U+00d2 LATIN CAPITAL LETTER O WITH GRAVE
U+00d3 LATIN CAPITAL LETTER O WITH ACUTE
U+00d4 LATIN CAPITAL LETTER O WITH CIRCUMFLEX
U+00d5 LATIN CAPITAL LETTER O WITH TILDE
U+00d6 LATIN CAPITAL LETTER O WITH DIAERESIS
U+00d8 LATIN CAPITAL LETTER O WITH STROKE
U+00d9 LATIN CAPITAL LETTER U WITH GRAVE
U+00da LATIN CAPITAL LETTER U WITH ACUTE
U+00db LATIN CAPITAL LETTER U WITH CIRCUMFLEX
U+00dc LATIN CAPITAL LETTER U WITH DIAERESIS
U+00dd LATIN CAPITAL LETTER Y WITH ACUTE
U+00de LATIN CAPITAL LETTER THORN
U+00df LATIN SMALL LETTER SHARP S
U+00e0 LATIN SMALL LETTER A WITH GRAVE
U+00e1 LATIN SMALL LETTER A WITH ACUTE
U+00e2 LATIN SMALL LETTER A WITH CIRCUMFLEX
U+00e3 LATIN SMALL LETTER A WITH TILDE
U+00e4 LATIN SMALL LETTER A WITH DIAERESIS
U+00e5 LATIN SMALL LETTER A WITH RING ABOVE
U+00e6 LATIN SMALL LETTER AE
U+00e7 LATIN SMALL LETTER C WITH CEDILLA
U+00e8 LATIN SMALL LETTER E WITH GRAVE
U+00e9 LATIN SMALL LETTER E WITH ACUTE
U+00ea LATIN SMALL LETTER E WITH CIRCUMFLEX
U+00eb LATIN SMALL LETTER E WITH DIAERESIS
U+00ec LATIN SMALL LETTER I WITH GRAVE
U+00ed LATIN SMALL LETTER I WITH ACUTE
U+00ee LATIN SMALL LETTER I WITH CIRCUMFLEX
U+00ef LATIN SMALL LETTER I WITH DIAERESIS
U+00f0 LATIN SMALL LETTER ETH
U+00f1 LATIN SMALL LETTER N WITH TILDE
U+00f2 LATIN SMALL LETTER O WITH GRAVE
U+00f3 LATIN SMALL LETTER O WITH ACUTE
U+00f4 LATIN SMALL LETTER O WITH CIRCUMFLEX
U+00f5 LATIN SMALL LETTER O WITH TILDE
U+00f6 LATIN SMALL LETTER O WITH DIAERESIS
U+00f8 LATIN SMALL LETTER O WITH STROKE
U+00f9 LATIN SMALL LETTER U WITH GRAVE
U+00fa LATIN SMALL LETTER U WITH ACUTE
U+00fb LATIN SMALL LETTER U WITH CIRCUMFLEX
U+00fc LATIN SMALL LETTER U WITH DIAERESIS
U+00fd LATIN SMALL LETTER Y WITH ACUTE
U+00fe LATIN SMALL LETTER THORN
U+00ff LATIN SMALL LETTER Y WITH DIAERESIS

/[[:alnum:]]/
U+00aa FEMININE ORDINAL INDICATOR
U+00b5 MICRO SIGN
U+00ba MASCULINE ORDINAL INDICATOR
U+00c0 LATIN CAPITAL LETTER A WITH GRAVE
U+00c1 LATIN CAPITAL LETTER A WITH ACUTE
U+00c2 LATIN CAPITAL LETTER A WITH CIRCUMFLEX
U+00c3 LATIN CAPITAL LETTER A WITH TILDE
U+00c4 LATIN CAPITAL LETTER A WITH DIAERESIS
U+00c5 LATIN CAPITAL LETTER A WITH RING ABOVE
U+00c6 LATIN CAPITAL LETTER AE
U+00c7 LATIN CAPITAL LETTER C WITH CEDILLA
U+00c8 LATIN CAPITAL LETTER E WITH GRAVE
U+00c9 LATIN CAPITAL LETTER E WITH ACUTE
U+00ca LATIN CAPITAL LETTER E WITH CIRCUMFLEX
U+00cb LATIN CAPITAL LETTER E WITH DIAERESIS
U+00cc LATIN CAPITAL LETTER I WITH GRAVE
U+00cd LATIN CAPITAL LETTER I WITH ACUTE
U+00ce LATIN CAPITAL LETTER I WITH CIRCUMFLEX
U+00cf LATIN CAPITAL LETTER I WITH DIAERESIS
U+00d0 LATIN CAPITAL LETTER ETH
U+00d1 LATIN CAPITAL LETTER N WITH TILDE
U+00d2 LATIN CAPITAL LETTER O WITH GRAVE
U+00d3 LATIN CAPITAL LETTER O WITH ACUTE
U+00d4 LATIN CAPITAL LETTER O WITH CIRCUMFLEX
U+00d5 LATIN CAPITAL LETTER O WITH TILDE
U+00d6 LATIN CAPITAL LETTER O WITH DIAERESIS
U+00d8 LATIN CAPITAL LETTER O WITH STROKE
U+00d9 LATIN CAPITAL LETTER U WITH GRAVE
U+00da LATIN CAPITAL LETTER U WITH ACUTE
U+00db LATIN CAPITAL LETTER U WITH CIRCUMFLEX
U+00dc LATIN CAPITAL LETTER U WITH DIAERESIS
U+00dd LATIN CAPITAL LETTER Y WITH ACUTE
U+00de LATIN CAPITAL LETTER THORN
U+00df LATIN SMALL LETTER SHARP S
U+00e0 LATIN SMALL LETTER A WITH GRAVE
U+00e1 LATIN SMALL LETTER A WITH ACUTE
U+00e2 LATIN SMALL LETTER A WITH CIRCUMFLEX
U+00e3 LATIN SMALL LETTER A WITH TILDE
U+00e4 LATIN SMALL LETTER A WITH DIAERESIS
U+00e5 LATIN SMALL LETTER A WITH RING ABOVE
U+00e6 LATIN SMALL LETTER AE
U+00e7 LATIN SMALL LETTER C WITH CEDILLA
U+00e8 LATIN SMALL LETTER E WITH GRAVE
U+00e9 LATIN SMALL LETTER E WITH ACUTE
U+00ea LATIN SMALL LETTER E WITH CIRCUMFLEX
U+00eb LATIN SMALL LETTER E WITH DIAERESIS
U+00ec LATIN SMALL LETTER I WITH GRAVE
U+00ed LATIN SMALL LETTER I WITH ACUTE
U+00ee LATIN SMALL LETTER I WITH CIRCUMFLEX
U+00ef LATIN SMALL LETTER I WITH DIAERESIS
U+00f0 LATIN SMALL LETTER ETH
U+00f1 LATIN SMALL LETTER N WITH TILDE
U+00f2 LATIN SMALL LETTER O WITH GRAVE
U+00f3 LATIN SMALL LETTER O WITH ACUTE
U+00f4 LATIN SMALL LETTER O WITH CIRCUMFLEX
U+00f5 LATIN SMALL LETTER O WITH TILDE
U+00f6 LATIN SMALL LETTER O WITH DIAERESIS
U+00f8 LATIN SMALL LETTER O WITH STROKE
U+00f9 LATIN SMALL LETTER U WITH GRAVE
U+00fa LATIN SMALL LETTER U WITH ACUTE
U+00fb LATIN SMALL LETTER U WITH CIRCUMFLEX
U+00fc LATIN SMALL LETTER U WITH DIAERESIS
U+00fd LATIN SMALL LETTER Y WITH ACUTE
U+00fe LATIN SMALL LETTER THORN
U+00ff LATIN SMALL LETTER Y WITH DIAERESIS

/[[:blank:]]/
U+00a0 NO-BREAK SPACE

/[[:cntrl:]]/
U+0080 
U+0081 
U+0082 BREAK PERMITTED HERE
U+0083 NO BREAK HERE
U+0084 <control>
U+0085 NEXT LINE (NEL)
U+0086 START OF SELECTED AREA
U+0087 END OF SELECTED AREA
U+0088 CHARACTER TABULATION SET
U+0089 CHARACTER TABULATION WITH JUSTIFICATION
U+008a LINE TABULATION SET
U+008b PARTIAL LINE FORWARD
U+008c PARTIAL LINE BACKWARD
U+008d REVERSE LINE FEED
U+008e SINGLE SHIFT TWO
U+008f SINGLE SHIFT THREE
U+0090 DEVICE CONTROL STRING
U+0091 PRIVATE USE ONE
U+0092 PRIVATE USE TWO
U+0093 SET TRANSMIT STATE
U+0094 CANCEL CHARACTER
U+0095 MESSAGE WAITING
U+0096 START OF GUARDED AREA
U+0097 END OF GUARDED AREA
U+0098 START OF STRING
U+0099 <control>
U+009a SINGLE CHARACTER INTRODUCER
U+009b CONTROL SEQUENCE INTRODUCER
U+009c STRING TERMINATOR
U+009d OPERATING SYSTEM COMMAND
U+009e PRIVACY MESSAGE
U+009f APPLICATION PROGRAM COMMAND
U+00ad SOFT HYPHEN

/[[:digit:]]/
# none

/[[:graph:]]/
U+00a1 INVERTED EXCLAMATION MARK
U+00a2 CENT SIGN
U+00a3 POUND SIGN
U+00a4 CURRENCY SIGN
U+00a5 YEN SIGN
U+00a6 BROKEN BAR
U+00a7 SECTION SIGN
U+00a8 DIAERESIS
U+00a9 COPYRIGHT SIGN
U+00aa FEMININE ORDINAL INDICATOR
U+00ab LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
U+00ac NOT SIGN
U+00ad SOFT HYPHEN
U+00ae REGISTERED SIGN
U+00af MACRON
U+00b0 DEGREE SIGN
U+00b1 PLUS-MINUS SIGN
U+00b2 SUPERSCRIPT TWO
U+00b3 SUPERSCRIPT THREE
U+00b4 ACUTE ACCENT
U+00b5 MICRO SIGN
U+00b6 PILCROW SIGN
U+00b7 MIDDLE DOT
U+00b8 CEDILLA
U+00b9 SUPERSCRIPT ONE
U+00ba MASCULINE ORDINAL INDICATOR
U+00bb RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
U+00bc VULGAR FRACTION ONE QUARTER
U+00bd VULGAR FRACTION ONE HALF
U+00be VULGAR FRACTION THREE QUARTERS
U+00bf INVERTED QUESTION MARK
U+00c0 LATIN CAPITAL LETTER A WITH GRAVE
U+00c1 LATIN CAPITAL LETTER A WITH ACUTE
U+00c2 LATIN CAPITAL LETTER A WITH CIRCUMFLEX
U+00c3 LATIN CAPITAL LETTER A WITH TILDE
U+00c4 LATIN CAPITAL LETTER A WITH DIAERESIS
U+00c5 LATIN CAPITAL LETTER A WITH RING ABOVE
U+00c6 LATIN CAPITAL LETTER AE
U+00c7 LATIN CAPITAL LETTER C WITH CEDILLA
U+00c8 LATIN CAPITAL LETTER E WITH GRAVE
U+00c9 LATIN CAPITAL LETTER E WITH ACUTE
U+00ca LATIN CAPITAL LETTER E WITH CIRCUMFLEX
U+00cb LATIN CAPITAL LETTER E WITH DIAERESIS
U+00cc LATIN CAPITAL LETTER I WITH GRAVE
U+00cd LATIN CAPITAL LETTER I WITH ACUTE
U+00ce LATIN CAPITAL LETTER I WITH CIRCUMFLEX
U+00cf LATIN CAPITAL LETTER I WITH DIAERESIS
U+00d0 LATIN CAPITAL LETTER ETH
U+00d1 LATIN CAPITAL LETTER N WITH TILDE
U+00d2 LATIN CAPITAL LETTER O WITH GRAVE
U+00d3 LATIN CAPITAL LETTER O WITH ACUTE
U+00d4 LATIN CAPITAL LETTER O WITH CIRCUMFLEX
U+00d5 LATIN CAPITAL LETTER O WITH TILDE
U+00d6 LATIN CAPITAL LETTER O WITH DIAERESIS
U+00d7 MULTIPLICATION SIGN
U+00d8 LATIN CAPITAL LETTER O WITH STROKE
U+00d9 LATIN CAPITAL LETTER U WITH GRAVE
U+00da LATIN CAPITAL LETTER U WITH ACUTE
U+00db LATIN CAPITAL LETTER U WITH CIRCUMFLEX
U+00dc LATIN CAPITAL LETTER U WITH DIAERESIS
U+00dd LATIN CAPITAL LETTER Y WITH ACUTE
U+00de LATIN CAPITAL LETTER THORN
U+00df LATIN SMALL LETTER SHARP S
U+00e0 LATIN SMALL LETTER A WITH GRAVE
U+00e1 LATIN SMALL LETTER A WITH ACUTE
U+00e2 LATIN SMALL LETTER A WITH CIRCUMFLEX
U+00e3 LATIN SMALL LETTER A WITH TILDE
U+00e4 LATIN SMALL LETTER A WITH DIAERESIS
U+00e5 LATIN SMALL LETTER A WITH RING ABOVE
U+00e6 LATIN SMALL LETTER AE
U+00e7 LATIN SMALL LETTER C WITH CEDILLA
U+00e8 LATIN SMALL LETTER E WITH GRAVE
U+00e9 LATIN SMALL LETTER E WITH ACUTE
U+00ea LATIN SMALL LETTER E WITH CIRCUMFLEX
U+00eb LATIN SMALL LETTER E WITH DIAERESIS
U+00ec LATIN SMALL LETTER I WITH GRAVE
U+00ed LATIN SMALL LETTER I WITH ACUTE
U+00ee LATIN SMALL LETTER I WITH CIRCUMFLEX
U+00ef LATIN SMALL LETTER I WITH DIAERESIS
U+00f0 LATIN SMALL LETTER ETH
U+00f1 LATIN SMALL LETTER N WITH TILDE
U+00f2 LATIN SMALL LETTER O WITH GRAVE
U+00f3 LATIN SMALL LETTER O WITH ACUTE
U+00f4 LATIN SMALL LETTER O WITH CIRCUMFLEX
U+00f5 LATIN SMALL LETTER O WITH TILDE
U+00f6 LATIN SMALL LETTER O WITH DIAERESIS
U+00f7 DIVISION SIGN
U+00f8 LATIN SMALL LETTER O WITH STROKE
U+00f9 LATIN SMALL LETTER U WITH GRAVE
U+00fa LATIN SMALL LETTER U WITH ACUTE
U+00fb LATIN SMALL LETTER U WITH CIRCUMFLEX
U+00fc LATIN SMALL LETTER U WITH DIAERESIS
U+00fd LATIN SMALL LETTER Y WITH ACUTE
U+00fe LATIN SMALL LETTER THORN
U+00ff LATIN SMALL LETTER Y WITH DIAERESIS

/[[:lower:]]/
U+00aa FEMININE ORDINAL INDICATOR
U+00b5 MICRO SIGN
U+00ba MASCULINE ORDINAL INDICATOR
U+00df LATIN SMALL LETTER SHARP S
U+00e0 LATIN SMALL LETTER A WITH GRAVE
U+00e1 LATIN SMALL LETTER A WITH ACUTE
U+00e2 LATIN SMALL LETTER A WITH CIRCUMFLEX
U+00e3 LATIN SMALL LETTER A WITH TILDE
U+00e4 LATIN SMALL LETTER A WITH DIAERESIS
U+00e5 LATIN SMALL LETTER A WITH RING ABOVE
U+00e6 LATIN SMALL LETTER AE
U+00e7 LATIN SMALL LETTER C WITH CEDILLA
U+00e8 LATIN SMALL LETTER E WITH GRAVE
U+00e9 LATIN SMALL LETTER E WITH ACUTE
U+00ea LATIN SMALL LETTER E WITH CIRCUMFLEX
U+00eb LATIN SMALL LETTER E WITH DIAERESIS
U+00ec LATIN SMALL LETTER I WITH GRAVE
U+00ed LATIN SMALL LETTER I WITH ACUTE
U+00ee LATIN SMALL LETTER I WITH CIRCUMFLEX
U+00ef LATIN SMALL LETTER I WITH DIAERESIS
U+00f0 LATIN SMALL LETTER ETH
U+00f1 LATIN SMALL LETTER N WITH TILDE
U+00f2 LATIN SMALL LETTER O WITH GRAVE
U+00f3 LATIN SMALL LETTER O WITH ACUTE
U+00f4 LATIN SMALL LETTER O WITH CIRCUMFLEX
U+00f5 LATIN SMALL LETTER O WITH TILDE
U+00f6 LATIN SMALL LETTER O WITH DIAERESIS
U+00f8 LATIN SMALL LETTER O WITH STROKE
U+00f9 LATIN SMALL LETTER U WITH GRAVE
U+00fa LATIN SMALL LETTER U WITH ACUTE
U+00fb LATIN SMALL LETTER U WITH CIRCUMFLEX
U+00fc LATIN SMALL LETTER U WITH DIAERESIS
U+00fd LATIN SMALL LETTER Y WITH ACUTE
U+00fe LATIN SMALL LETTER THORN
U+00ff LATIN SMALL LETTER Y WITH DIAERESIS

/[[:print:]]/
U+0085 NEXT LINE (NEL)
U+00a0 NO-BREAK SPACE
U+00a1 INVERTED EXCLAMATION MARK
U+00a2 CENT SIGN
U+00a3 POUND SIGN
U+00a4 CURRENCY SIGN
U+00a5 YEN SIGN
U+00a6 BROKEN BAR
U+00a7 SECTION SIGN
U+00a8 DIAERESIS
U+00a9 COPYRIGHT SIGN
U+00aa FEMININE ORDINAL INDICATOR
U+00ab LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
U+00ac NOT SIGN
U+00ad SOFT HYPHEN
U+00ae REGISTERED SIGN
U+00af MACRON
U+00b0 DEGREE SIGN
U+00b1 PLUS-MINUS SIGN
U+00b2 SUPERSCRIPT TWO
U+00b3 SUPERSCRIPT THREE
U+00b4 ACUTE ACCENT
U+00b5 MICRO SIGN
U+00b6 PILCROW SIGN
U+00b7 MIDDLE DOT
U+00b8 CEDILLA
U+00b9 SUPERSCRIPT ONE
U+00ba MASCULINE ORDINAL INDICATOR
U+00bb RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
U+00bc VULGAR FRACTION ONE QUARTER
U+00bd VULGAR FRACTION ONE HALF
U+00be VULGAR FRACTION THREE QUARTERS
U+00bf INVERTED QUESTION MARK
U+00c0 LATIN CAPITAL LETTER A WITH GRAVE
U+00c1 LATIN CAPITAL LETTER A WITH ACUTE
U+00c2 LATIN CAPITAL LETTER A WITH CIRCUMFLEX
U+00c3 LATIN CAPITAL LETTER A WITH TILDE
U+00c4 LATIN CAPITAL LETTER A WITH DIAERESIS
U+00c5 LATIN CAPITAL LETTER A WITH RING ABOVE
U+00c6 LATIN CAPITAL LETTER AE
U+00c7 LATIN CAPITAL LETTER C WITH CEDILLA
U+00c8 LATIN CAPITAL LETTER E WITH GRAVE
U+00c9 LATIN CAPITAL LETTER E WITH ACUTE
U+00ca LATIN CAPITAL LETTER E WITH CIRCUMFLEX
U+00cb LATIN CAPITAL LETTER E WITH DIAERESIS
U+00cc LATIN CAPITAL LETTER I WITH GRAVE
U+00cd LATIN CAPITAL LETTER I WITH ACUTE
U+00ce LATIN CAPITAL LETTER I WITH CIRCUMFLEX
U+00cf LATIN CAPITAL LETTER I WITH DIAERESIS
U+00d0 LATIN CAPITAL LETTER ETH
U+00d1 LATIN CAPITAL LETTER N WITH TILDE
U+00d2 LATIN CAPITAL LETTER O WITH GRAVE
U+00d3 LATIN CAPITAL LETTER O WITH ACUTE
U+00d4 LATIN CAPITAL LETTER O WITH CIRCUMFLEX
U+00d5 LATIN CAPITAL LETTER O WITH TILDE
U+00d6 LATIN CAPITAL LETTER O WITH DIAERESIS
U+00d7 MULTIPLICATION SIGN
U+00d8 LATIN CAPITAL LETTER O WITH STROKE
U+00d9 LATIN CAPITAL LETTER U WITH GRAVE
U+00da LATIN CAPITAL LETTER U WITH ACUTE
U+00db LATIN CAPITAL LETTER U WITH CIRCUMFLEX
U+00dc LATIN CAPITAL LETTER U WITH DIAERESIS
U+00dd LATIN CAPITAL LETTER Y WITH ACUTE
U+00de LATIN CAPITAL LETTER THORN
U+00df LATIN SMALL LETTER SHARP S
U+00e0 LATIN SMALL LETTER A WITH GRAVE
U+00e1 LATIN SMALL LETTER A WITH ACUTE
U+00e2 LATIN SMALL LETTER A WITH CIRCUMFLEX
U+00e3 LATIN SMALL LETTER A WITH TILDE
U+00e4 LATIN SMALL LETTER A WITH DIAERESIS
U+00e5 LATIN SMALL LETTER A WITH RING ABOVE
U+00e6 LATIN SMALL LETTER AE
U+00e7 LATIN SMALL LETTER C WITH CEDILLA
U+00e8 LATIN SMALL LETTER E WITH GRAVE
U+00e9 LATIN SMALL LETTER E WITH ACUTE
U+00ea LATIN SMALL LETTER E WITH CIRCUMFLEX
U+00eb LATIN SMALL LETTER E WITH DIAERESIS
U+00ec LATIN SMALL LETTER I WITH GRAVE
U+00ed LATIN SMALL LETTER I WITH ACUTE
U+00ee LATIN SMALL LETTER I WITH CIRCUMFLEX
U+00ef LATIN SMALL LETTER I WITH DIAERESIS
U+00f0 LATIN SMALL LETTER ETH
U+00f1 LATIN SMALL LETTER N WITH TILDE
U+00f2 LATIN SMALL LETTER O WITH GRAVE
U+00f3 LATIN SMALL LETTER O WITH ACUTE
U+00f4 LATIN SMALL LETTER O WITH CIRCUMFLEX
U+00f5 LATIN SMALL LETTER O WITH TILDE
U+00f6 LATIN SMALL LETTER O WITH DIAERESIS
U+00f7 DIVISION SIGN
U+00f8 LATIN SMALL LETTER O WITH STROKE
U+00f9 LATIN SMALL LETTER U WITH GRAVE
U+00fa LATIN SMALL LETTER U WITH ACUTE
U+00fb LATIN SMALL LETTER U WITH CIRCUMFLEX
U+00fc LATIN SMALL LETTER U WITH DIAERESIS
U+00fd LATIN SMALL LETTER Y WITH ACUTE
U+00fe LATIN SMALL LETTER THORN
U+00ff LATIN SMALL LETTER Y WITH DIAERESIS

/[[:punct:]]/
U+00a1 INVERTED EXCLAMATION MARK
U+00ab LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
U+00b7 MIDDLE DOT
U+00bb RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
U+00bf INVERTED QUESTION MARK

/[[:space:]]/
U+0085 NEXT LINE (NEL)
U+00a0 NO-BREAK SPACE

/[[:upper:]]/
U+00c0 LATIN CAPITAL LETTER A WITH GRAVE
U+00c1 LATIN CAPITAL LETTER A WITH ACUTE
U+00c2 LATIN CAPITAL LETTER A WITH CIRCUMFLEX
U+00c3 LATIN CAPITAL LETTER A WITH TILDE
U+00c4 LATIN CAPITAL LETTER A WITH DIAERESIS
U+00c5 LATIN CAPITAL LETTER A WITH RING ABOVE
U+00c6 LATIN CAPITAL LETTER AE
U+00c7 LATIN CAPITAL LETTER C WITH CEDILLA
U+00c8 LATIN CAPITAL LETTER E WITH GRAVE
U+00c9 LATIN CAPITAL LETTER E WITH ACUTE
U+00ca LATIN CAPITAL LETTER E WITH CIRCUMFLEX
U+00cb LATIN CAPITAL LETTER E WITH DIAERESIS
U+00cc LATIN CAPITAL LETTER I WITH GRAVE
U+00cd LATIN CAPITAL LETTER I WITH ACUTE
U+00ce LATIN CAPITAL LETTER I WITH CIRCUMFLEX
U+00cf LATIN CAPITAL LETTER I WITH DIAERESIS
U+00d0 LATIN CAPITAL LETTER ETH
U+00d1 LATIN CAPITAL LETTER N WITH TILDE
U+00d2 LATIN CAPITAL LETTER O WITH GRAVE
U+00d3 LATIN CAPITAL LETTER O WITH ACUTE
U+00d4 LATIN CAPITAL LETTER O WITH CIRCUMFLEX
U+00d5 LATIN CAPITAL LETTER O WITH TILDE
U+00d6 LATIN CAPITAL LETTER O WITH DIAERESIS
U+00d8 LATIN CAPITAL LETTER O WITH STROKE
U+00d9 LATIN CAPITAL LETTER U WITH GRAVE
U+00da LATIN CAPITAL LETTER U WITH ACUTE
U+00db LATIN CAPITAL LETTER U WITH CIRCUMFLEX
U+00dc LATIN CAPITAL LETTER U WITH DIAERESIS
U+00dd LATIN CAPITAL LETTER Y WITH ACUTE
U+00de LATIN CAPITAL LETTER THORN

/[[:word:]]/
U+00aa FEMININE ORDINAL INDICATOR
U+00b2 SUPERSCRIPT TWO
U+00b3 SUPERSCRIPT THREE
U+00b5 MICRO SIGN
U+00b9 SUPERSCRIPT ONE
U+00ba MASCULINE ORDINAL INDICATOR
U+00bc VULGAR FRACTION ONE QUARTER
U+00bd VULGAR FRACTION ONE HALF
U+00be VULGAR FRACTION THREE QUARTERS
U+00c0 LATIN CAPITAL LETTER A WITH GRAVE
U+00c1 LATIN CAPITAL LETTER A WITH ACUTE
U+00c2 LATIN CAPITAL LETTER A WITH CIRCUMFLEX
U+00c3 LATIN CAPITAL LETTER A WITH TILDE
U+00c4 LATIN CAPITAL LETTER A WITH DIAERESIS
U+00c5 LATIN CAPITAL LETTER A WITH RING ABOVE
U+00c6 LATIN CAPITAL LETTER AE
U+00c7 LATIN CAPITAL LETTER C WITH CEDILLA
U+00c8 LATIN CAPITAL LETTER E WITH GRAVE
U+00c9 LATIN CAPITAL LETTER E WITH ACUTE
U+00ca LATIN CAPITAL LETTER E WITH CIRCUMFLEX
U+00cb LATIN CAPITAL LETTER E WITH DIAERESIS
U+00cc LATIN CAPITAL LETTER I WITH GRAVE
U+00cd LATIN CAPITAL LETTER I WITH ACUTE
U+00ce LATIN CAPITAL LETTER I WITH CIRCUMFLEX
U+00cf LATIN CAPITAL LETTER I WITH DIAERESIS
U+00d0 LATIN CAPITAL LETTER ETH
U+00d1 LATIN CAPITAL LETTER N WITH TILDE
U+00d2 LATIN CAPITAL LETTER O WITH GRAVE
U+00d3 LATIN CAPITAL LETTER O WITH ACUTE
U+00d4 LATIN CAPITAL LETTER O WITH CIRCUMFLEX
U+00d5 LATIN CAPITAL LETTER O WITH TILDE
U+00d6 LATIN CAPITAL LETTER O WITH DIAERESIS
U+00d8 LATIN CAPITAL LETTER O WITH STROKE
U+00d9 LATIN CAPITAL LETTER U WITH GRAVE
U+00da LATIN CAPITAL LETTER U WITH ACUTE
U+00db LATIN CAPITAL LETTER U WITH CIRCUMFLEX
U+00dc LATIN CAPITAL LETTER U WITH DIAERESIS
U+00dd LATIN CAPITAL LETTER Y WITH ACUTE
U+00de LATIN CAPITAL LETTER THORN
U+00df LATIN SMALL LETTER SHARP S
U+00e0 LATIN SMALL LETTER A WITH GRAVE
U+00e1 LATIN SMALL LETTER A WITH ACUTE
U+00e2 LATIN SMALL LETTER A WITH CIRCUMFLEX
U+00e3 LATIN SMALL LETTER A WITH TILDE
U+00e4 LATIN SMALL LETTER A WITH DIAERESIS
U+00e5 LATIN SMALL LETTER A WITH RING ABOVE
U+00e6 LATIN SMALL LETTER AE
U+00e7 LATIN SMALL LETTER C WITH CEDILLA
U+00e8 LATIN SMALL LETTER E WITH GRAVE
U+00e9 LATIN SMALL LETTER E WITH ACUTE
U+00ea LATIN SMALL LETTER E WITH CIRCUMFLEX
U+00eb LATIN SMALL LETTER E WITH DIAERESIS
U+00ec LATIN SMALL LETTER I WITH GRAVE
U+00ed LATIN SMALL LETTER I WITH ACUTE
U+00ee LATIN SMALL LETTER I WITH CIRCUMFLEX
U+00ef LATIN SMALL LETTER I WITH DIAERESIS
U+00f0 LATIN SMALL LETTER ETH
U+00f1 LATIN SMALL LETTER N WITH TILDE
U+00f2 LATIN SMALL LETTER O WITH GRAVE
U+00f3 LATIN SMALL LETTER O WITH ACUTE
U+00f4 LATIN SMALL LETTER O WITH CIRCUMFLEX
U+00f5 LATIN SMALL LETTER O WITH TILDE
U+00f6 LATIN SMALL LETTER O WITH DIAERESIS
U+00f8 LATIN SMALL LETTER O WITH STROKE
U+00f9 LATIN SMALL LETTER U WITH GRAVE
U+00fa LATIN SMALL LETTER U WITH ACUTE
U+00fb LATIN SMALL LETTER U WITH CIRCUMFLEX
U+00fc LATIN SMALL LETTER U WITH DIAERESIS
U+00fd LATIN SMALL LETTER Y WITH ACUTE
U+00fe LATIN SMALL LETTER THORN
U+00ff LATIN SMALL LETTER Y WITH DIAERESIS

/[[:xdigit:]]/
# none
