# Generated by default/object.tt
package Paws::AppMesh::TlsValidationContextTrust;
  use Moose;
  has Acm => (is => 'ro', isa => 'Paws::AppMesh::TlsValidationContextAcmTrust', request_name => 'acm', traits => ['NameInRequest']);
  has File => (is => 'ro', isa => 'Paws::AppMesh::TlsValidationContextFileTrust', request_name => 'file', traits => ['NameInRequest']);
  has Sds => (is => 'ro', isa => 'Paws::AppMesh::TlsValidationContextSdsTrust', request_name => 'sds', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AppMesh::TlsValidationContextTrust

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AppMesh::TlsValidationContextTrust object:

  $service_obj->Method(Att1 => { Acm => $value, ..., Sds => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AppMesh::TlsValidationContextTrust object:

  $result = $service_obj->Method(...);
  $result->Att1->Acm

=head1 DESCRIPTION

An object that represents a Transport Layer Security (TLS) validation
context trust.

=head1 ATTRIBUTES


=head2 Acm => L<Paws::AppMesh::TlsValidationContextAcmTrust>

A reference to an object that represents a Transport Layer Security
(TLS) validation context trust for an Certificate Manager certificate.


=head2 File => L<Paws::AppMesh::TlsValidationContextFileTrust>

An object that represents a Transport Layer Security (TLS) validation
context trust for a local file.


=head2 Sds => L<Paws::AppMesh::TlsValidationContextSdsTrust>

A reference to an object that represents a Transport Layer Security
(TLS) Secret Discovery Service validation context trust.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AppMesh>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

