# Generated by default/object.tt
package Paws::Personalize::OptimizationObjective;
  use Moose;
  has ItemAttribute => (is => 'ro', isa => 'Str', request_name => 'itemAttribute', traits => ['NameInRequest']);
  has ObjectiveSensitivity => (is => 'ro', isa => 'Str', request_name => 'objectiveSensitivity', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Personalize::OptimizationObjective

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Personalize::OptimizationObjective object:

  $service_obj->Method(Att1 => { ItemAttribute => $value, ..., ObjectiveSensitivity => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Personalize::OptimizationObjective object:

  $result = $service_obj->Method(...);
  $result->Att1->ItemAttribute

=head1 DESCRIPTION

Describes the additional objective for the solution, such as maximizing
streaming minutes or increasing revenue. For more information see
Optimizing a solution
(https://docs.aws.amazon.com/personalize/latest/dg/optimizing-solution-for-objective.html).

=head1 ATTRIBUTES


=head2 ItemAttribute => Str

The numerical metadata column in an Items dataset related to the
optimization objective. For example, VIDEO_LENGTH (to maximize
streaming minutes), or PRICE (to maximize revenue).


=head2 ObjectiveSensitivity => Str

Specifies how Amazon Personalize balances the importance of your
optimization objective versus relevance.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Personalize>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

