package App::DuckPAN::Cmd::Test;
our $AUTHORITY = 'cpan:DDG';
# ABSTRACT: Command for running the tests of this library
$App::DuckPAN::Cmd::Test::VERSION = '0.188';
use MooX;
with qw( App::DuckPAN::Cmd );

use MooX::Options protect_argv => 0;

option full => (
	is          => 'ro',
	lazy        => 1,
	short       => 'f',
	default     => sub { 0 },
	doc         => 'run full test suite via dzil',
);

sub run {
	my ( $self ) = @_;

	my $ret = 0;

	if ($self->full) {
		$self->app->emit_error("Could not find dist.ini.") unless -e "dist.ini";
		$self->app->emit_error("Could not begin testing. Is Dist::Zilla installed?") if $ret = system("dzil test");
	} else {
		$self->app->emit_error("Tests failed! See output above for details") if $ret = system("prove -Ilib");
	}

	return $ret;
}

1;

__END__

=pod

=head1 NAME

App::DuckPAN::Cmd::Test - Command for running the tests of this library

=head1 VERSION

version 0.188

=head1 AUTHOR

Torsten Raudssus <torsten@raudss.us> L<https://raudss.us/>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2013 by DuckDuckGo, Inc. L<https://duckduckgo.com/>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
