#!/usr/bin/env perl
use v5.24;
use warnings;
use experimental 'signatures';

use Test::More;
use Test::Exception;

use File::Basename 'dirname';
use lib dirname(__FILE__);    # basic functions

eval { require Data::Resolver::FromTar; 1 }
  or BAIL_OUT 'cannot load base class';

my $datafile = __FILE__ . 'ar';

ok -f $datafile, "data file for tests exists";

my $resolver;
lives_ok { $resolver = Data::Resolver::FromTar->new(root => $datafile) }
'call to constructor lives';
isa_ok $resolver, 'Data::Resolver::FromTar';

my @asset_keys;
lives_ok { @asset_keys = $resolver->list_asset_keys } 'list_asset_keys';
is scalar(@asset_keys), 1,          'no. of asset keys'
   or diag("asset_keys(@asset_keys)");
is $asset_keys[0],      'ciao.txt', 'asset key';

my @subr_keys;
lives_ok { @subr_keys = $resolver->list_sub_resolver_keys }
'list sub-resolver keys';
is scalar(@subr_keys), 1, 'no. of sub-resolver keys'
   or diag("sub_resolver_keys(@subr_keys)");
is $subr_keys[0], 'foo', 'sub-resolver key';

ok $resolver->has_asset('ciao.txt'), 'has_asset';
ok $resolver->has_sub_resolver('foo'), 'has_sub_resolver';

my $asset = $resolver->get_asset('ciao.txt');
isa_ok $asset, 'Data::Resolver::Asset';
my $data = $asset->raw_data =~ s{\s+}{}rgmxs;
is $data, 'ciao', 'data from asset';

my $subr = $resolver->get_sub_resolver('foo');
isa_ok $subr, 'Data::Resolver::FromTar';
@asset_keys = $subr->list_asset_keys;
is scalar(@asset_keys), 1, 'assets in sub-resolvers';
is $asset_keys[0], 'bar.txt', 'asset key in sub-resolver';

$asset = $subr->get_asset('bar.txt');
$data = $asset->raw_data =~ s{\s+}{}rgmxs;
is $data, 'baz', 'contents of asset in sub-resolver';

ok $subr->has_sub_resolver('galook'), 'sub-sub-resolver exists';
my $subsubr = $subr->get_sub_resolver('galook');
$asset = $subsubr->get_asset('final.txt');
$data = $asset->raw_data =~ s{\s+}{}rgmxs;
is $data, 'thisisit', 'contents of asset in sub-resolver';

done_testing();
