# Copyright (C) 2003 Konstantin Korikov

#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

importer_class = "GnomePPPImporter"
    
import ConfigParser
import re
import os.path
import locale
import importer
import chestnut_dialer.account_set
from chestnut_dialer import _

try: default_encoding = locale.getpreferredencoding()
except: default_encoding = 'ASCII'

class Account(chestnut_dialer.account_set.Account):
  _acc_conf = None
  _section = None
  _id = None
  _encoding = None
  def __init__(self, acc_conf, acc_id, encoding):
    chestnut_dialer.account_set.Account.__init__(self)
    self._acc_conf = acc_conf
    self._id = acc_id
    self._section = "%d,Account" % acc_id
    self._encoding = encoding
  def _get_acc_attr(self, name):
    acc_conf = self._acc_conf
    section = self._section
    if name == "id": return self._id
    if name == "auth_type": return u"pap/chap"
    if name == "use_script": return u"predef-auto"
    if name == "phone_numbers":
      l = []
      for i in range(0, 99):
	try: l.append(unicode(acc_conf.get(section, 
	  "%d,phone_number" % i), self._encoding))
	except ConfigParser.NoOptionError: break
      return l
    if name == "dns_servers":
      l = []
      for i in range(0, 99):
	try: l.append(unicode(acc_conf.get(section, 
	  "%d,dns_server" % i), self._encoding))
	except ConfigParser.NoOptionError: break
      return l
    try: value = unicode(acc_conf.get(section, name), self._encoding)
    except ConfigParser.NoOptionError: return None
    atype = self.get_attr_type(name)
    if value == "" and (atype in ('integer', 'boolean') or name in (
      ['ip',
       'mask',
       'modem_device',
       'modem_flow',
       'modem_term',
       'remote',
       'speed'])): return None
    if value == "0" and name in (	
      'dial_timeout',
      'mru',
      'mtu',
      'redial_attempts',
      'speed'): return None
    if atype == 'boolean':
      return value.lower() in ("true", "yes", "on", "1")
    if atype == 'integer':
      try: return int(value)
      except ValueError: return None
    return value

class GnomePPPImporter(chestnut_dialer.account_set.AccountSet):
  __doc__ = _("Import accounts from gnome-ppp")
  author = _("Konstantin Korikov")
  constructor_args = (
    {
      "name": "file_name",
      "type": "filename",
      "display": _("Source File"),
      "default":  os.path.expanduser("~/.gnome/gnome-ppp"),
    },
    {
      "name": "encoding",
      "type": "string",
      "display": _("Encoding"),
      "default": default_encoding,
    },
  )
  program = "gnome-ppp"
  acc_conf = None
  encoding = None
  def __init__(self, file_name, encoding):
    self.acc_conf = ConfigParser.ConfigParser()
    try: self.acc_conf.read(file_name)
    except: pass
    if not self.acc_conf.sections():
      raise importer.ConstructImporterException(
      _("The source file is empty or broken"))
    self.encoding = encoding
  def ls_accounts(self):
    accounts = []
    regexp = re.compile(r'(\d+),Account')
    for section in self.acc_conf.sections():
      m = regexp.match(unicode(section, self.encoding))
      if m:
        try:
          name = unicode(self.acc_conf.get(section, "name"), self.encoding)
	except ConfigParser.NoOptionError: name = u""
        accounts.append((name, int(m.group(1))))
    return accounts
  def get_account(self, account_id):
    return Account(self.acc_conf, account_id, self.encoding)
