#!/usr/bin/env python
#
# mintInput
#
# Written  by Kendall Weaver <kendalltweaver@gmail.com>
# Modified by Ikey Doherty <contactjfreak@googlemail.com>
# Graphical settings tool written for the Linux Mint Fluxbox edition
# to replace Simple-Mouse and Simple-Keyboard with a single, better
# featured application.
import sys

try:
	import pygtk
	pygtk.require("2.0")
except:
	print "You do not have the required PyGTK version."
	sys.exit(1)
try:
	import gtk
	import os
	import gettext
except:
	print "You do not have the required dependencies"
	sys.exit(1)

gettext.install("mintinput", "/usr/share/linuxmint/locale")
class MintInput:

	def __init__(self):
		self.glade  = '/usr/lib/linuxmint/mintinput/mintinput.glade'
		self.builder = gtk.Builder()
		self.builder.add_from_file(self.glade)

		self.window = self.builder.get_object("main_window")
		self.window.set_title(_("Keyboard and Mouse"))
		self.window.connect("destroy", gtk.main_quit)
		self.window.show()

		# labels for notebook
		self.builder.get_object("label_keyboard").set_label(_("Keyboard"))
		self.builder.get_object("label_mouse").set_label(_("Mouse"))

		# images for tabs and window
		try:
			self.window.set_icon_from_file("/usr/lib/linuxmint/mintinput/mouse.png")
			self.mouse = gtk.gdk.pixbuf_new_from_file("/usr/lib/linuxmint/mintinput/mouse.png")
			self.keys = gtk.gdk.pixbuf_new_from_file("/usr/lib/linuxmint/mintinput/keyboard.png")
		except Exception, e:
			print e.message
			sys.exit(1)

		# set images on tabs
		self.builder.get_object("image_mouse").set_from_pixbuf(self.mouse)
		self.builder.get_object("image_keyboard").set_from_pixbuf(self.keys)

		self.builder.get_object("button_layout").set_label(_("Select layout"))
		self.builder.get_object("button_layout").connect("clicked", self.layout_cb)

		# keyboard delay
		self.builder.get_object("label_delay").set_label(_("Delay"))
		delay = self.builder.get_object("scale_delay")
		delay.set_range(10, 1000)
		delay.set_increments(1, 1)
		delay.set_digits(0)
		delay.set_value(500)

		# interval
		self.builder.get_object("label_interval").set_label(_("Interval"))
		interval = self.builder.get_object("scale_interval")
		interval.set_range(1, 50)
		interval.set_increments(1, 1)
		interval.set_digits(0)
		interval.set_value(20)

		# checkbuttons for mouse page
		self.builder.get_object("checkbutton_touchpad").set_label(_("Touchpad Enabled"))
		self.builder.get_object("checkbutton_lhd").set_label(_("Left Handed"))
		self.builder.get_object("checkbutton_touchpad").set_active(True)
		self.builder.get_object("checkbutton_touchpad").connect("clicked", self.touchpad_cb)

		# accel.
		self.builder.get_object("label_acceleration").set_label(_("Acceleration"))
		accel = self.builder.get_object("scale_acceleration")
		accel.set_range(0, 10)
		accel.set_increments(1, 2)
		accel.set_digits(0)
		accel.set_value(2)
		# threshold
		self.builder.get_object("label_threshold").set_label(_("Threshold"))
		threshold = self.builder.get_object("scale_threshold")
		threshold.set_range(0, 10)
		threshold.set_increments(1, 2)
		threshold.set_digits(0)
		threshold.set_value(2)

		self.builder.get_object("button_cancel").connect("clicked", gtk.main_quit)
		self.builder.get_object("button_apply").connect("clicked", self.apply_cb)

	def touchpad_cb(self, w):
		pad = str("synclient TouchPadOff=%d" % (int(w.get_active())))
		os.system(pad)

	''' show keyboard layout chooser '''
	def layout_cb(self, w):
		os.system("skl &")

	''' apply all settings '''
	def apply_cb(self, widget):
		sel = self.builder.get_object("notebook").get_current_page()
		if(sel == 0):
			# keyboard stuff.
			w = self.builder.get_object("scale_delay")
			delay = int(w.get_value())
			w = self.builder.get_object("scale_interval")
			interval = int(w.get_value())

			# set settings..
			os.system('echo "#!/bin/sh" > $HOME/.linuxmint/sks')
			os.system('echo "#Autogenerated script - Do not edit" >> $HOME/.linuxmint/sks')
			os.system('echo \"xset r rate ' + str(delay) + ' ' + str(interval) + '\" >> $HOME/.linuxmint/sks')
			os.system("mintinput1")
		else:
			# mouse stuff.
			w = self.builder.get_object("scale_threshold")
			threshold = int(w.get_value())
			w = self.builder.get_object("scale_acceleration")
			accel = int(w.get_value())
			# touchpad settings
			w = self.builder.get_object("checkbutton_touchpad")
			pad = str("synclient TouchPadOff=%d" % (int(not w.get_active())))

			# left handed?
			w = self.builder.get_object("checkbutton_lhd")
			paw = str("pointer = 1 2 3")
			if(w.get_active()):
				paw = str("pointer = 3 2 1")

			# set the settings.
			os.system('echo "#!/bin/sh" > $HOME/.linuxmint/sms')
			os.system('echo "#Autogenerated script - Do not edit" >> $HOME/.linuxmint/sms')
			os.system('echo \"' + pad + '\" >> $HOME/.linuxmint/sms')
			os.system('echo \'xmodmap -e \"' + paw + '\"\' >> $HOME/.linuxmint/sms')
			os.system('echo \"xset m ' + str(accel) + ' ' + str(threshold) + '\" >> $HOME/.linuxmint/sms')
			os.system("mintinput1")

if __name__ == "__main__":
	MintInput()
	gtk.main()

