/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class UnionTypeReference
extends TypeReference {
    public TypeReference[] typeReferences;

    public UnionTypeReference(TypeReference[] typeReferenceArray) {
        this.bits |= 0x20000000;
        this.typeReferences = typeReferenceArray;
        this.sourceStart = typeReferenceArray[0].sourceStart;
        int n = typeReferenceArray.length;
        this.sourceEnd = typeReferenceArray[n - 1].sourceEnd;
    }

    @Override
    public char[] getLastToken() {
        return null;
    }

    @Override
    protected TypeBinding getTypeBinding(Scope scope) {
        return null;
    }

    @Override
    public TypeBinding resolveType(BlockScope blockScope, boolean bl, int n) {
        int n2 = this.typeReferences.length;
        TypeBinding[] typeBindingArray = new TypeBinding[n2];
        boolean bl2 = false;
        for (int i = 0; i < n2; ++i) {
            TypeBinding typeBinding = this.typeReferences[i].resolveType(blockScope, bl, n);
            if (typeBinding == null) {
                return null;
            }
            switch (typeBinding.kind()) {
                case 260: {
                    if (!typeBinding.isBoundParameterizedType()) break;
                    bl2 = true;
                    blockScope.problemReporter().invalidParameterizedExceptionType(typeBinding, this.typeReferences[i]);
                    break;
                }
                case 4100: {
                    blockScope.problemReporter().invalidTypeVariableAsException(typeBinding, this.typeReferences[i]);
                    bl2 = true;
                }
            }
            if (typeBinding.findSuperTypeOriginatingFrom(21, true) == null && typeBinding.isValidBinding()) {
                blockScope.problemReporter().cannotThrowType(this.typeReferences[i], typeBinding);
                bl2 = true;
            }
            typeBindingArray[i] = typeBinding;
            for (int j = 0; j < i; ++j) {
                if (typeBindingArray[j].isCompatibleWith(typeBinding)) {
                    blockScope.problemReporter().wrongSequenceOfExceptionTypes(this.typeReferences[j], typeBindingArray[j], typeBinding);
                    bl2 = true;
                    continue;
                }
                if (!typeBinding.isCompatibleWith(typeBindingArray[j])) continue;
                blockScope.problemReporter().wrongSequenceOfExceptionTypes(this.typeReferences[i], typeBinding, typeBindingArray[j]);
                bl2 = true;
            }
        }
        if (bl2) {
            return null;
        }
        this.resolvedType = blockScope.lowerUpperBound(typeBindingArray);
        return this.resolvedType;
    }

    @Override
    public char[][] getTypeName() {
        return this.typeReferences[0].getTypeName();
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            int n = this.typeReferences == null ? 0 : this.typeReferences.length;
            for (int i = 0; i < n; ++i) {
                this.typeReferences[i].traverse(aSTVisitor, blockScope);
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        if (aSTVisitor.visit(this, classScope)) {
            int n = this.typeReferences == null ? 0 : this.typeReferences.length;
            for (int i = 0; i < n; ++i) {
                this.typeReferences[i].traverse(aSTVisitor, classScope);
            }
        }
        aSTVisitor.endVisit(this, classScope);
    }

    @Override
    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        int n2 = this.typeReferences == null ? 0 : this.typeReferences.length;
        UnionTypeReference.printIndent(n, stringBuffer);
        for (int i = 0; i < n2; ++i) {
            this.typeReferences[i].printExpression(0, stringBuffer);
            if (i == n2 - 1) continue;
            stringBuffer.append(" | ");
        }
        return stringBuffer;
    }

    @Override
    public boolean isUnionType() {
        return true;
    }

    @Override
    public TypeReference augmentTypeWithAdditionalDimensions(int n, Annotation[][] annotationArray, boolean bl) {
        return this;
    }
}

