/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLOntology;

public class DefinedClassPredicate
implements Predicate<OWLClass> {
    private final Set<OWLOntology> ontologies;

    public DefinedClassPredicate(@Nonnull Set<OWLOntology> ontologies) {
        this.ontologies = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(ontologies)));
    }

    @Override
    public boolean test(@Nonnull OWLClass c) {
        Preconditions.checkNotNull((Object)c);
        for (OWLOntology ontology : this.ontologies) {
            if (!ontology.getEquivalentClassesAxioms(c).isEmpty()) {
                return true;
            }
            if (ontology.getDisjointUnionAxioms(c).isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public static Predicate<OWLClass> isDefinedIn(@Nonnull Set<OWLOntology> ontologies) {
        return new DefinedClassPredicate(ontologies);
    }

    public static Predicate<OWLClass> isNotDefinedIn(@Nonnull Set<OWLOntology> ontologies) {
        return DefinedClassPredicate.isDefinedIn(ontologies).negate();
    }
}

