"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudFormation = void 0;
const smithy_client_1 = require("@smithy/smithy-client");
const CloudFormationClient_1 = require("./CloudFormationClient");
const ActivateOrganizationsAccessCommand_1 = require("./commands/ActivateOrganizationsAccessCommand");
const ActivateTypeCommand_1 = require("./commands/ActivateTypeCommand");
const BatchDescribeTypeConfigurationsCommand_1 = require("./commands/BatchDescribeTypeConfigurationsCommand");
const CancelUpdateStackCommand_1 = require("./commands/CancelUpdateStackCommand");
const ContinueUpdateRollbackCommand_1 = require("./commands/ContinueUpdateRollbackCommand");
const CreateChangeSetCommand_1 = require("./commands/CreateChangeSetCommand");
const CreateStackCommand_1 = require("./commands/CreateStackCommand");
const CreateStackInstancesCommand_1 = require("./commands/CreateStackInstancesCommand");
const CreateStackSetCommand_1 = require("./commands/CreateStackSetCommand");
const DeactivateOrganizationsAccessCommand_1 = require("./commands/DeactivateOrganizationsAccessCommand");
const DeactivateTypeCommand_1 = require("./commands/DeactivateTypeCommand");
const DeleteChangeSetCommand_1 = require("./commands/DeleteChangeSetCommand");
const DeleteStackCommand_1 = require("./commands/DeleteStackCommand");
const DeleteStackInstancesCommand_1 = require("./commands/DeleteStackInstancesCommand");
const DeleteStackSetCommand_1 = require("./commands/DeleteStackSetCommand");
const DeregisterTypeCommand_1 = require("./commands/DeregisterTypeCommand");
const DescribeAccountLimitsCommand_1 = require("./commands/DescribeAccountLimitsCommand");
const DescribeChangeSetCommand_1 = require("./commands/DescribeChangeSetCommand");
const DescribeChangeSetHooksCommand_1 = require("./commands/DescribeChangeSetHooksCommand");
const DescribeOrganizationsAccessCommand_1 = require("./commands/DescribeOrganizationsAccessCommand");
const DescribePublisherCommand_1 = require("./commands/DescribePublisherCommand");
const DescribeStackDriftDetectionStatusCommand_1 = require("./commands/DescribeStackDriftDetectionStatusCommand");
const DescribeStackEventsCommand_1 = require("./commands/DescribeStackEventsCommand");
const DescribeStackInstanceCommand_1 = require("./commands/DescribeStackInstanceCommand");
const DescribeStackResourceCommand_1 = require("./commands/DescribeStackResourceCommand");
const DescribeStackResourceDriftsCommand_1 = require("./commands/DescribeStackResourceDriftsCommand");
const DescribeStackResourcesCommand_1 = require("./commands/DescribeStackResourcesCommand");
const DescribeStacksCommand_1 = require("./commands/DescribeStacksCommand");
const DescribeStackSetCommand_1 = require("./commands/DescribeStackSetCommand");
const DescribeStackSetOperationCommand_1 = require("./commands/DescribeStackSetOperationCommand");
const DescribeTypeCommand_1 = require("./commands/DescribeTypeCommand");
const DescribeTypeRegistrationCommand_1 = require("./commands/DescribeTypeRegistrationCommand");
const DetectStackDriftCommand_1 = require("./commands/DetectStackDriftCommand");
const DetectStackResourceDriftCommand_1 = require("./commands/DetectStackResourceDriftCommand");
const DetectStackSetDriftCommand_1 = require("./commands/DetectStackSetDriftCommand");
const EstimateTemplateCostCommand_1 = require("./commands/EstimateTemplateCostCommand");
const ExecuteChangeSetCommand_1 = require("./commands/ExecuteChangeSetCommand");
const GetStackPolicyCommand_1 = require("./commands/GetStackPolicyCommand");
const GetTemplateCommand_1 = require("./commands/GetTemplateCommand");
const GetTemplateSummaryCommand_1 = require("./commands/GetTemplateSummaryCommand");
const ImportStacksToStackSetCommand_1 = require("./commands/ImportStacksToStackSetCommand");
const ListChangeSetsCommand_1 = require("./commands/ListChangeSetsCommand");
const ListExportsCommand_1 = require("./commands/ListExportsCommand");
const ListImportsCommand_1 = require("./commands/ListImportsCommand");
const ListStackInstanceResourceDriftsCommand_1 = require("./commands/ListStackInstanceResourceDriftsCommand");
const ListStackInstancesCommand_1 = require("./commands/ListStackInstancesCommand");
const ListStackResourcesCommand_1 = require("./commands/ListStackResourcesCommand");
const ListStacksCommand_1 = require("./commands/ListStacksCommand");
const ListStackSetOperationResultsCommand_1 = require("./commands/ListStackSetOperationResultsCommand");
const ListStackSetOperationsCommand_1 = require("./commands/ListStackSetOperationsCommand");
const ListStackSetsCommand_1 = require("./commands/ListStackSetsCommand");
const ListTypeRegistrationsCommand_1 = require("./commands/ListTypeRegistrationsCommand");
const ListTypesCommand_1 = require("./commands/ListTypesCommand");
const ListTypeVersionsCommand_1 = require("./commands/ListTypeVersionsCommand");
const PublishTypeCommand_1 = require("./commands/PublishTypeCommand");
const RecordHandlerProgressCommand_1 = require("./commands/RecordHandlerProgressCommand");
const RegisterPublisherCommand_1 = require("./commands/RegisterPublisherCommand");
const RegisterTypeCommand_1 = require("./commands/RegisterTypeCommand");
const RollbackStackCommand_1 = require("./commands/RollbackStackCommand");
const SetStackPolicyCommand_1 = require("./commands/SetStackPolicyCommand");
const SetTypeConfigurationCommand_1 = require("./commands/SetTypeConfigurationCommand");
const SetTypeDefaultVersionCommand_1 = require("./commands/SetTypeDefaultVersionCommand");
const SignalResourceCommand_1 = require("./commands/SignalResourceCommand");
const StopStackSetOperationCommand_1 = require("./commands/StopStackSetOperationCommand");
const TestTypeCommand_1 = require("./commands/TestTypeCommand");
const UpdateStackCommand_1 = require("./commands/UpdateStackCommand");
const UpdateStackInstancesCommand_1 = require("./commands/UpdateStackInstancesCommand");
const UpdateStackSetCommand_1 = require("./commands/UpdateStackSetCommand");
const UpdateTerminationProtectionCommand_1 = require("./commands/UpdateTerminationProtectionCommand");
const ValidateTemplateCommand_1 = require("./commands/ValidateTemplateCommand");
const commands = {
    ActivateOrganizationsAccessCommand: ActivateOrganizationsAccessCommand_1.ActivateOrganizationsAccessCommand,
    ActivateTypeCommand: ActivateTypeCommand_1.ActivateTypeCommand,
    BatchDescribeTypeConfigurationsCommand: BatchDescribeTypeConfigurationsCommand_1.BatchDescribeTypeConfigurationsCommand,
    CancelUpdateStackCommand: CancelUpdateStackCommand_1.CancelUpdateStackCommand,
    ContinueUpdateRollbackCommand: ContinueUpdateRollbackCommand_1.ContinueUpdateRollbackCommand,
    CreateChangeSetCommand: CreateChangeSetCommand_1.CreateChangeSetCommand,
    CreateStackCommand: CreateStackCommand_1.CreateStackCommand,
    CreateStackInstancesCommand: CreateStackInstancesCommand_1.CreateStackInstancesCommand,
    CreateStackSetCommand: CreateStackSetCommand_1.CreateStackSetCommand,
    DeactivateOrganizationsAccessCommand: DeactivateOrganizationsAccessCommand_1.DeactivateOrganizationsAccessCommand,
    DeactivateTypeCommand: DeactivateTypeCommand_1.DeactivateTypeCommand,
    DeleteChangeSetCommand: DeleteChangeSetCommand_1.DeleteChangeSetCommand,
    DeleteStackCommand: DeleteStackCommand_1.DeleteStackCommand,
    DeleteStackInstancesCommand: DeleteStackInstancesCommand_1.DeleteStackInstancesCommand,
    DeleteStackSetCommand: DeleteStackSetCommand_1.DeleteStackSetCommand,
    DeregisterTypeCommand: DeregisterTypeCommand_1.DeregisterTypeCommand,
    DescribeAccountLimitsCommand: DescribeAccountLimitsCommand_1.DescribeAccountLimitsCommand,
    DescribeChangeSetCommand: DescribeChangeSetCommand_1.DescribeChangeSetCommand,
    DescribeChangeSetHooksCommand: DescribeChangeSetHooksCommand_1.DescribeChangeSetHooksCommand,
    DescribeOrganizationsAccessCommand: DescribeOrganizationsAccessCommand_1.DescribeOrganizationsAccessCommand,
    DescribePublisherCommand: DescribePublisherCommand_1.DescribePublisherCommand,
    DescribeStackDriftDetectionStatusCommand: DescribeStackDriftDetectionStatusCommand_1.DescribeStackDriftDetectionStatusCommand,
    DescribeStackEventsCommand: DescribeStackEventsCommand_1.DescribeStackEventsCommand,
    DescribeStackInstanceCommand: DescribeStackInstanceCommand_1.DescribeStackInstanceCommand,
    DescribeStackResourceCommand: DescribeStackResourceCommand_1.DescribeStackResourceCommand,
    DescribeStackResourceDriftsCommand: DescribeStackResourceDriftsCommand_1.DescribeStackResourceDriftsCommand,
    DescribeStackResourcesCommand: DescribeStackResourcesCommand_1.DescribeStackResourcesCommand,
    DescribeStacksCommand: DescribeStacksCommand_1.DescribeStacksCommand,
    DescribeStackSetCommand: DescribeStackSetCommand_1.DescribeStackSetCommand,
    DescribeStackSetOperationCommand: DescribeStackSetOperationCommand_1.DescribeStackSetOperationCommand,
    DescribeTypeCommand: DescribeTypeCommand_1.DescribeTypeCommand,
    DescribeTypeRegistrationCommand: DescribeTypeRegistrationCommand_1.DescribeTypeRegistrationCommand,
    DetectStackDriftCommand: DetectStackDriftCommand_1.DetectStackDriftCommand,
    DetectStackResourceDriftCommand: DetectStackResourceDriftCommand_1.DetectStackResourceDriftCommand,
    DetectStackSetDriftCommand: DetectStackSetDriftCommand_1.DetectStackSetDriftCommand,
    EstimateTemplateCostCommand: EstimateTemplateCostCommand_1.EstimateTemplateCostCommand,
    ExecuteChangeSetCommand: ExecuteChangeSetCommand_1.ExecuteChangeSetCommand,
    GetStackPolicyCommand: GetStackPolicyCommand_1.GetStackPolicyCommand,
    GetTemplateCommand: GetTemplateCommand_1.GetTemplateCommand,
    GetTemplateSummaryCommand: GetTemplateSummaryCommand_1.GetTemplateSummaryCommand,
    ImportStacksToStackSetCommand: ImportStacksToStackSetCommand_1.ImportStacksToStackSetCommand,
    ListChangeSetsCommand: ListChangeSetsCommand_1.ListChangeSetsCommand,
    ListExportsCommand: ListExportsCommand_1.ListExportsCommand,
    ListImportsCommand: ListImportsCommand_1.ListImportsCommand,
    ListStackInstanceResourceDriftsCommand: ListStackInstanceResourceDriftsCommand_1.ListStackInstanceResourceDriftsCommand,
    ListStackInstancesCommand: ListStackInstancesCommand_1.ListStackInstancesCommand,
    ListStackResourcesCommand: ListStackResourcesCommand_1.ListStackResourcesCommand,
    ListStacksCommand: ListStacksCommand_1.ListStacksCommand,
    ListStackSetOperationResultsCommand: ListStackSetOperationResultsCommand_1.ListStackSetOperationResultsCommand,
    ListStackSetOperationsCommand: ListStackSetOperationsCommand_1.ListStackSetOperationsCommand,
    ListStackSetsCommand: ListStackSetsCommand_1.ListStackSetsCommand,
    ListTypeRegistrationsCommand: ListTypeRegistrationsCommand_1.ListTypeRegistrationsCommand,
    ListTypesCommand: ListTypesCommand_1.ListTypesCommand,
    ListTypeVersionsCommand: ListTypeVersionsCommand_1.ListTypeVersionsCommand,
    PublishTypeCommand: PublishTypeCommand_1.PublishTypeCommand,
    RecordHandlerProgressCommand: RecordHandlerProgressCommand_1.RecordHandlerProgressCommand,
    RegisterPublisherCommand: RegisterPublisherCommand_1.RegisterPublisherCommand,
    RegisterTypeCommand: RegisterTypeCommand_1.RegisterTypeCommand,
    RollbackStackCommand: RollbackStackCommand_1.RollbackStackCommand,
    SetStackPolicyCommand: SetStackPolicyCommand_1.SetStackPolicyCommand,
    SetTypeConfigurationCommand: SetTypeConfigurationCommand_1.SetTypeConfigurationCommand,
    SetTypeDefaultVersionCommand: SetTypeDefaultVersionCommand_1.SetTypeDefaultVersionCommand,
    SignalResourceCommand: SignalResourceCommand_1.SignalResourceCommand,
    StopStackSetOperationCommand: StopStackSetOperationCommand_1.StopStackSetOperationCommand,
    TestTypeCommand: TestTypeCommand_1.TestTypeCommand,
    UpdateStackCommand: UpdateStackCommand_1.UpdateStackCommand,
    UpdateStackInstancesCommand: UpdateStackInstancesCommand_1.UpdateStackInstancesCommand,
    UpdateStackSetCommand: UpdateStackSetCommand_1.UpdateStackSetCommand,
    UpdateTerminationProtectionCommand: UpdateTerminationProtectionCommand_1.UpdateTerminationProtectionCommand,
    ValidateTemplateCommand: ValidateTemplateCommand_1.ValidateTemplateCommand,
};
class CloudFormation extends CloudFormationClient_1.CloudFormationClient {
}
exports.CloudFormation = CloudFormation;
(0, smithy_client_1.createAggregatedClient)(commands, CloudFormation);
