/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.datatool;

import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolHeader;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolSty;
import java.io.IOException;
import java.util.Vector;

public class DataToolHeaderRow
extends Vector<DataToolHeader>
implements TeXObject {
    private DataToolSty sty;

    public DataToolHeaderRow(DataToolSty dataToolSty) {
        this.sty = dataToolSty;
    }

    public DataToolHeaderRow(DataToolSty dataToolSty, int n) {
        super(n);
        this.sty = dataToolSty;
    }

    @Override
    public Object clone() {
        DataToolHeaderRow dataToolHeaderRow = new DataToolHeaderRow(this.sty, this.capacity());
        for (DataToolHeader dataToolHeader : this) {
            dataToolHeaderRow.add((DataToolHeader)dataToolHeader.clone());
        }
        return dataToolHeaderRow;
    }

    public static DataToolHeaderRow toHeaderRow(TeXParser teXParser, TeXObjectList teXObjectList, DataToolSty dataToolSty) throws IOException {
        DataToolHeader dataToolHeader;
        if (teXObjectList.peekStack() instanceof DataToolHeaderRow) {
            return (DataToolHeaderRow)teXObjectList.popToken();
        }
        DataToolHeaderRow dataToolHeaderRow = new DataToolHeaderRow(dataToolSty);
        while ((dataToolHeader = DataToolHeader.popHeader(teXParser, teXObjectList, dataToolSty)) != null) {
            dataToolHeaderRow.add(dataToolHeader);
        }
        return dataToolHeaderRow;
    }

    public DataToolHeader getHeader(String string) {
        for (DataToolHeader dataToolHeader : this) {
            if (!dataToolHeader.getColumnLabel().equals(string)) continue;
            return dataToolHeader;
        }
        return null;
    }

    public DataToolHeader getHeader(int n) {
        for (DataToolHeader dataToolHeader : this) {
            if (dataToolHeader.getColumnIndex() != n) continue;
            return dataToolHeader;
        }
        return null;
    }

    public int getMaxIndex() {
        int n = 0;
        for (DataToolHeader dataToolHeader : this) {
            int n2 = dataToolHeader.getColumnIndex();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList();
        for (DataToolHeader dataToolHeader : this) {
            teXObjectList.addAll(dataToolHeader.expandonce(teXParser));
        }
        return teXObjectList;
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        teXParser.addAll(0, this.expandonce(teXParser));
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.process(teXParser);
    }

    @Override
    public String toString(TeXParser teXParser) {
        try {
            return this.expandonce(teXParser).toString(teXParser);
        }
        catch (IOException iOException) {
            return "";
        }
    }

    @Override
    public TeXObjectList string(TeXParser teXParser) throws IOException {
        return this.expandonce(teXParser).string(teXParser);
    }

    @Override
    public String format() {
        try {
            return this.expandonce(this.sty.getListener().getParser()).format();
        }
        catch (IOException iOException) {
            return "";
        }
    }

    @Override
    public String purified() {
        try {
            return this.expandonce(this.sty.getListener().getParser()).purified();
        }
        catch (IOException iOException) {
            return "";
        }
    }

    @Override
    public boolean isPar() {
        return false;
    }

    @Override
    public boolean isDataObject() {
        return true;
    }

    @Override
    public boolean canExpand() {
        return false;
    }

    @Override
    public boolean isExpansionBlocker() {
        return false;
    }
}

