/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.laf.flatlaf.ui;

import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.laf.flatlaf.HiDPIUtils;
import org.netbeans.swing.laf.flatlaf.ui.FlatTabControlIcon;
import org.netbeans.swing.laf.flatlaf.ui.Utils;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.event.TabActionEvent;
import org.netbeans.swing.tabcontrol.plaf.AbstractViewTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.BusyTabsSupport;
import org.netbeans.swing.tabcontrol.plaf.TabLayoutModel;
import org.openide.awt.HtmlRenderer;

public class FlatViewTabDisplayerUI
extends AbstractViewTabDisplayerUI {
    private static final int ICON_X_PAD = 4;
    private static boolean colorsReady = false;
    private static Color background;
    private static Color activeBackground;
    private static Color selectedBackground;
    private static Color hoverBackground;
    private static Color attentionBackground;
    private static Color foreground;
    private static Color activeForeground;
    private static Color selectedForeground;
    private static Color hoverForeground;
    private static Color attentionForeground;
    private static Color underlineColor;
    private static Color inactiveUnderlineColor;
    private static Color tabSeparatorColor;
    private static Color contentBorderColor;
    private static Insets tabInsets;
    private static int underlineHeight;
    private static boolean underlineAtTop;
    private static boolean showTabSeparators;
    private Font font;

    public FlatViewTabDisplayerUI(TabDisplayer tabDisplayer) {
        super(tabDisplayer);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new FlatViewTabDisplayerUI((TabDisplayer)jComponent);
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        FlatViewTabDisplayerUI.initColors();
        this.getLayoutModel().setPadding(new Dimension(FlatViewTabDisplayerUI.tabInsets.left + FlatViewTabDisplayerUI.tabInsets.right, 0));
    }

    protected AbstractViewTabDisplayerUI.Controller createController() {
        return new OwnController();
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        FontMetrics fontMetrics = this.getTxtFontMetrics();
        int n = fontMetrics.getHeight() + FlatViewTabDisplayerUI.tabInsets.top + FlatViewTabDisplayerUI.tabInsets.bottom;
        return new Dimension(100, n);
    }

    protected void paintTabContent(Graphics graphics, int n, String string, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        Serializable serializable;
        Object object;
        int n9 = FlatViewTabDisplayerUI.tabInsets.left;
        int n10 = FlatViewTabDisplayerUI.tabInsets.right;
        FontMetrics fontMetrics = this.getTxtFontMetrics();
        graphics.setFont(this.getTxtFont());
        int n11 = n4 - (n9 + n10);
        if (this.isSelected(n) && null != (object = this.getControlButtons())) {
            serializable = ((Component)object).getPreferredSize();
            if (n4 < serializable.width + 4) {
                ((Component)object).setVisible(false);
            } else {
                ((Component)object).setVisible(true);
                n11 -= serializable.width + 4;
                ((Component)object).setLocation(n2 + n4 - serializable.width - 4, n3 + (n5 - serializable.height) / 2 - 1);
            }
        }
        if (this.isTabBusy(n)) {
            object = BusyTabsSupport.getDefault().getBusyIcon(this.isSelected(n));
            n11 -= object.getIconWidth() - UIScale.scale((int)3) - n9;
            object.paintIcon((Component)this.displayer, graphics, n2 + n9, n3 + (n5 - object.getIconHeight()) / 2);
            int n12 = object.getIconWidth() + UIScale.scale((int)3);
            n2 += n12;
            n4 -= n12;
        }
        int n13 = n8 = string.startsWith("<html") || string.startsWith("<HTML") ? (int)HtmlRenderer.renderString((String)string, (Graphics)graphics, (int)0, (int)0, (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE, (Font)this.getTxtFont(), (Color)foreground, (int)1, (boolean)false) : fontMetrics.stringWidth(string);
        if (n8 > n11) {
            int n14 = Math.min(n9 - 1, n8 - n11);
            n9 -= n14;
            if (n8 > (n11 += n14 + n10) && string.length() > 3 && (n7 = fontMetrics.stringWidth(string.substring(0, 3) + "\u2026")) > n11) {
                for (n6 = 2; n6 >= 0 && fontMetrics.stringWidth(string = string.substring(0, n6) + "\u2026") >= n11; --n6) {
                }
            }
        }
        serializable = this.colorForState(n, foreground, activeForeground, selectedForeground, hoverForeground, attentionForeground);
        n7 = n2 + n9;
        n6 = n3 + FlatViewTabDisplayerUI.tabInsets.top + fontMetrics.getAscent();
        int n15 = n5 - FlatViewTabDisplayerUI.tabInsets.top - FlatViewTabDisplayerUI.tabInsets.bottom;
        if (n15 > fontMetrics.getHeight()) {
            n6 += (n15 - fontMetrics.getHeight()) / 2;
        }
        int n16 = 1;
        if (!this.isSelected(n)) {
            n7 = Math.max(n2 + 1, n2 + (n4 - n8) / 2);
        }
        HtmlRenderer.renderString((String)string, (Graphics)graphics, (int)n7, (int)n6, (int)n11, (int)n5, (Font)this.getTxtFont(), (Color)serializable, (int)n16, (boolean)true);
    }

    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
    }

    protected void paintTabBackground(Graphics graphics, int n, int n4, int n5, int n6, int n7) {
        HiDPIUtils.paintAtScale1x(graphics, n4, n5, n6, n7, (graphics2D, n2, n3, d) -> this.paintTabBackgroundAtScale1x(graphics2D, n, n2, n3, d));
    }

    private void paintTabBackgroundAtScale1x(Graphics2D graphics2D, int n, int n2, int n3, double d) {
        int n4;
        int n5 = showTabSeparators && n >= 0 ? (int)(1.0 * d) : 0;
        Color color = this.colorForState(n, background, activeBackground, selectedBackground, hoverBackground, attentionBackground);
        graphics2D.setColor(color);
        graphics2D.fillRect(0, 0, n2 - (color != background ? n5 : 0), n3);
        if (this.isSelected(n) && underlineHeight > 0) {
            n4 = (int)Math.round((double)underlineHeight * d);
            graphics2D.setColor(this.isActive() ? underlineColor : inactiveUnderlineColor);
            if (underlineAtTop) {
                graphics2D.fillRect(0, 0, n2 - n5, n4);
            } else {
                graphics2D.fillRect(0, n3 - n4, n2 - n5, n4);
            }
        } else {
            n4 = HiDPIUtils.deviceBorderWidth(d, 1);
            graphics2D.setColor(contentBorderColor);
            graphics2D.fillRect(0, n3 - n4, n2, n4);
        }
        if (showTabSeparators && n >= 0) {
            n4 = (int)(4.0 * d);
            graphics2D.setColor(tabSeparatorColor);
            graphics2D.fillRect(n2 - n5, n4, n5, n3 - n4 * 2 - 1);
        }
    }

    protected void paintDisplayerBackground(Graphics graphics, JComponent jComponent) {
        this.paintTabBackground(graphics, -1, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        super.paintDisplayerBackground(graphics, jComponent);
    }

    private Color colorForState(int n, Color color, Color color2, Color color3, Color color4, Color color5) {
        return this.isAttention(n) ? color5 : (this.isMouseOver(n) ? color4 : (this.isActive() ? (this.isSelected(n) ? color3 : color2) : color));
    }

    protected Font getTxtFont() {
        if (this.font == null) {
            this.font = UIManager.getFont("ViewTab.font");
            if (this.font == null) {
                this.font = UIManager.getFont("Label.font");
            }
        }
        return this.font;
    }

    boolean isMouseOver(int n) {
        if (n < 0) {
            return false;
        }
        return ((OwnController)this.getController()).getMouseIndex() == n;
    }

    private static void initColors() {
        if (!colorsReady) {
            background = UIManager.getColor("ViewTab.background");
            activeBackground = Utils.getUIColor("ViewTab.activeBackground", background);
            selectedBackground = Utils.getUIColor("ViewTab.selectedBackground", activeBackground);
            hoverBackground = UIManager.getColor("ViewTab.hoverBackground");
            attentionBackground = UIManager.getColor("ViewTab.attentionBackground");
            foreground = Utils.getUIColor("ViewTab.foreground", "TabbedPane.foreground");
            activeForeground = Utils.getUIColor("ViewTab.activeForeground", foreground);
            selectedForeground = Utils.getUIColor("ViewTab.selectedForeground", activeForeground);
            hoverForeground = Utils.getUIColor("ViewTab.hoverForeground", foreground);
            attentionForeground = Utils.getUIColor("ViewTab.attentionForeground", foreground);
            underlineColor = UIManager.getColor("ViewTab.underlineColor");
            inactiveUnderlineColor = UIManager.getColor("ViewTab.inactiveUnderlineColor");
            tabSeparatorColor = UIManager.getColor("ViewTab.tabSeparatorColor");
            contentBorderColor = UIManager.getColor("TabbedContainer.view.contentBorderColor");
            tabInsets = UIManager.getInsets("ViewTab.tabInsets");
            underlineHeight = UIManager.getInt("ViewTab.underlineHeight");
            underlineAtTop = UIManager.getBoolean("ViewTab.underlineAtTop");
            showTabSeparators = UIManager.getBoolean("ViewTab.showTabSeparators");
            tabInsets = UIScale.scale((Insets)tabInsets);
            underlineHeight = UIScale.scale((int)underlineHeight);
            colorsReady = true;
        }
    }

    public Icon getButtonIcon(int n, int n2) {
        Icon icon = FlatTabControlIcon.get(n, n2);
        return icon != null ? icon : super.getButtonIcon(n, n2);
    }

    public void postTabAction(TabActionEvent tabActionEvent) {
        super.postTabAction(tabActionEvent);
        if ("maximize".equals(tabActionEvent.getActionCommand())) {
            ((OwnController)this.getController()).updateHighlight(-1);
        }
    }

    private class OwnController
    extends AbstractViewTabDisplayerUI.Controller {
        private int lastIndex;

        private OwnController() {
            super((AbstractViewTabDisplayerUI)FlatViewTabDisplayerUI.this);
            this.lastIndex = -1;
        }

        public int getMouseIndex() {
            return this.lastIndex;
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            super.mouseMoved(mouseEvent);
            Point point = mouseEvent.getPoint();
            this.updateHighlight(FlatViewTabDisplayerUI.this.getLayoutModel().indexOfPoint(point.x, point.y));
        }

        public void mouseExited(MouseEvent mouseEvent) {
            super.mouseExited(mouseEvent);
            if (!this.inControlButtonsRect(mouseEvent.getPoint())) {
                this.updateHighlight(-1);
            }
        }

        private void updateHighlight(int n) {
            int n2;
            int n3;
            int n4;
            int n5;
            if (n == this.lastIndex) {
                return;
            }
            TabLayoutModel tabLayoutModel = FlatViewTabDisplayerUI.this.getLayoutModel();
            Rectangle rectangle = null;
            if (n != -1) {
                n5 = tabLayoutModel.getX(n) - 1;
                n4 = tabLayoutModel.getY(n);
                n3 = tabLayoutModel.getW(n) + 2;
                n2 = tabLayoutModel.getH(n);
                rectangle = new Rectangle(n5, n4, n3, n2);
            }
            if (this.lastIndex != -1 && this.lastIndex < FlatViewTabDisplayerUI.this.getDataModel().size()) {
                n5 = tabLayoutModel.getX(this.lastIndex) - 1;
                n4 = tabLayoutModel.getY(this.lastIndex);
                n3 = tabLayoutModel.getW(this.lastIndex) + 2;
                n2 = tabLayoutModel.getH(this.lastIndex);
                rectangle = rectangle != null ? rectangle.union(new Rectangle(n5, n4, n3, n2)) : new Rectangle(n5, n4, n3, n2);
            }
            if (rectangle != null) {
                FlatViewTabDisplayerUI.this.getDisplayer().repaint(rectangle);
            }
            this.lastIndex = n;
        }
    }
}

