/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.java.impl;

import org.graalvm.visualvm.heapviewer.java.impl.PathToGCRootPlugin;
import org.graalvm.visualvm.lib.jfluid.heap.Field;
import org.graalvm.visualvm.lib.jfluid.heap.FieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectFieldValue;

final class HeapPatterns {
    HeapPatterns() {
    }

    static PathToGCRootPlugin.SkipNode processGCRootReference(ObjectFieldValue reference) {
        ObjectFieldValue ref = reference;
        int skipped = 0;
        while (true) {
            ObjectFieldValue oval;
            Instance i = ref.getDefiningInstance();
            Instance path = i.getNearestGCRootPointer();
            if (!i.getJavaClass().equals(path.getJavaClass()) || (oval = HeapPatterns.getValueOfField(path, ref.getField())) == null || !oval.getInstance().equals(i)) break;
            ref = oval;
            ++skipped;
        }
        if (skipped > 1) {
            return new PathToGCRootPlugin.SkipNode(ref, skipped);
        }
        return null;
    }

    private static ObjectFieldValue getValueOfField(Instance i, Field f) {
        for (FieldValue val : i.getFieldValues()) {
            ObjectFieldValue oval;
            if (!(val instanceof ObjectFieldValue) || !(oval = (ObjectFieldValue)val).getField().equals(f)) continue;
            return oval;
        }
        return null;
    }
}

