/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/** @enum {number} */
var TagContentType = {
    RAW_TEXT: 0,
    ESCAPABLE_RAW_TEXT: 1,
    PARSABLE_DATA: 2,
};
export { TagContentType };
TagContentType[TagContentType.RAW_TEXT] = "RAW_TEXT";
TagContentType[TagContentType.ESCAPABLE_RAW_TEXT] = "ESCAPABLE_RAW_TEXT";
TagContentType[TagContentType.PARSABLE_DATA] = "PARSABLE_DATA";
/**
 * @record
 */
export function TagDefinition() { }
function TagDefinition_tsickle_Closure_declarations() {
    /** @type {?} */
    TagDefinition.prototype.closedByParent;
    /** @type {?} */
    TagDefinition.prototype.requiredParents;
    /** @type {?} */
    TagDefinition.prototype.parentToAdd;
    /** @type {?} */
    TagDefinition.prototype.implicitNamespacePrefix;
    /** @type {?} */
    TagDefinition.prototype.contentType;
    /** @type {?} */
    TagDefinition.prototype.isVoid;
    /** @type {?} */
    TagDefinition.prototype.ignoreFirstLf;
    /** @type {?} */
    TagDefinition.prototype.canSelfClose;
    /** @type {?} */
    TagDefinition.prototype.requireExtraParent;
    /** @type {?} */
    TagDefinition.prototype.isClosedByChild;
}
/**
 * @param {?} elementName
 * @return {?}
 */
export function splitNsName(elementName) {
    if (elementName[0] !== ":") {
        return [null, elementName];
    }
    var /** @type {?} */ colonIndex = elementName.indexOf(":", 1);
    if (colonIndex === -1) {
        throw new Error("Unsupported format \"" + elementName + "\" expecting \":namespace:name\"");
    }
    return [elementName.slice(1, colonIndex), elementName.slice(colonIndex + 1)];
}
/**
 * @param {?} tagName
 * @return {?}
 */
export function isNgContainer(tagName) {
    return splitNsName(tagName)[1] === "ng-container";
}
/**
 * @param {?} tagName
 * @return {?}
 */
export function isNgContent(tagName) {
    return splitNsName(tagName)[1] === "ng-content";
}
/**
 * @param {?} tagName
 * @return {?}
 */
export function isNgTemplate(tagName) {
    return splitNsName(tagName)[1] === "ng-template";
}
/**
 * @param {?} fullName
 * @return {?}
 */
export function getNsPrefix(fullName) {
    return fullName === null ? null : splitNsName(fullName)[0];
}
/**
 * @param {?} prefix
 * @param {?} localName
 * @return {?}
 */
export function mergeNsAndName(prefix, localName) {
    return prefix ? ":" + prefix + ":" + localName : localName;
}
// see http://www.w3.org/TR/html51/syntax.html#named-character-references
// see https://html.spec.whatwg.org/multipage/entities.json
// This list is not exhaustive to keep the compiler footprint low.
// The `&#123;` / `&#x1ab;` syntax should be used when the named character reference does not
// exist.
export var /** @type {?} */ NAMED_ENTITIES = {
    Aacute: "\u00C1",
    aacute: "\u00E1",
    Acirc: "\u00C2",
    acirc: "\u00E2",
    acute: "\u00B4",
    AElig: "\u00C6",
    aelig: "\u00E6",
    Agrave: "\u00C0",
    agrave: "\u00E0",
    alefsym: "\u2135",
    Alpha: "\u0391",
    alpha: "\u03B1",
    amp: "&",
    and: "\u2227",
    ang: "\u2220",
    apos: "\u0027",
    Aring: "\u00C5",
    aring: "\u00E5",
    asymp: "\u2248",
    Atilde: "\u00C3",
    atilde: "\u00E3",
    Auml: "\u00C4",
    auml: "\u00E4",
    bdquo: "\u201E",
    Beta: "\u0392",
    beta: "\u03B2",
    brvbar: "\u00A6",
    bull: "\u2022",
    cap: "\u2229",
    Ccedil: "\u00C7",
    ccedil: "\u00E7",
    cedil: "\u00B8",
    cent: "\u00A2",
    Chi: "\u03A7",
    chi: "\u03C7",
    circ: "\u02C6",
    clubs: "\u2663",
    cong: "\u2245",
    copy: "\u00A9",
    crarr: "\u21B5",
    cup: "\u222A",
    curren: "\u00A4",
    dagger: "\u2020",
    Dagger: "\u2021",
    darr: "\u2193",
    dArr: "\u21D3",
    deg: "\u00B0",
    Delta: "\u0394",
    delta: "\u03B4",
    diams: "\u2666",
    divide: "\u00F7",
    Eacute: "\u00C9",
    eacute: "\u00E9",
    Ecirc: "\u00CA",
    ecirc: "\u00EA",
    Egrave: "\u00C8",
    egrave: "\u00E8",
    empty: "\u2205",
    emsp: "\u2003",
    ensp: "\u2002",
    Epsilon: "\u0395",
    epsilon: "\u03B5",
    equiv: "\u2261",
    Eta: "\u0397",
    eta: "\u03B7",
    ETH: "\u00D0",
    eth: "\u00F0",
    Euml: "\u00CB",
    euml: "\u00EB",
    euro: "\u20AC",
    exist: "\u2203",
    fnof: "\u0192",
    forall: "\u2200",
    frac12: "\u00BD",
    frac14: "\u00BC",
    frac34: "\u00BE",
    frasl: "\u2044",
    Gamma: "\u0393",
    gamma: "\u03B3",
    ge: "\u2265",
    gt: ">",
    harr: "\u2194",
    hArr: "\u21D4",
    hearts: "\u2665",
    hellip: "\u2026",
    Iacute: "\u00CD",
    iacute: "\u00ED",
    Icirc: "\u00CE",
    icirc: "\u00EE",
    iexcl: "\u00A1",
    Igrave: "\u00CC",
    igrave: "\u00EC",
    image: "\u2111",
    infin: "\u221E",
    int: "\u222B",
    Iota: "\u0399",
    iota: "\u03B9",
    iquest: "\u00BF",
    isin: "\u2208",
    Iuml: "\u00CF",
    iuml: "\u00EF",
    Kappa: "\u039A",
    kappa: "\u03BA",
    Lambda: "\u039B",
    lambda: "\u03BB",
    lang: "\u27E8",
    laquo: "\u00AB",
    larr: "\u2190",
    lArr: "\u21D0",
    lceil: "\u2308",
    ldquo: "\u201C",
    le: "\u2264",
    lfloor: "\u230A",
    lowast: "\u2217",
    loz: "\u25CA",
    lrm: "\u200E",
    lsaquo: "\u2039",
    lsquo: "\u2018",
    lt: "<",
    macr: "\u00AF",
    mdash: "\u2014",
    micro: "\u00B5",
    middot: "\u00B7",
    minus: "\u2212",
    Mu: "\u039C",
    mu: "\u03BC",
    nabla: "\u2207",
    nbsp: "\u00A0",
    ndash: "\u2013",
    ne: "\u2260",
    ni: "\u220B",
    not: "\u00AC",
    notin: "\u2209",
    nsub: "\u2284",
    Ntilde: "\u00D1",
    ntilde: "\u00F1",
    Nu: "\u039D",
    nu: "\u03BD",
    Oacute: "\u00D3",
    oacute: "\u00F3",
    Ocirc: "\u00D4",
    ocirc: "\u00F4",
    OElig: "\u0152",
    oelig: "\u0153",
    Ograve: "\u00D2",
    ograve: "\u00F2",
    oline: "\u203E",
    Omega: "\u03A9",
    omega: "\u03C9",
    Omicron: "\u039F",
    omicron: "\u03BF",
    oplus: "\u2295",
    or: "\u2228",
    ordf: "\u00AA",
    ordm: "\u00BA",
    Oslash: "\u00D8",
    oslash: "\u00F8",
    Otilde: "\u00D5",
    otilde: "\u00F5",
    otimes: "\u2297",
    Ouml: "\u00D6",
    ouml: "\u00F6",
    para: "\u00B6",
    permil: "\u2030",
    perp: "\u22A5",
    Phi: "\u03A6",
    phi: "\u03C6",
    Pi: "\u03A0",
    pi: "\u03C0",
    piv: "\u03D6",
    plusmn: "\u00B1",
    pound: "\u00A3",
    prime: "\u2032",
    Prime: "\u2033",
    prod: "\u220F",
    prop: "\u221D",
    Psi: "\u03A8",
    psi: "\u03C8",
    quot: "\u0022",
    radic: "\u221A",
    rang: "\u27E9",
    raquo: "\u00BB",
    rarr: "\u2192",
    rArr: "\u21D2",
    rceil: "\u2309",
    rdquo: "\u201D",
    real: "\u211C",
    reg: "\u00AE",
    rfloor: "\u230B",
    Rho: "\u03A1",
    rho: "\u03C1",
    rlm: "\u200F",
    rsaquo: "\u203A",
    rsquo: "\u2019",
    sbquo: "\u201A",
    Scaron: "\u0160",
    scaron: "\u0161",
    sdot: "\u22C5",
    sect: "\u00A7",
    shy: "\u00AD",
    Sigma: "\u03A3",
    sigma: "\u03C3",
    sigmaf: "\u03C2",
    sim: "\u223C",
    spades: "\u2660",
    sub: "\u2282",
    sube: "\u2286",
    sum: "\u2211",
    sup: "\u2283",
    sup1: "\u00B9",
    sup2: "\u00B2",
    sup3: "\u00B3",
    supe: "\u2287",
    szlig: "\u00DF",
    Tau: "\u03A4",
    tau: "\u03C4",
    there4: "\u2234",
    Theta: "\u0398",
    theta: "\u03B8",
    thetasym: "\u03D1",
    thinsp: "\u2009",
    THORN: "\u00DE",
    thorn: "\u00FE",
    tilde: "\u02DC",
    times: "\u00D7",
    trade: "\u2122",
    Uacute: "\u00DA",
    uacute: "\u00FA",
    uarr: "\u2191",
    uArr: "\u21D1",
    Ucirc: "\u00DB",
    ucirc: "\u00FB",
    Ugrave: "\u00D9",
    ugrave: "\u00F9",
    uml: "\u00A8",
    upsih: "\u03D2",
    Upsilon: "\u03A5",
    upsilon: "\u03C5",
    Uuml: "\u00DC",
    uuml: "\u00FC",
    weierp: "\u2118",
    Xi: "\u039E",
    xi: "\u03BE",
    Yacute: "\u00DD",
    yacute: "\u00FD",
    yen: "\u00A5",
    yuml: "\u00FF",
    Yuml: "\u0178",
    Zeta: "\u0396",
    zeta: "\u03B6",
    zwj: "\u200D",
    zwnj: "\u200C"
};
// The &ngsp; pseudo-entity is denoting a space. see:
// https://github.com/dart-lang/angular/blob/0bb611387d29d65b5af7f9d2515ab571fd3fbee4/_tests/test/compiler/preserve_whitespace_test.dart
export var /** @type {?} */ NGSP_UNICODE = "\uE500";
NAMED_ENTITIES["ngsp"] = NGSP_UNICODE;

//# sourceMappingURL=data:application/json;base64,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