/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.Event;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.FreeColSpecObjectType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.util.StringUtils;

public class FoundingFather
extends FreeColSpecObjectType {
    public static final String TAG = "founding-father";
    private FoundingFatherType type;
    private final int[] weight = new int[3];
    private List<Event> events = null;
    private List<AbstractUnit> units = null;
    private static final String FROM_ID_TAG = "from-id";
    private static final String TO_ID_TAG = "to-id";
    private static final String TYPE_TAG = "type";
    private static final String UNIT_TAG = "unit";
    private static final String WEIGHT_TAG = "weight";
    private static final String UPGRADE_TAG = "upgrade";

    public FoundingFather(String id, Specification specification) {
        super(id, specification);
    }

    public FoundingFatherType getType() {
        return this.type;
    }

    public void setType(FoundingFatherType type) {
        this.type = type;
    }

    public String getTypeKey() {
        return this.type.getTypeKey();
    }

    public int getWeight(int age) {
        return age >= 0 && age < this.weight.length ? this.weight[age] : 0;
    }

    public final List<Event> getEvents() {
        return this.events == null ? Collections.emptyList() : this.events;
    }

    public final void setEvents(List<Event> newEvents) {
        this.events = newEvents;
    }

    private void addEvent(Event event) {
        if (this.events == null) {
            this.events = new ArrayList<Event>();
        }
        this.events.add(event);
    }

    public final List<AbstractUnit> getUnitList() {
        return this.units == null ? Collections.emptyList() : this.units;
    }

    public final void setUnits(List<AbstractUnit> newUnits) {
        this.units = newUnits;
    }

    private void addUnit(AbstractUnit unit) {
        if (this.units == null) {
            this.units = new ArrayList<AbstractUnit>();
        }
        this.units.add(unit);
    }

    public boolean isAvailableTo(Player player) {
        return !player.isEuropean() ? false : this.appliesTo(player);
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        FoundingFather o = this.copyInCast(other, FoundingFather.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        this.type = o.getType();
        for (int i = 0; i < this.weight.length; ++i) {
            this.weight[i] = o.getWeight(i);
        }
        this.setEvents(o.getEvents());
        this.setUnits(o.getUnitList());
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(TYPE_TAG, this.type);
        for (int i = 0; i < this.weight.length; ++i) {
            xw.writeAttribute(WEIGHT_TAG + (i + 1), this.weight[i]);
        }
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        for (Event event : this.getEvents()) {
            event.toXML(xw);
        }
        for (AbstractUnit unit : this.getUnitList()) {
            xw.writeStartElement(UNIT_TAG);
            xw.writeAttribute("id", unit);
            xw.writeEndElement();
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.type = xr.getAttribute(TYPE_TAG, FoundingFatherType.class, null);
        for (int i = 0; i < this.weight.length; ++i) {
            this.weight[i] = xr.getAttribute(WEIGHT_TAG + (i + 1), 0);
        }
    }

    @Override
    protected void clearContainers(FreeColXMLReader xr) throws XMLStreamException {
        super.clearContainers(xr);
        this.events = null;
        this.units = null;
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        String tag = xr.getLocalName();
        if (UNIT_TAG.equals(tag)) {
            this.addUnit(new AbstractUnit(xr));
        } else if ("event".equals(tag)) {
            this.addEvent(new Event(xr, spec));
        } else if (UPGRADE_TAG.equals(tag)) {
            xr.closeTag(UPGRADE_TAG);
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    public static enum FoundingFatherType {
        TRADE,
        EXPLORATION,
        MILITARY,
        POLITICAL,
        RELIGIOUS;


        public String getKey() {
            return StringUtils.getEnumKey(this);
        }

        public String getTypeKey() {
            return "model.foundingFather." + StringUtils.downCase(this.toString());
        }
    }
}

