/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Error;
import org.jruby.ext.ffi.MappedType;
import org.jruby.ext.ffi.NativeType;
import org.jruby.ext.ffi.Type;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"FFI::CallbackInfo"}, parent="FFI::Type")
public class CallbackInfo
extends Type {
    public static final String CLASS_NAME = "CallbackInfo";
    protected final Arity arity;
    protected final Type[] parameterTypes;
    protected final Type returnType;
    protected final boolean stdcall;

    public static RubyClass createCallbackInfoClass(ThreadContext context, RubyModule module, RubyClass Type2) {
        return (RubyClass)Type2.setConstant(context, "Function", (IRubyObject)((RubyModule)((RubyModule)module.defineClassUnder(context, CLASS_NAME, Type2, ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR)).defineMethods(context, CallbackInfo.class)).defineConstants(context, CallbackInfo.class));
    }

    public CallbackInfo(Ruby runtime2, RubyClass klazz, Type returnType, Type[] paramTypes, boolean stdcall) {
        super(runtime2, klazz, NativeType.POINTER);
        this.arity = Arity.fixed(paramTypes.length);
        this.parameterTypes = paramTypes;
        this.returnType = returnType;
        this.stdcall = stdcall;
    }

    @JRubyMethod(name={"new"}, meta=true, required=2, optional=1, checkArity=false)
    public static final IRubyObject newCallbackInfo(ThreadContext context, IRubyObject klass, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 2, 3);
        IRubyObject returnType = args2[0];
        if (!(returnType instanceof Type)) {
            throw Error.typeError(context, (IRubyObject)returnType.getMetaClass(), "FFI::Type");
        }
        RubyArray paramTypes = Convert.castAsArray(context, args2[1]);
        if (returnType instanceof MappedType) {
            MappedType mappedType = (MappedType)returnType;
            returnType = mappedType.getRealType();
        }
        Type[] nativeParamTypes = new Type[paramTypes.size()];
        for (int i2 = 0; i2 < nativeParamTypes.length; ++i2) {
            IRubyObject obj = paramTypes.entry(i2);
            if (!(obj instanceof Type)) {
                throw Error.typeError(context, obj, "array of FFI::Type");
            }
            nativeParamTypes[i2] = (Type)obj;
        }
        boolean stdcall = false;
        if (argc > 2) {
            IRubyObject iRubyObject = args2[2];
            if (!(iRubyObject instanceof RubyHash)) {
                throw Error.typeError(context, args2[2], "Enums or Hash");
            }
            RubyHash hash2 = (RubyHash)iRubyObject;
            stdcall = "stdcall".equals(hash2.get(Convert.asSymbol(context, "convention")));
        }
        try {
            return new CallbackInfo(context.runtime, (RubyClass)klass, (Type)returnType, nativeParamTypes, stdcall);
        }
        catch (UnsatisfiedLinkError ex) {
            return context.nil;
        }
    }

    public final Arity getArity() {
        return this.arity;
    }

    public final Type getReturnType() {
        return this.returnType;
    }

    public final Type[] getParameterTypes() {
        return this.parameterTypes;
    }

    public final boolean isStdcall() {
        return this.stdcall;
    }

    @Override
    @JRubyMethod(name={"to_s"})
    public final IRubyObject to_s(ThreadContext context) {
        StringBuilder sb = new StringBuilder(64);
        sb.append("#<FFI::CallbackInfo [ ");
        for (int i2 = 0; i2 < this.parameterTypes.length; ++i2) {
            sb.append(this.parameterTypes[i2].toString().toLowerCase());
            if (i2 >= this.parameterTypes.length - 1) continue;
            sb.append(", ");
        }
        sb.append(" ], ").append(this.returnType.toString().toLowerCase()).append('>');
        return Create.newString(context, sb.toString());
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("CallbackInfo[parameters=[");
        for (int i2 = 0; i2 < this.parameterTypes.length; ++i2) {
            sb.append(this.parameterTypes[i2].toString().toLowerCase());
            if (i2 >= this.parameterTypes.length - 1) continue;
            sb.append(", ");
        }
        sb.append("] return=" + this.returnType.toString().toLowerCase() + "]");
        return sb.toString();
    }

    @JRubyMethod
    public final IRubyObject result_type(ThreadContext context) {
        return this.returnType;
    }

    @JRubyMethod
    public final IRubyObject param_types(ThreadContext context) {
        return RubyArray.newArray(context.runtime, this.parameterTypes);
    }
}

