/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.TestTools;
import org.languagetool.language.Demo;
import org.languagetool.rules.LongParagraphRule;
import org.languagetool.rules.RuleMatch;

public class LongParagraphRuleTest {
    @Test
    public void testRule() throws IOException {
        Demo lang = new Demo();
        LongParagraphRule rule = new LongParagraphRule(TestTools.getEnglishMessages(), (Language)lang, null, 6);
        JLanguageTool lt = new JLanguageTool((Language)lang);
        Assert.assertThat((Object)rule.match(lt.analyzeText("This is a short paragraph.")).length, (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)rule.match(lt.analyzeText("This is only almost long paragraph by unit test standards.")).length, (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)rule.match(lt.analyzeText("Here's some text as a filler. This is a long paragraph by unit test standards.")).length, (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)rule.match(lt.analyzeText("Here's some text as a filler.  A test. A long paragraph by unit test standards.")).length, (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)rule.match(lt.analyzeText("Here's some text as a filler.  A test.\nNot a long paragraph.\nBecause of the line breaks.\n")).length, (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)rule.match(lt.analyzeText("- [ ] A test.\n- [ ] Not a long paragraph.\n- [ ] Because of the line breaks.\n- [ ] More text even.\n")).length, (Matcher)CoreMatchers.is((Object)0));
        String text1 = "This is a short paragraph.\n\nHere's some text as filler. This is a long paragraph by unit test standards.";
        RuleMatch[] matches1 = rule.match(lt.analyzeText(text1));
        Assert.assertThat((Object)matches1.length, (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)matches1[0].getFromPos(), (Matcher)CoreMatchers.is((Object)45));
        Assert.assertThat((Object)matches1[0].getToPos(), (Matcher)CoreMatchers.is((Object)54));
        String text2 = "Here's some text as filler. This is a long paragraph by unit test standards.\n\nAnother paragraph.\n\nHere's some text as morefiller - this is a long paragraph by unit test standards.";
        RuleMatch[] matches2 = rule.match(lt.analyzeText(text2));
        Assert.assertThat((Object)matches2.length, (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)matches2[0].getFromPos(), (Matcher)CoreMatchers.is((Object)17));
        Assert.assertThat((Object)matches2[0].getToPos(), (Matcher)CoreMatchers.is((Object)26));
        Assert.assertThat((Object)matches2[1].getFromPos(), (Matcher)CoreMatchers.is((Object)115));
        Assert.assertThat((Object)matches2[1].getToPos(), (Matcher)CoreMatchers.is((Object)128));
    }
}

