/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.corpus.dictionary.item;

import com.hankcs.hanlp.corpus.dictionary.item.SimpleItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;

public class Item
extends SimpleItem {
    public String key;

    public Item(String key, String label) {
        this(key);
        this.labelMap.put(label, 1);
    }

    public Item(String key) {
        this.key = key;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.key);
        ArrayList entries = new ArrayList(this.labelMap.entrySet());
        Collections.sort(entries, new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                return -o1.getValue().compareTo(o2.getValue());
            }
        });
        for (Map.Entry entry : entries) {
            sb.append(' ');
            sb.append((String)entry.getKey());
            sb.append(' ');
            sb.append(entry.getValue());
        }
        return sb.toString();
    }

    public String firstLabel() {
        return (String)this.labelMap.keySet().iterator().next();
    }

    public static Item create(String param) {
        if (param == null) {
            return null;
        }
        String mark = "\\s";
        if (param.indexOf(9) > 0) {
            mark = "\t";
        }
        String[] array = param.split(mark);
        return Item.create(array);
    }

    public static Item create(String[] param) {
        if (param.length % 2 == 0) {
            return null;
        }
        Item item = new Item(param[0]);
        int natureCount = (param.length - 1) / 2;
        for (int i = 0; i < natureCount; ++i) {
            item.labelMap.put(param[1 + 2 * i], Integer.parseInt(param[2 + 2 * i]));
        }
        return item;
    }
}

