/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dependency.nnparser;

import java.util.ArrayList;
import java.util.List;

public class Instance {
    List<String> raw_forms;
    List<String> forms = new ArrayList<String>();
    List<String> lemmas;
    List<String> postags = new ArrayList<String>();
    List<String> cpostags;
    List<Integer> heads;
    List<Integer> deprelsidx;
    List<String> deprels;
    List<Integer> predict_heads;
    List<Integer> predict_deprelsidx;
    List<String> predict_deprels;

    int size() {
        return this.forms.size();
    }

    boolean is_tree() {
        ArrayList<List<Integer>> tree = new ArrayList<List<Integer>>(this.heads.size());
        int root = -1;
        for (int modifier = 0; modifier < this.heads.size(); ++modifier) {
            int head = this.heads.get(modifier);
            if (head == -1) {
                root = modifier;
                continue;
            }
            ((List)tree.get(head)).add(modifier);
        }
        boolean[] visited = new boolean[this.heads.size()];
        if (!this.is_tree_travel(root, tree, visited)) {
            return false;
        }
        for (int i = 0; i < visited.length; ++i) {
            boolean visit = visited[i];
            if (visit) continue;
            return false;
        }
        return true;
    }

    boolean is_tree_travel(int now, List<List<Integer>> tree, boolean[] visited) {
        if (visited[now]) {
            return false;
        }
        visited[now] = true;
        for (int c = 0; c < tree.get(now).size(); ++c) {
            int next = tree.get(now).get(c);
            if (this.is_tree_travel(next, tree, visited)) continue;
            return false;
        }
        return true;
    }

    boolean is_projective() {
        return !this.is_non_projective();
    }

    boolean is_non_projective() {
        for (int modifier = 0; modifier < this.heads.size(); ++modifier) {
            int to;
            int from;
            int head = this.heads.get(modifier);
            if (head < modifier) {
                for (from = head + 1; from < modifier; ++from) {
                    to = this.heads.get(from);
                    if (to >= head && to <= modifier) continue;
                    return true;
                }
                continue;
            }
            for (from = modifier + 1; from < head; ++from) {
                to = this.heads.get(from);
                if (to >= modifier && to <= head) continue;
                return true;
            }
        }
        return false;
    }
}

