/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.hmm;

import com.hankcs.hanlp.corpus.document.sentence.Sentence;
import com.hankcs.hanlp.model.hmm.FirstOrderHiddenMarkovModel;
import com.hankcs.hanlp.model.hmm.HiddenMarkovModel;
import com.hankcs.hanlp.model.hmm.Vocabulary;
import com.hankcs.hanlp.model.perceptron.instance.InstanceHandler;
import com.hankcs.hanlp.model.perceptron.tagset.TagSet;
import com.hankcs.hanlp.model.perceptron.utility.IOUtility;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public abstract class HMMTrainer {
    HiddenMarkovModel model;
    Vocabulary vocabulary;

    public HMMTrainer(HiddenMarkovModel model, Vocabulary vocabulary) {
        this.model = model;
        this.vocabulary = vocabulary;
    }

    public HMMTrainer(HiddenMarkovModel model) {
        this(model, new Vocabulary());
    }

    public HMMTrainer() {
        this(new FirstOrderHiddenMarkovModel());
    }

    public void train(String corpus) throws IOException {
        final LinkedList sequenceList = new LinkedList();
        IOUtility.loadInstance(corpus, new InstanceHandler(){

            @Override
            public boolean process(Sentence sentence) {
                sequenceList.add(HMMTrainer.this.convertToSequence(sentence));
                return false;
            }
        });
        TagSet tagSet = this.getTagSet();
        ArrayList<int[][]> sampleList = new ArrayList<int[][]>(sequenceList.size());
        for (List sequence : sequenceList) {
            int[][] sample = new int[2][sequence.size()];
            int i = 0;
            for (String[] os : sequence) {
                sample[0][i] = this.vocabulary.idOf(os[0]);
                assert (sample[0][i] != -1);
                sample[1][i] = tagSet.add(os[1]);
                assert (sample[1][i] != -1);
                ++i;
            }
            sampleList.add(sample);
        }
        this.model.train(sampleList);
        this.vocabulary.mutable = false;
    }

    protected abstract List<String[]> convertToSequence(Sentence var1);

    protected abstract TagSet getTagSet();
}

