/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.output;

import io.lettuce.core.output.ComplexData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ArrayComplexData
extends ComplexData {
    private final List<Object> data;

    public ArrayComplexData(int count) {
        this.data = new ArrayList<Object>(count);
    }

    @Override
    public void storeObject(Object value) {
        this.data.add(value);
    }

    @Override
    public List<Object> getDynamicList() {
        return Collections.unmodifiableList(this.data);
    }

    @Override
    public Set<Object> getDynamicSet() {
        LinkedHashSet<Object> set2 = new LinkedHashSet<Object>(this.data);
        return Collections.unmodifiableSet(set2);
    }

    @Override
    public Map<Object, Object> getDynamicMap() {
        LinkedHashMap map = new LinkedHashMap();
        Boolean[] isKey = new Boolean[]{true};
        Object[] key = new Object[1];
        this.data.forEach(element -> {
            if (isKey[0].booleanValue()) {
                key[0] = element;
                isKey[0] = false;
            } else {
                map.put(key[0], element);
                isKey[0] = true;
            }
        });
        return Collections.unmodifiableMap(map);
    }
}

