/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.streamingingestion.state;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.lucene.store.AlreadyClosedException;
import org.opensearch.OpenSearchException;
import org.opensearch.action.admin.cluster.state.ClusterStateRequest;
import org.opensearch.action.admin.cluster.state.ClusterStateResponse;
import org.opensearch.action.admin.indices.streamingingestion.state.GetIngestionStateRequest;
import org.opensearch.action.admin.indices.streamingingestion.state.GetIngestionStateResponse;
import org.opensearch.action.admin.indices.streamingingestion.state.ShardIngestionState;
import org.opensearch.action.pagination.ShardPaginationStrategy;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.broadcast.node.TransportBroadcastByNodeAction;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.routing.ShardsIterator;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.action.support.DefaultShardOperationFailedException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.index.IndexService;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.shard.ShardNotFoundException;
import org.opensearch.indices.IndicesService;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.node.NodeClient;

public class TransportGetIngestionStateAction
extends TransportBroadcastByNodeAction<GetIngestionStateRequest, GetIngestionStateResponse, ShardIngestionState> {
    private final IndicesService indicesService;
    private final ClusterService clusterService;
    private final NodeClient client;

    @Inject
    public TransportGetIngestionStateAction(ClusterService clusterService, TransportService transportService, IndicesService indicesService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, NodeClient client) {
        super("indices:monitor/ingestion/state", clusterService, transportService, actionFilters, indexNameExpressionResolver, GetIngestionStateRequest::new, "management");
        this.indicesService = indicesService;
        this.clusterService = clusterService;
        this.client = client;
    }

    @Override
    protected void doExecute(final Task task, final GetIngestionStateRequest request, final ActionListener<GetIngestionStateResponse> listener) {
        if (request.getPageParams() != null) {
            ClusterStateRequest clusterStateRequest = new ClusterStateRequest();
            clusterStateRequest.setShouldCancelOnTimeout(true);
            clusterStateRequest.setParentTask(this.client.getLocalNodeId(), task.getId());
            clusterStateRequest.clear().indices(request.indices()).routingTable(true).metadata(true);
            this.client.admin().cluster().state(clusterStateRequest, new ActionListener<ClusterStateResponse>(){

                public void onResponse(ClusterStateResponse clusterStateResponse) {
                    try {
                        TransportGetIngestionStateAction.this.executePaginatedGetIngestionAction(task, request, (ActionListener<GetIngestionStateResponse>)listener, clusterStateResponse);
                    }
                    catch (Exception e) {
                        listener.onFailure(e);
                    }
                }

                public void onFailure(Exception e) {
                    listener.onFailure((Exception)new OpenSearchException("Failed to retrieve cluster state", (Throwable)e, new Object[0]));
                }
            });
        } else {
            super.doExecute(task, request, listener);
        }
    }

    private void executePaginatedGetIngestionAction(Task task, GetIngestionStateRequest request, final ActionListener<GetIngestionStateResponse> listener, ClusterStateResponse clusterStateResponse) {
        final ShardPaginationStrategy paginationStrategy = new ShardPaginationStrategy(request.getPageParams(), clusterStateResponse.getState(), request.getShards());
        for (ShardRouting shardRouting : paginationStrategy.getRequestedEntities()) {
            request.addIndexShardPair(shardRouting.getIndexName(), shardRouting.getId());
        }
        super.doExecute(task, request, new ActionListener<GetIngestionStateResponse>(this){

            public void onResponse(GetIngestionStateResponse getIngestionStateResponse) {
                getIngestionStateResponse.setNextPageToken(paginationStrategy.getResponseToken().getNextToken());
                listener.onResponse((Object)getIngestionStateResponse);
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    @Override
    protected ShardsIterator shards(ClusterState clusterState, GetIngestionStateRequest request, String[] concreteIndices) {
        Map<String, Set<Integer>> indexShardPairsForPage;
        Set shardSet = Arrays.stream(request.getShards()).boxed().collect(Collectors.toSet());
        Predicate<ShardRouting> shardFilter = ShardRouting::primary;
        if (!shardSet.isEmpty()) {
            shardFilter = shardFilter.and(shardRouting -> shardSet.contains(shardRouting.shardId().getId()));
        }
        if (!(indexShardPairsForPage = request.getIndexShardPairsAsMap()).isEmpty()) {
            shardFilter = shardFilter.and(shardRouting -> indexShardPairsForPage.containsKey(shardRouting.getIndexName()) && ((Set)indexShardPairsForPage.get(shardRouting.getIndexName())).contains(shardRouting.getId()));
        }
        return clusterState.routingTable().allShardsSatisfyingPredicate(request.indices(), shardFilter);
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state, GetIngestionStateRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, GetIngestionStateRequest request, String[] concreteIndices) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, request.indices());
    }

    @Override
    protected ShardIngestionState readShardResult(StreamInput in) throws IOException {
        return new ShardIngestionState(in);
    }

    @Override
    protected GetIngestionStateResponse newResponse(GetIngestionStateRequest request, int totalShards, int successfulShards, int failedShards, List<ShardIngestionState> responses, List<DefaultShardOperationFailedException> shardFailures, ClusterState clusterState) {
        return new GetIngestionStateResponse(responses.toArray(new ShardIngestionState[0]), totalShards, successfulShards, failedShards, null, shardFailures);
    }

    @Override
    protected GetIngestionStateRequest readRequestFrom(StreamInput in) throws IOException {
        return new GetIngestionStateRequest(in);
    }

    @Override
    protected ShardIngestionState shardOperation(GetIngestionStateRequest request, ShardRouting shardRouting) {
        IndexService indexService = this.indicesService.indexServiceSafe(shardRouting.shardId().getIndex());
        IndexShard indexShard = indexService.getShard(shardRouting.shardId().id());
        if (indexShard.routingEntry() == null) {
            throw new ShardNotFoundException(indexShard.shardId());
        }
        try {
            return indexShard.getIngestionState();
        }
        catch (AlreadyClosedException e) {
            throw new ShardNotFoundException(indexShard.shardId());
        }
    }
}

