/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkInsightsAccessScope
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkInsightsAccessScope> {
    private static final SdkField<String> NETWORK_INSIGHTS_ACCESS_SCOPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInsightsAccessScopeId").getter(NetworkInsightsAccessScope.getter(NetworkInsightsAccessScope::networkInsightsAccessScopeId)).setter(NetworkInsightsAccessScope.setter(Builder::networkInsightsAccessScopeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInsightsAccessScopeId").unmarshallLocationName("networkInsightsAccessScopeId").build()}).build();
    private static final SdkField<String> NETWORK_INSIGHTS_ACCESS_SCOPE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInsightsAccessScopeArn").getter(NetworkInsightsAccessScope.getter(NetworkInsightsAccessScope::networkInsightsAccessScopeArn)).setter(NetworkInsightsAccessScope.setter(Builder::networkInsightsAccessScopeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInsightsAccessScopeArn").unmarshallLocationName("networkInsightsAccessScopeArn").build()}).build();
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedDate").getter(NetworkInsightsAccessScope.getter(NetworkInsightsAccessScope::createdDate)).setter(NetworkInsightsAccessScope.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").unmarshallLocationName("createdDate").build()}).build();
    private static final SdkField<Instant> UPDATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedDate").getter(NetworkInsightsAccessScope.getter(NetworkInsightsAccessScope::updatedDate)).setter(NetworkInsightsAccessScope.setter(Builder::updatedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedDate").unmarshallLocationName("updatedDate").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(NetworkInsightsAccessScope.getter(NetworkInsightsAccessScope::tags)).setter(NetworkInsightsAccessScope.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_INSIGHTS_ACCESS_SCOPE_ID_FIELD, NETWORK_INSIGHTS_ACCESS_SCOPE_ARN_FIELD, CREATED_DATE_FIELD, UPDATED_DATE_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NetworkInsightsAccessScope.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String networkInsightsAccessScopeId;
    private final String networkInsightsAccessScopeArn;
    private final Instant createdDate;
    private final Instant updatedDate;
    private final List<Tag> tags;

    private NetworkInsightsAccessScope(BuilderImpl builder) {
        this.networkInsightsAccessScopeId = builder.networkInsightsAccessScopeId;
        this.networkInsightsAccessScopeArn = builder.networkInsightsAccessScopeArn;
        this.createdDate = builder.createdDate;
        this.updatedDate = builder.updatedDate;
        this.tags = builder.tags;
    }

    public final String networkInsightsAccessScopeId() {
        return this.networkInsightsAccessScopeId;
    }

    public final String networkInsightsAccessScopeArn() {
        return this.networkInsightsAccessScopeArn;
    }

    public final Instant createdDate() {
        return this.createdDate;
    }

    public final Instant updatedDate() {
        return this.updatedDate;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInsightsAccessScopeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInsightsAccessScopeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInsightsAccessScope)) {
            return false;
        }
        NetworkInsightsAccessScope other = (NetworkInsightsAccessScope)obj;
        return Objects.equals(this.networkInsightsAccessScopeId(), other.networkInsightsAccessScopeId()) && Objects.equals(this.networkInsightsAccessScopeArn(), other.networkInsightsAccessScopeArn()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.updatedDate(), other.updatedDate()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkInsightsAccessScope").add("NetworkInsightsAccessScopeId", (Object)this.networkInsightsAccessScopeId()).add("NetworkInsightsAccessScopeArn", (Object)this.networkInsightsAccessScopeArn()).add("CreatedDate", (Object)this.createdDate()).add("UpdatedDate", (Object)this.updatedDate()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkInsightsAccessScopeId": {
                return Optional.ofNullable(clazz.cast(this.networkInsightsAccessScopeId()));
            }
            case "NetworkInsightsAccessScopeArn": {
                return Optional.ofNullable(clazz.cast(this.networkInsightsAccessScopeArn()));
            }
            case "CreatedDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "UpdatedDate": {
                return Optional.ofNullable(clazz.cast(this.updatedDate()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NetworkInsightsAccessScopeId", NETWORK_INSIGHTS_ACCESS_SCOPE_ID_FIELD);
        map.put("NetworkInsightsAccessScopeArn", NETWORK_INSIGHTS_ACCESS_SCOPE_ARN_FIELD);
        map.put("CreatedDate", CREATED_DATE_FIELD);
        map.put("UpdatedDate", UPDATED_DATE_FIELD);
        map.put("TagSet", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkInsightsAccessScope, T> g) {
        return obj -> g.apply((NetworkInsightsAccessScope)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String networkInsightsAccessScopeId;
        private String networkInsightsAccessScopeArn;
        private Instant createdDate;
        private Instant updatedDate;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInsightsAccessScope model) {
            this.networkInsightsAccessScopeId(model.networkInsightsAccessScopeId);
            this.networkInsightsAccessScopeArn(model.networkInsightsAccessScopeArn);
            this.createdDate(model.createdDate);
            this.updatedDate(model.updatedDate);
            this.tags(model.tags);
        }

        public final String getNetworkInsightsAccessScopeId() {
            return this.networkInsightsAccessScopeId;
        }

        public final void setNetworkInsightsAccessScopeId(String networkInsightsAccessScopeId) {
            this.networkInsightsAccessScopeId = networkInsightsAccessScopeId;
        }

        @Override
        public final Builder networkInsightsAccessScopeId(String networkInsightsAccessScopeId) {
            this.networkInsightsAccessScopeId = networkInsightsAccessScopeId;
            return this;
        }

        public final String getNetworkInsightsAccessScopeArn() {
            return this.networkInsightsAccessScopeArn;
        }

        public final void setNetworkInsightsAccessScopeArn(String networkInsightsAccessScopeArn) {
            this.networkInsightsAccessScopeArn = networkInsightsAccessScopeArn;
        }

        @Override
        public final Builder networkInsightsAccessScopeArn(String networkInsightsAccessScopeArn) {
            this.networkInsightsAccessScopeArn = networkInsightsAccessScopeArn;
            return this;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final Instant getUpdatedDate() {
            return this.updatedDate;
        }

        public final void setUpdatedDate(Instant updatedDate) {
            this.updatedDate = updatedDate;
        }

        @Override
        public final Builder updatedDate(Instant updatedDate) {
            this.updatedDate = updatedDate;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public NetworkInsightsAccessScope build() {
            return new NetworkInsightsAccessScope(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkInsightsAccessScope> {
        public Builder networkInsightsAccessScopeId(String var1);

        public Builder networkInsightsAccessScopeArn(String var1);

        public Builder createdDate(Instant var1);

        public Builder updatedDate(Instant var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

