/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StatisticType {
    P50("p50"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StatisticType> VALUE_MAP;
    private final String value;

    private StatisticType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StatisticType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StatisticType> knownValues() {
        EnumSet<StatisticType> knownValues = EnumSet.allOf(StatisticType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StatisticType.class, StatisticType::toString);
    }
}

