/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.s3express;

import java.util.Objects;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkInternalApi
public final class S3ExpressIdentityKey
implements ToCopyableBuilder<Builder, S3ExpressIdentityKey> {
    private final String bucket;
    private final SdkClient client;
    private final AwsCredentialsIdentity identity;

    public S3ExpressIdentityKey(Builder builder) {
        this.bucket = (String)Validate.notNull((Object)builder.bucket, (String)"Bucket must not be null", (Object[])new Object[0]);
        this.client = (SdkClient)Validate.notNull((Object)builder.client, (String)"Client must not be null", (Object[])new Object[0]);
        this.identity = (AwsCredentialsIdentity)Validate.notNull((Object)builder.identity, (String)"Identity must not be null", (Object[])new Object[0]);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String bucket() {
        return this.bucket;
    }

    public SdkClient client() {
        return this.client;
    }

    public AwsCredentialsIdentity identity() {
        return this.identity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        S3ExpressIdentityKey that = (S3ExpressIdentityKey)o;
        return Objects.equals(this.bucket, that.bucket) && Objects.equals(this.identity, that.identity);
    }

    public int hashCode() {
        int result = this.bucket != null ? this.bucket.hashCode() : 0;
        result = 31 * result + (this.identity != null ? this.identity.hashCode() : 0);
        return result;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder
    implements CopyableBuilder<Builder, S3ExpressIdentityKey> {
        String bucket;
        SdkClient client;
        AwsCredentialsIdentity identity;

        public Builder() {
        }

        public Builder(S3ExpressIdentityKey s3ExpressIdentityKey) {
            this.bucket = s3ExpressIdentityKey.bucket;
            this.client = s3ExpressIdentityKey.client;
            this.identity = s3ExpressIdentityKey.identity;
        }

        public Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public Builder client(SdkClient client) {
            this.client = client;
            return this;
        }

        public Builder identity(AwsCredentialsIdentity identity) {
            this.identity = identity;
            return this;
        }

        public S3ExpressIdentityKey build() {
            return new S3ExpressIdentityKey(this);
        }
    }
}

