/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.dlic.rest.api.ssl;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.nodes.BaseNodeRequest;
import org.opensearch.action.support.nodes.TransportNodesAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.security.dlic.rest.api.ssl.CertificateInfo;
import org.opensearch.security.dlic.rest.api.ssl.CertificateType;
import org.opensearch.security.dlic.rest.api.ssl.CertificatesInfo;
import org.opensearch.security.dlic.rest.api.ssl.CertificatesInfoNodesRequest;
import org.opensearch.security.dlic.rest.api.ssl.CertificatesNodesResponse;
import org.opensearch.security.ssl.SslContextHandler;
import org.opensearch.security.ssl.SslSettingsManager;
import org.opensearch.security.ssl.config.CertType;
import org.opensearch.security.ssl.config.Certificate;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportCertificatesInfoNodesAction
extends TransportNodesAction<CertificatesInfoNodesRequest, CertificatesNodesResponse, NodeRequest, CertificatesNodesResponse.CertificatesNodeResponse> {
    private final SslSettingsManager sslSettingsManager;

    @Inject
    public TransportCertificatesInfoNodesAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, SslSettingsManager sslSettingsManager) {
        super("cluster:admin/security/certificates/info", threadPool, clusterService, transportService, actionFilters, CertificatesInfoNodesRequest::new, NodeRequest::new, "generic", CertificatesNodesResponse.CertificatesNodeResponse.class);
        this.sslSettingsManager = sslSettingsManager;
    }

    protected CertificatesNodesResponse newResponse(CertificatesInfoNodesRequest request, List<CertificatesNodesResponse.CertificatesNodeResponse> nodeResponses, List<FailedNodeException> failures) {
        return new CertificatesNodesResponse(this.clusterService.getClusterName(), nodeResponses, failures);
    }

    protected NodeRequest newNodeRequest(CertificatesInfoNodesRequest request) {
        return new NodeRequest(request);
    }

    protected CertificatesNodesResponse.CertificatesNodeResponse newNodeResponse(StreamInput in) throws IOException {
        return new CertificatesNodesResponse.CertificatesNodeResponse(in);
    }

    protected CertificatesNodesResponse.CertificatesNodeResponse nodeOperation(NodeRequest request) {
        CertificatesInfoNodesRequest sslCertRequest = request.sslCertsInfoNodesRequest;
        try {
            return new CertificatesNodesResponse.CertificatesNodeResponse(this.clusterService.localNode(), this.loadCertificates(sslCertRequest.certificateType()));
        }
        catch (Exception e) {
            return new CertificatesNodesResponse.CertificatesNodeResponse(this.clusterService.localNode(), e);
        }
    }

    protected CertificatesInfo loadCertificates(CertificateType certificateType) {
        List httpCertificates = List.of();
        List transportsCertificates = List.of();
        if (CertificateType.isHttp(certificateType)) {
            httpCertificates = this.sslSettingsManager.sslContextHandler(CertType.HTTP).map(SslContextHandler::keyMaterialCertificates).map(this::certificatesDetails).orElse(List.of());
        }
        if (CertificateType.isTransport(certificateType)) {
            transportsCertificates = this.sslSettingsManager.sslContextHandler(CertType.TRANSPORT).map(SslContextHandler::keyMaterialCertificates).map(this::certificatesDetails).orElse(List.of());
        }
        return new CertificatesInfo(Map.of(CertificateType.HTTP, httpCertificates, CertificateType.TRANSPORT, transportsCertificates));
    }

    private List<CertificateInfo> certificatesDetails(Stream<Certificate> certificateStream) {
        if (certificateStream == null) {
            return null;
        }
        return certificateStream.map(c -> new CertificateInfo(c.subject(), c.subjectAlternativeNames(), c.issuer(), c.notAfter(), c.notBefore())).collect(Collectors.toList());
    }

    public static class NodeRequest
    extends BaseNodeRequest {
        CertificatesInfoNodesRequest sslCertsInfoNodesRequest;

        public NodeRequest(StreamInput in) throws IOException {
            super(in);
            this.sslCertsInfoNodesRequest = new CertificatesInfoNodesRequest(in);
        }

        NodeRequest(CertificatesInfoNodesRequest request) {
            this.sslCertsInfoNodesRequest = request;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.sslCertsInfoNodesRequest.writeTo(out);
        }
    }
}

