/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.golem;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.sourceforge.plantuml.golem.Path;
import net.sourceforge.plantuml.golem.Position;
import net.sourceforge.plantuml.golem.Tile;
import net.sourceforge.plantuml.golem.TileArea;
import net.sourceforge.plantuml.golem.TileGeometry;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.ULine;

public class TilesField
extends AbstractTextBlock
implements TextBlock {
    private int size = 1;
    private final Tile root = new Tile(0);
    private final Map<Tile, Position> positions = new HashMap<Tile, Position>();
    private final List<Path> paths = new ArrayList<Path>();

    public TilesField() {
        this.positions.put(this.root, new Position(0, 0, 1, 1));
    }

    public Tile getRoot() {
        return this.root;
    }

    public Tile createTile(Tile start, TileGeometry position) {
        Tile result = new Tile(this.size++);
        Position p = this.getFreePosition(start, position);
        this.positions.put(result, p);
        this.paths.add(this.buildPath(start.getArea(position), result.getArea(position.opposite())));
        return result;
    }

    public void addPath(Tile start, Tile dest, TileGeometry startDirection) {
        this.paths.add(this.buildPath(start.getArea(startDirection), dest.getArea(startDirection.opposite())));
    }

    private Path buildPath(TileArea tileArea1, TileArea tileArea2) {
        if (this.isAdjoining(tileArea1, tileArea2)) {
            return Path.build(tileArea1, tileArea2);
        }
        Tile tile1 = tileArea1.getTile();
        Tile tile2 = tileArea2.getTile();
        Position pos1 = this.getPosition(tile1);
        Position pos2 = this.getPosition(tile2);
        TileGeometry geom1 = tileArea1.getGeometry();
        TileGeometry geom2 = tileArea2.getGeometry();
        if (pos1.getYmin() == pos2.getYmin() && pos1.getYmax() == pos2.getYmax() && geom1 == TileGeometry.WEST && geom2 == TileGeometry.EAST) {
            return Path.build(tileArea1, tileArea2);
        }
        throw new IllegalArgumentException();
    }

    private boolean isAdjoining(TileArea tileArea1, TileArea tileArea2) {
        Tile tile1 = tileArea1.getTile();
        Tile tile2 = tileArea2.getTile();
        Position pos1 = this.getPosition(tile1);
        Position pos2 = this.getPosition(tile2);
        TileGeometry geom1 = tileArea1.getGeometry();
        TileGeometry geom2 = tileArea2.getGeometry();
        if (pos1.equals(pos2)) {
            assert (tile1 == tile2);
            if (geom1 == geom2) {
                throw new IllegalArgumentException();
            }
            return true;
        }
        if (!geom1.equals((Object)geom2.opposite())) {
            return false;
        }
        switch (geom1) {
            case EAST: {
                return pos1.getYmin() == pos2.getYmin() && pos1.getYmax() == pos2.getYmax() && pos1.getXmax() + 1 == pos2.getXmin();
            }
            case WEST: {
                return pos1.getYmin() == pos2.getYmin() && pos1.getYmax() == pos2.getYmax() && pos1.getXmin() == pos2.getXmax() + 1;
            }
            case SOUTH: {
                return pos1.getXmin() == pos2.getXmin() && pos1.getXmax() == pos2.getXmax() && pos1.getYmax() + 1 == pos2.getYmin();
            }
            case NORTH: {
                return pos1.getXmin() == pos2.getXmin() && pos1.getXmax() == pos2.getXmax() && pos1.getYmin() == pos2.getYmax() + 1;
            }
            case CENTER: {
                return false;
            }
        }
        throw new IllegalStateException();
    }

    private Tile getTileAt(Position p) {
        for (Map.Entry<Tile, Position> ent : this.positions.entrySet()) {
            if (!p.equals(ent.getValue())) continue;
            return ent.getKey();
        }
        return null;
    }

    private Position getFreePosition(Tile start, TileGeometry position) {
        Position p = this.getPosition(start).move(position, 2);
        while (this.isOccuped(p)) {
            this.moveAllToEast(p);
        }
        return p;
    }

    private void moveAllToEast(Position startingPosition) {
        ArrayList<Position> toMove = new ArrayList<Position>();
        for (Position p : this.positions.values()) {
            if (p.getXmax() < startingPosition.getXmin() || p.getYmax() < startingPosition.getYmin()) continue;
            toMove.add(p);
        }
        for (Position p : toMove) {
            this.positions.put(this.getTileAt(p), p.move(TileGeometry.EAST, 2));
        }
    }

    private boolean isOccuped(Position test) {
        for (Position p : this.positions.values()) {
            if (!p.equals(test)) continue;
            return true;
        }
        return false;
    }

    public Position getPosition(Tile tile) {
        Position result = Objects.requireNonNull(this.positions.get(tile));
        return result;
    }

    private int getXmin() {
        int result = Integer.MAX_VALUE;
        for (Position p : this.positions.values()) {
            int v = p.getXmin();
            if (v >= result) continue;
            result = v;
        }
        return result;
    }

    private int getYmin() {
        int result = Integer.MAX_VALUE;
        for (Position p : this.positions.values()) {
            int v = p.getYmin();
            if (v >= result) continue;
            result = v;
        }
        return result;
    }

    private int getXmax() {
        int result = Integer.MIN_VALUE;
        for (Position p : this.positions.values()) {
            int v = p.getXmax();
            if (v <= result) continue;
            result = v;
        }
        return result;
    }

    private int getYmax() {
        int result = Integer.MIN_VALUE;
        for (Position p : this.positions.values()) {
            int v = p.getYmax();
            if (v <= result) continue;
            result = v;
        }
        return result;
    }

    public List<Path> getPaths() {
        return Collections.unmodifiableList(this.paths);
    }

    @Override
    public void drawU(UGraphic ug) {
        double x = 0.0;
        double y = 0.0;
        int xmin = this.getXmin();
        int ymin = this.getYmin();
        XDimension2D dimSingle = this.root.calculateDimension(ug.getStringBounder());
        x -= (double)xmin * dimSingle.getWidth() / 2.0;
        y -= (double)ymin * dimSingle.getHeight() / 2.0;
        for (Map.Entry<Tile, Position> ent : this.positions.entrySet()) {
            Position p = ent.getValue();
            Tile t2 = ent.getKey();
            double xt = (double)p.getXmin() * dimSingle.getWidth() / 2.0;
            double yt = (double)p.getYmin() * dimSingle.getHeight() / 2.0;
            t2.drawU(ug.apply(new UTranslate(x + xt, y + yt)));
        }
        ug = ug.apply(HColors.RED);
        for (Path p : this.paths) {
            TileArea start = p.getStart();
            TileArea dest = p.getDest();
            XPoint2D pstart = this.getPoint2D(dimSingle, start);
            XPoint2D pdest = this.getPoint2D(dimSingle, dest);
            ug.apply(new UTranslate(x + pstart.getX(), y + pstart.getY())).draw(new ULine(pdest.getX() - pstart.getX(), pdest.getY() - pstart.getY()));
        }
    }

    private XPoint2D getPoint2D(XDimension2D dimSingle, TileArea area) {
        Position p = this.getPosition(area.getTile());
        double xt = (double)p.getXmin() * dimSingle.getWidth() / 2.0;
        double yt = (double)p.getYmin() * dimSingle.getHeight() / 2.0;
        xt += dimSingle.getWidth() / 2.0;
        yt += dimSingle.getHeight() / 2.0;
        double coef = 0.33;
        switch (area.getGeometry()) {
            case NORTH: {
                yt -= dimSingle.getHeight() * 0.33;
                break;
            }
            case SOUTH: {
                yt += dimSingle.getHeight() * 0.33;
                break;
            }
            case EAST: {
                xt += dimSingle.getWidth() * 0.33;
                break;
            }
            case WEST: {
                xt -= dimSingle.getWidth() * 0.33;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return new XPoint2D(xt, yt);
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        int xmin = this.getXmin();
        int xmax = this.getXmax();
        int ymin = this.getYmin();
        int ymax = this.getYmax();
        int width = (xmax - xmin) / 2 + 1;
        int height = (ymax - ymin) / 2 + 1;
        XDimension2D dimSingle = this.root.calculateDimension(stringBounder);
        return new XDimension2D((double)width * dimSingle.getWidth(), (double)height * dimSingle.getHeight());
    }
}

