/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p4nodes.bk;

import java.util.Arrays;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.Spacings;
import org.eclipse.elk.alg.layered.p4nodes.bk.NeighborhoodInformation;

public final class BKAlignedLayout {
    LNode[] root;
    Double[] blockSize;
    LNode[] align;
    Double[] innerShift;
    LNode[] sink;
    Double[] shift;
    Double[] y;
    VDirection vdir;
    HDirection hdir;
    Boolean[] su;
    Boolean[] od;
    LGraph layeredGraph;
    Spacings spacings;

    public BKAlignedLayout(LGraph layeredGraph, int nodeCount, VDirection vdir, HDirection hdir) {
        this.layeredGraph = layeredGraph;
        this.spacings = layeredGraph.getProperty(InternalProperties.SPACINGS);
        this.root = new LNode[nodeCount];
        this.blockSize = new Double[nodeCount];
        this.align = new LNode[nodeCount];
        this.innerShift = new Double[nodeCount];
        this.sink = new LNode[nodeCount];
        this.shift = new Double[nodeCount];
        this.y = new Double[nodeCount];
        this.su = new Boolean[nodeCount];
        Arrays.fill((Object[])this.su, (Object)false);
        this.od = new Boolean[nodeCount];
        Arrays.fill((Object[])this.od, (Object)true);
        this.vdir = vdir;
        this.hdir = hdir;
    }

    public void cleanup() {
        this.root = null;
        this.blockSize = null;
        this.align = null;
        this.innerShift = null;
        this.sink = null;
        this.shift = null;
        this.y = null;
    }

    public double layoutSize() {
        double min2 = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (Layer layer : this.layeredGraph.getLayers()) {
            for (LNode n : layer.getNodes()) {
                double yMin = this.y[n.id];
                double yMax = yMin + this.blockSize[this.root[n.id].id];
                min2 = Math.min(min2, yMin);
                max = Math.max(max, yMax);
            }
        }
        return max - min2;
    }

    public double calculateDelta(LPort src, LPort tgt) {
        double srcPos = this.y[src.getNode().id] + this.innerShift[src.getNode().id] + src.getPosition().y + src.getAnchor().y;
        double tgtPos = this.y[tgt.getNode().id] + this.innerShift[tgt.getNode().id] + tgt.getPosition().y + tgt.getAnchor().y;
        return tgtPos - srcPos;
    }

    public void shiftBlock(LNode rootNode, double delta) {
        LNode current = rootNode;
        do {
            double newPos = this.y[current.id] + delta;
            this.y[current.id] = newPos;
        } while ((current = this.align[current.id]) != rootNode);
    }

    public double checkSpaceAbove(LNode blockRoot, double delta, NeighborhoodInformation ni) {
        LNode rootNode;
        double availableSpace = delta;
        LNode current = rootNode = blockRoot;
        do {
            current = this.align[current.id];
            double minYCurrent = this.getMinY(current);
            LNode neighbor = this.getUpperNeighbor(current, ni);
            if (neighbor == null) continue;
            double maxYNeighbor = this.getMaxY(neighbor);
            availableSpace = Math.min(availableSpace, minYCurrent - (maxYNeighbor + this.spacings.getVerticalSpacing(current, neighbor)));
        } while (rootNode != current);
        return availableSpace;
    }

    public double checkSpaceBelow(LNode blockRoot, double delta, NeighborhoodInformation ni) {
        LNode rootNode;
        double availableSpace = delta;
        LNode current = rootNode = blockRoot;
        do {
            current = this.align[current.id];
            double maxYCurrent = this.getMaxY(current);
            LNode neighbor = this.getLowerNeighbor(current, ni);
            if (neighbor == null) continue;
            double minYNeighbor = this.getMinY(neighbor);
            availableSpace = Math.min(availableSpace, minYNeighbor - (maxYCurrent + this.spacings.getVerticalSpacing(current, neighbor)));
        } while (rootNode != current);
        return availableSpace;
    }

    public double getMinY(LNode n) {
        LNode rootNode = this.root[n.id];
        return this.y[rootNode.id] + this.innerShift[n.id] - n.getMargin().top;
    }

    public double getMaxY(LNode n) {
        LNode rootNode = this.root[n.id];
        return this.y[rootNode.id] + this.innerShift[n.id] + n.getSize().y + n.getMargin().bottom;
    }

    private LNode getLowerNeighbor(LNode n, NeighborhoodInformation ni) {
        int layerIndex = ni.nodeIndex[n.id];
        Layer l = n.getLayer();
        if (layerIndex < l.getNodes().size() - 1) {
            return l.getNodes().get(layerIndex + 1);
        }
        return null;
    }

    private LNode getUpperNeighbor(LNode n, NeighborhoodInformation ni) {
        Layer l = n.getLayer();
        int layerIndex = ni.nodeIndex[n.id];
        if (layerIndex > 0) {
            return l.getNodes().get(layerIndex - 1);
        }
        return null;
    }

    public String toString() {
        String result = "";
        if (this.hdir == HDirection.RIGHT) {
            result = String.valueOf(result) + "RIGHT";
        } else if (this.hdir == HDirection.LEFT) {
            result = String.valueOf(result) + "LEFT";
        }
        result = this.vdir == VDirection.DOWN ? String.valueOf(result) + "DOWN" : (this.vdir == VDirection.UP ? String.valueOf(result) + "UP" : String.valueOf(result) + "BALANCED");
        return result;
    }

    public static enum HDirection {
        RIGHT,
        LEFT;

    }

    public static enum VDirection {
        DOWN,
        UP;

    }
}

