/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.orb;

import com.sun.corba.ee.impl.orb.ParserActionBase;
import com.sun.corba.ee.spi.logging.ORBUtilSystemException;
import com.sun.corba.ee.spi.orb.Operation;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import org.glassfish.pfl.basic.contain.Pair;

public class PrefixParserAction
extends ParserActionBase {
    private static final ORBUtilSystemException wrapper = ORBUtilSystemException.self;
    private Class componentType;

    public PrefixParserAction(String propertyName, Operation operation, String fieldName, Class componentType) {
        super(propertyName, true, operation, fieldName);
        this.componentType = componentType;
    }

    @Override
    public Object apply(Properties props) {
        int prefixLength;
        String prefix = this.getPropertyName();
        if (prefix.charAt((prefixLength = prefix.length()) - 1) != '.') {
            prefix = prefix + '.';
            ++prefixLength;
        }
        LinkedList<Object> matches = new LinkedList<Object>();
        for (String string : props.keySet()) {
            if (!string.startsWith(prefix)) continue;
            String suffix = string.substring(prefixLength);
            String value = props.getProperty(string);
            Pair data = new Pair((Object)suffix, (Object)value);
            Object result = this.getOperation().operate(data);
            matches.add(result);
        }
        int n = matches.size();
        if (n > 0) {
            Object result = null;
            try {
                result = Array.newInstance(this.componentType, n);
            }
            catch (Throwable thr) {
                throw wrapper.couldNotCreateArray(thr, this.getPropertyName(), this.componentType, n);
            }
            Iterator iter2 = matches.iterator();
            int ctr = 0;
            while (iter2.hasNext()) {
                Object obj = iter2.next();
                try {
                    Array.set(result, ctr, obj);
                }
                catch (Throwable thr) {
                    throw wrapper.couldNotSetArray(thr, this.getPropertyName(), ctr, this.componentType, n, obj);
                }
                ++ctr;
            }
            return result;
        }
        return null;
    }
}

