/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.jaxen.function;

import java.util.List;
import nu.xom.jaxen.Context;
import nu.xom.jaxen.Function;
import nu.xom.jaxen.FunctionCallException;
import nu.xom.jaxen.Navigator;
import nu.xom.jaxen.function.NumberFunction;
import nu.xom.jaxen.function.RoundFunction;
import nu.xom.jaxen.function.StringFunction;
import nu.xom.jaxen.function.StringLengthFunction;

public class SubstringFunction
implements Function {
    @Override
    public Object call(Context context, List list) throws FunctionCallException {
        int n = list.size();
        if (n < 2 || n > 3) {
            throw new FunctionCallException("substring() requires two or three arguments.");
        }
        Navigator navigator = context.getNavigator();
        String string = StringFunction.evaluate(list.get(0), navigator);
        if (string == null) {
            return "";
        }
        int n2 = StringLengthFunction.evaluate(list.get(0), navigator).intValue();
        if (n2 == 0) {
            return "";
        }
        Double d = NumberFunction.evaluate(list.get(1), navigator);
        if (d.isNaN()) {
            return "";
        }
        int n3 = RoundFunction.evaluate(d, navigator).intValue() - 1;
        int n4 = n2;
        if (n == 3) {
            Double d2 = NumberFunction.evaluate(list.get(2), navigator);
            n4 = !d2.isNaN() ? RoundFunction.evaluate(d2, navigator).intValue() : 0;
        }
        if (n4 < 0) {
            return "";
        }
        int n5 = n3 + n4;
        if (n == 2) {
            n5 = n2;
        }
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 > n2) {
            return "";
        }
        if (n5 > n2) {
            n5 = n2;
        } else if (n5 < n3) {
            return "";
        }
        if (n2 == string.length()) {
            return string.substring(n3, n5);
        }
        return SubstringFunction.unicodeSubstring(string, n3, n5);
    }

    private static String unicodeSubstring(String string, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(n3);
            if (i >= n) {
                stringBuffer.append(c);
            }
            if (c >= '\ud800') {
                ++n3;
                if (i >= n) {
                    stringBuffer.append(string.charAt(n3));
                }
            }
            ++n3;
        }
        return stringBuffer.toString();
    }
}

