#!/bin/bash
        TEXTDOMAINDIR=/usr/share/locale
        TEXTDOMAIN=ft10-clock
        
window_title=$"FT10-clock"
stopwatch_window_title=$"FT10 Stopwatch"
stopwatch_text=$"Stopwatch"
timers_text=$"Timers"
alarm_text=$"Alarm"
configure_world_clock_text=$"Configure World Clock"
localtimetext=$"Local Time"
TimeZone=$"Time_Zone"

yad_add_command=""
yad_add_command="$yad_add_command $add"

#Allow only one instance of the script running. the wmctrl part is to toogle window on/off from tint2 toolbar
scriptname=/usr/local/lib/ft10/ft10-clock.sh
for pid in $(pidof -x $scriptname); do
    if [ $pid != $$ ]; then
     wmctrl -c $window_title
        exit 1     
    fi 
done


open_tz_settings()
{
	kill -USR1 $YAD_PID
	bash -c /usr/local/lib/ft10/ft10-tz-manager.sh
}

stopwatch_function()
{
		if ! [ -x "$(command -v kronometer)" ]; then
  	roxterm --hide-menubar --title '$stopwatch_window_title' --zoom=0,85 --geometry 30x15 -e bash -c /usr/local/lib/ft10/cli-stopwatch.sh
      else
      kronometer
    fi

	}

export -f open_tz_settings stopwatch_function

####dirty work around poor coding skills:
  local_time=$(date '+%T %a %d/%m/%Y')
  echo "$localtimetext 		$local_time"
  CNT="" 
  
  sed -i '/^[[:space:]]*$/d' $HOME/.world-clock.zones
while read zone
do
  echo $zone '	' $(TZ=$zone date '+%T %a %d/%m/%Y' )
  add=" --field=$TimeZone:"
	CNT="$CNT $add"
done <$HOME/.world-clock.zones 

# helper script to launch geany to edit world-clock timezones (does not work directly on the yad button)
echo "geany $HOME/.world-clock.zones" > /tmp/ft10-world-clock-tz-editor.sh
chmod +x -- /tmp/ft10-world-clock-tz-editor.sh
####end of dirty work around poor coding skills


# create preference file $HOME/.world-clock.zones, if it's missing
if [ ! -f $HOME/.world-clock.zones ]; then
echo "Europe/London
Europe/Paris
Asia/Tokyo
America/St_Johns
Brazil/West" > $HOME/.world-clock.zones
fi

#Make sure that the preference file has no empty lines:
sed -i '/^[[:space:]]*$/d' $HOME/.world-clock.zones


###export -f edit_world_clock
	WORLDCLOCK_ZONES=$HOME/.world-clock.zones
	WORLDCLOCK_FORMAT='+%Y-%m-%d %H:%M:%S'
	
while :
do 
  local_time=$(date '+%T %a %d/%m/%Y')
  echo "$localtimetext 		$local_time"
  CNT="" 

while read zone
do
 #echo $zone '	' $(TZ=$zone date '+%T %a %d/%m/%Y' )
 
 data=$(TZ=$zone date '+%T %a %d/%m/%Y' )
 just_the_time=$(echo $data |cut -d' ' -f1)
 just_the_time_without_seconds=${just_the_time::-3}
 simplified_date_without_seconds=$(echo $data| sed  "s@$just_the_time@$just_the_time_without_seconds @")
 echo $zone '	' $simplified_date_without_seconds
  
  add=' --field="TZ"'
	CNT="$CNT $add"

done <$HOME/.world-clock.zones 
	
   sleep 0.5 
done | yad --title="$window_title" --window-icon=/usr/share/icons/numix-square-antix/48x48/apps/clock.png  --image="clock" --button="$configure_world_clock_text":"bash -c open_tz_settings" --button="$stopwatch_text":" bash -c stopwatch_function" --button="$timers_text":"bash -c  /usr/local/lib/ft10/FT10-timer.sh" --button=$alarm_text:"bash -c  /usr/local/lib/ft10/FT10-yalarm2.sh"  --form --center --cycle-read ----image="clock" --width=700 --field="" $CNT
