#!/bin/sh
#
# gen-changelog.sh
# Copyright 2024 - abc-nix (antiX Linux)
#
# Script to generate changelog file from a template

# Check if required arguments are provided
if [ "$#" -ne 5 ]; then
    echo "gen-changelog.sh - Usage: $0 <maintainer> <version> <subversion> <changelog-template> <debian-release-version>"
    exit 1
fi

# Assign input arguments to variables
MAINTAINER="$1"
VERSION="$2"
SUBVERSION="$3"
CHANGELOG_TEMPLATE="debian/${4}"
RELEASE="${5}"
DATE="$(date -R)"

# Check if changelog template file exists
if [ ! -f "$CHANGELOG_TEMPLATE" ]; then
    echo "Error: $CHANGELOG_TEMPLATE file not found!"
    exit 1
fi

# Generate full version string
FULL_VERSION="${VERSION}-${SUBVERSION}"

# Generate changelog file
sed -e "s/@MAINTAINER@/$MAINTAINER/g" \
    -e "s/@VERSION@/$FULL_VERSION/g" \
    -e "s/@DATE@/$DATE/g" \
    -e "s/@RELEASE@/$RELEASE/g" \
    "$CHANGELOG_TEMPLATE" > debian/changelog

echo "Generated debian/changelog with MAINTAINER=$MAINTAINER, VERSION=$FULL_VERSION, packaged for $RELEASE"
