/*
 * Decompiled with CFR 0.152.
 */
package net.java.html.boot.script;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Bindings;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import net.java.html.boot.script.Sanitizer;
import net.java.html.boot.script.impl.Callback;
import org.netbeans.html.boot.spi.Fn;

final class ScriptPresenter
implements Fn.KeepAlive,
Fn.Presenter,
Fn.FromJavaScript,
Fn.ToJavaScript,
Executor {
    private static final Logger LOG;
    private static final boolean JDK7;
    private final ScriptEngine eng;
    private final Executor exc;
    private final Object undefined;
    private final Set<Class<?>> jsReady;
    private final CallbackImpl callback;
    private FnImpl wrapArrImpl;
    private FnImpl arraySize;
    private FnImpl wrapJavaObject;
    private FnImpl extractJavaObject;

    ScriptPresenter(ScriptEngine eng, Executor exc, boolean sanitize) {
        Object undef;
        if (eng == null) {
            eng = new ScriptEngineManager().getEngineByName("javascript");
        }
        IllegalStateException[] makingPolyglot = new IllegalStateException[]{null};
        if (eng.getFactory().getNames().contains("Graal.js")) {
            try {
                Bindings bindings = eng.getBindings(100);
                bindings.put("polyglot.js.allowHostAccess", (Object)true);
            }
            catch (IllegalStateException ex) {
                makingPolyglot[0] = ex;
            }
        }
        this.eng = eng;
        this.exc = exc;
        try {
            undef = new UndefinedCallback().undefined(eng);
            if (sanitize) {
                Sanitizer.clean(eng);
            }
            Sanitizer.defineAlert(eng);
        }
        catch (ScriptException ex) {
            if (makingPolyglot[0] != null) {
                throw makingPolyglot[0];
            }
            throw new IllegalStateException(ex);
        }
        this.undefined = undef;
        this.jsReady = new HashSet();
        this.callback = new CallbackImpl();
    }

    public Fn defineFn(String code, String ... names) {
        return this.defineImpl(code, names, null);
    }

    public Fn defineFn(String code, String[] names, boolean[] keepAlive) {
        return this.defineImpl(code, names, keepAlive);
    }

    private FnImpl defineImpl(String code, String[] names, boolean[] keepAlive) {
        Object fn;
        StringBuilder sb = new StringBuilder();
        sb.append("(function() {\n");
        sb.append("  return function(");
        String sep = "";
        if (names != null) {
            for (String n : names) {
                sb.append(sep).append(n);
                sep = ",";
            }
        }
        sb.append(") {\n");
        sb.append(code);
        sb.append("\n  };\n");
        sb.append("})()\n");
        try {
            fn = this.eng.eval(sb.toString());
        }
        catch (ScriptException ex) {
            throw new IllegalStateException(ex);
        }
        return new FnImpl(this, fn, keepAlive);
    }

    public void displayPage(URL page, Runnable onPageLoad) {
        try {
            this.eng.eval("if (typeof window !== 'undefined') window.location = '" + page + "'");
        }
        catch (ScriptException ex) {
            LOG.log(Level.SEVERE, "Cannot load " + page, ex);
        }
        if (onPageLoad != null) {
            onPageLoad.run();
        }
    }

    public void loadScript(Reader code) throws Exception {
        this.eng.eval(code);
    }

    private Object convertArrays(Object anyArr) throws Exception {
        int len = Array.getLength(anyArr);
        Object[] arr = new Object[len];
        for (int i = 0; i < len; ++i) {
            Object ith = Array.get(anyArr, i);
            arr[i] = this.toJavaScript(ith, true, true);
        }
        Object wrapArr = this.wrapArrFn().invokeImpl(null, false, arr);
        return wrapArr;
    }

    private FnImpl wrapArrFn() {
        if (this.wrapArrImpl == null) {
            try {
                this.wrapArrImpl = this.defineImpl("return Array.prototype.slice.call(arguments);", null, null);
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
        return this.wrapArrImpl;
    }

    private Object checkArray(Object val) throws Exception {
        if (val instanceof Boolean || val instanceof Number || val instanceof String) {
            return val;
        }
        FnImpl fn = this.arraySizeFn();
        Object fnRes = fn.invokeImpl(null, false, val, null);
        int length = ((Number)fnRes).intValue();
        if (length == -1) {
            return val;
        }
        Object[] arr = new Object[length];
        fn.invokeImpl(null, false, val, arr);
        return arr;
    }

    private FnImpl arraySizeFn() {
        if (this.arraySize == null) {
            try {
                this.arraySize = this.defineImpl("\nif (to == null) {\n  if (Object.prototype.toString.call(arr) === '[object Array]') return arr.length;\n  else return -1;\n} else {\n  var l = arr.length;\n  for (var i = 0; i < l; i++) {\n    to[i] = arr[i] === undefined ? null : arr[i];\n  }\n  return l;\n}", new String[]{"arr", "to"}, null);
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
        return this.arraySize;
    }

    private FnImpl wrapJavaObject() {
        if (this.wrapJavaObject == null) {
            try {
                this.wrapJavaObject = this.defineImpl("\nvar obj = {};\nObject.defineProperty(obj, 'javaObj', {\n  value : function() { callback.callback(java); }\n});\n  if (str) {\n    Object.defineProperty(obj, 'toString', {\n      value : function() { return str; }\n    });\n  }\nreturn obj;\n", new String[]{"java", "callback", "str"}, null);
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
        return this.wrapJavaObject;
    }

    private FnImpl extractJavaObject() {
        if (this.extractJavaObject == null) {
            try {
                this.extractJavaObject = this.defineImpl("\nvar fn = obj && obj['javaObj'];\nif (typeof fn === 'function') {\n  fn();\n};\n", new String[]{"obj"}, null);
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
        return this.extractJavaObject;
    }

    public Object toJava(Object toJS) {
        if (toJS == this.undefined || toJS == null) {
            return null;
        }
        if (toJS instanceof String || toJS instanceof Number || toJS instanceof Boolean || toJS instanceof Character) {
            return toJS;
        }
        this.jsReady.add(toJS.getClass());
        try {
            this.callback.last = this;
            this.extractJavaObject().invokeImpl(null, false, toJS);
            if (this.callback.last != this) {
                toJS = this.callback.last;
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        if (toJS instanceof Weak) {
            toJS = ((Weak)toJS).get();
        }
        if (toJS == this.undefined || toJS == null) {
            return null;
        }
        try {
            return this.checkArray(toJS);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    public Object toJavaScript(Object toReturn) {
        return this.toJavaScript(toReturn, true, true);
    }

    final Object toJavaScript(Object toReturn, boolean arrayChecks, boolean keepAlive) {
        if (toReturn == null || !arrayChecks) {
            return toReturn;
        }
        if (toReturn.getClass().isArray()) {
            try {
                return this.convertArrays(toReturn);
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
        if (JDK7 && toReturn instanceof Boolean) {
            return (Boolean)toReturn != false ? Boolean.valueOf(true) : null;
        }
        if (toReturn.getClass().getSimpleName().equals("$JsCallbacks$")) {
            return toReturn;
        }
        if (toReturn instanceof Character) {
            return (int)((Character)toReturn).charValue();
        }
        if (toReturn instanceof Boolean || toReturn instanceof String || toReturn instanceof Number) {
            return toReturn;
        }
        if (this.isJSReady(toReturn)) {
            return toReturn;
        }
        if (!keepAlive) {
            toReturn = new Weak(toReturn);
        }
        String name = toReturn instanceof Enum ? toReturn.toString() : null;
        try {
            return this.wrapJavaObject().invokeImpl(null, false, toReturn, this.callback, name);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public void execute(final Runnable command) {
        if (Fn.activePresenter() == this) {
            command.run();
            return;
        }
        class Wrap
        implements Runnable {
            Wrap() {
            }

            @Override
            public void run() {
                try (Closeable c = Fn.activate((Fn.Presenter)ScriptPresenter.this);){
                    command.run();
                }
                catch (IOException ex) {
                    throw new IllegalStateException(ex);
                }
            }
        }
        Wrap wrap = new Wrap();
        if (this.exc == null) {
            wrap.run();
        } else {
            this.exc.execute(wrap);
        }
    }

    private boolean isJSReady(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof String) {
            return true;
        }
        if (obj instanceof Number) {
            return true;
        }
        if (obj instanceof Character) {
            return true;
        }
        return this.jsReady.contains(obj.getClass());
    }

    static {
        boolean jdk7;
        LOG = Logger.getLogger(ScriptPresenter.class.getName());
        try {
            Class.forName("java.lang.FunctionalInterface");
            jdk7 = false;
        }
        catch (ClassNotFoundException ex) {
            jdk7 = true;
        }
        JDK7 = jdk7;
    }

    private static final class CallbackImpl
    extends Callback {
        Object last;

        private CallbackImpl() {
        }

        @Override
        public void callback(Object obj) {
            this.last = obj;
        }
    }

    private static final class UndefinedCallback
    extends Callback {
        private Object undefined;

        private UndefinedCallback() {
        }

        @Override
        public void callback(Object obj) {
            this.undefined = obj;
        }

        public Object undefined(ScriptEngine eng) throws ScriptException {
            this.undefined = this;
            try {
                Object fn = eng.eval("(function(js) { js.callback(undefined); })");
                Invocable inv = (Invocable)((Object)eng);
                inv.invokeMethod(fn, "call", null, this);
            }
            catch (NoSuchMethodException ex) {
                throw new ScriptException(ex);
            }
            if (this.undefined == this) {
                throw new IllegalStateException();
            }
            return this.undefined;
        }
    }

    private static final class Weak
    extends WeakReference<Object> {
        public Weak(Object referent) {
            super(referent);
        }
    }

    private class FnImpl
    extends Fn {
        private final Object fn;
        private final boolean[] keepAlive;

        public FnImpl(Fn.Presenter presenter, Object fn, boolean[] keepAlive) {
            super(presenter);
            this.fn = fn;
            this.keepAlive = keepAlive;
        }

        public Object invoke(Object thiz, Object ... args) throws Exception {
            return this.invokeImpl(thiz, true, args);
        }

        final Object invokeImpl(Object thiz, boolean arrayChecks, Object ... args) throws Exception {
            ArrayList<Object> all = new ArrayList<Object>(args.length + 1);
            ScriptPresenter sp = (ScriptPresenter)this.presenter();
            if (thiz == null) {
                all.add(this.fn);
            } else {
                all.add(sp.toJavaScript(thiz, true, true));
            }
            for (int i = 0; i < args.length; ++i) {
                Object conv = sp.toJavaScript(args[i], arrayChecks, this.keepAlive == null || this.keepAlive[i]);
                all.add(conv);
            }
            Object ret = ((Invocable)((Object)ScriptPresenter.this.eng)).invokeMethod(this.fn, "call", all.toArray());
            if (ret == this.fn) {
                return null;
            }
            if (!arrayChecks) {
                return ret;
            }
            return ((ScriptPresenter)this.presenter()).toJava(ret);
        }
    }
}

