/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.relatives;

import genj.gedcom.Entity;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.TagPath;
import genj.report.Report;
import genj.view.ViewContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class ReportRelatives
extends Report {
    private static final int UNKNOWN = 0;
    private static final int MALE = 1;
    private static final int FEMALE = 2;
    private List<Indi> relatives = new ArrayList<Indi>();
    private static final Relative[] RELATIVES = new Relative[]{new Relative("farfar", "father+father"), new Relative("farmor", "father+mother"), new Relative("morfar", "mother+father"), new Relative("mormor", "mother+mother"), new Relative("father", "INDI:FAMC:*:..:HUSB:*"), new Relative("mother", "INDI:FAMC:*:..:WIFE:*"), new Relative("husband", "INDI:FAMS:*:..:HUSB:*"), new Relative("wife", "INDI:FAMS:*:..:WIFE:*"), new Relative("daughter", "INDI:FAMS:*:..:CHIL:*", 2), new Relative("son", "INDI:FAMS:*:..:CHIL:*", 1), new Relative("brother", "father+son|mother+son"), new Relative("sister", "father+daughter|mother+daughter"), new Relative("grandson", "son+son|daughter+son"), new Relative("granddaughter", "son+daughter|daughter+daughter"), new Relative("stepfather", "mother+husband"), new Relative("stepmother", "father+wife"), new Relative("uncle.paternal", "father+brother|father+sister +husband|farfar+wife+son|farfar+wife+daughter+husband|farmor+husband+son|farmor+husband+daughter+husband"), new Relative("uncle.maternal", "mother+brother|mother+sister +husband|morfar+wife+son|morfar+wife+daughter+husband|mormor+husband+son|mormor+husband+daughter+husband"), new Relative("aunt.paternal", "father+sister |father+brother+wife|farfar+wife+daughter|farfar+wife+son+wife|farmor+husband+daughter|farmor+husband+son+wife"), new Relative("aunt.maternal", "mother+sister |mother+brother+wife|morfar+wife+daughter|morfar+wife+son+wife|mormor+husband+daughter|mormor+husband+son+wife"), new Relative("nephew.fraternal", "brother+son"), new Relative("niece.fraternal", "brother+daughter"), new Relative("nephew.sororal", "sister+son"), new Relative("niece.sororal", "sister+daughter"), new Relative("cousin.paternal", "uncle.paternal+son|uncle.paternal+daughter+husband"), new Relative("cousin.maternal", "uncle.maternal+son|uncle.maternal+daughter+husband"), new Relative("cousine.paternal", "uncle.paternal+daughter|uncle.paternal+son+wife"), new Relative("cousine.maternal", "uncle.maternal+daughter|uncle.maternal+son+wife")};

    public List<ViewContext> start(Indi indi) {
        this.relatives.clear();
        HashMap<String, Relative> key2relative = new HashMap<String, Relative>();
        for (Relative relative : RELATIVES) {
            key2relative.put(relative.key, relative);
        }
        ArrayList<ViewContext> result = new ArrayList<ViewContext>();
        result.add(new ViewContext((Entity)indi));
        this.relatives.add(indi);
        for (Relative relative : RELATIVES) {
            HashSet<ViewContext> currentSet = new HashSet<ViewContext>();
            HashSet<Indi> resultIndi = new HashSet<Indi>();
            for (Indi found : this.find((Property)indi, relative.expression, relative.sex, key2relative)) {
                if (this.relatives.contains(found)) continue;
                currentSet.add(new ViewContext((Entity)found).setText(this.translate(relative.key) + ": " + found));
                resultIndi.add(found);
            }
            result.addAll(currentSet);
            this.relatives.addAll(resultIndi);
        }
        return result;
    }

    public List<Indi> getRelatives(Indi indi) {
        this.start(indi);
        return this.relatives;
    }

    private Set<Indi> find(Set<Indi> roots, String expression, int sex, Map<String, Relative> key2relative) {
        HashSet<Indi> result = new HashSet<Indi>();
        for (Indi indi : roots) {
            result.addAll(this.find((Property)indi, expression, sex, key2relative));
        }
        return result;
    }

    private Set<Indi> find(Property root, String expression, int sex, Map<String, Relative> key2relative) {
        Property[] found;
        int or = expression.indexOf(124);
        if (or > 0) {
            HashSet<Indi> result = new HashSet<Indi>();
            StringTokenizer ors = new StringTokenizer(expression, "|");
            while (ors.hasMoreTokens()) {
                result.addAll(this.find(root, ors.nextToken().trim(), sex, key2relative));
            }
            return result;
        }
        int dot = expression.indexOf(43);
        if (dot > 0) {
            Set<Indi> roots = new HashSet<Indi>();
            roots.add((Indi)root.getEntity());
            StringTokenizer cont = new StringTokenizer(expression, "+");
            while (cont.hasMoreTokens()) {
                roots = this.find(roots, cont.nextToken(), sex, key2relative);
            }
            return roots;
        }
        int colon = expression.indexOf(58);
        if (colon < 0) {
            Relative relative = key2relative.get(expression.trim());
            return this.find(root, relative.expression, relative.sex, key2relative);
        }
        HashSet<Indi> result = new HashSet<Indi>();
        for (Property found1 : found = root.getProperties(new TagPath(expression))) {
            Indi indi = (Indi)found1.getEntity();
            if (indi == root || sex != 0 && indi.getSex() != sex) continue;
            result.add(indi);
        }
        return result;
    }

    static class Relative {
        String key;
        String expression;
        int sex;

        Relative(String key, String expression) {
            this(key, expression, 0);
        }

        Relative(String key, String expression, int sex) {
            this.key = key;
            this.expression = expression.trim();
            this.sex = sex;
        }
    }
}

