/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.imports.gedcom;

import ancestris.api.imports.Import;
import ancestris.api.imports.ImportFix;
import ancestris.modules.imports.gedcom.Bundle;
import ancestris.modules.imports.gedcom.FixesWindow;
import genj.gedcom.Context;
import genj.gedcom.Gedcom;
import genj.gedcom.TagPath;
import java.io.IOException;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class ImportRootsMagic
extends Import {
    private static final Logger LOG = Logger.getLogger("ancestris.app", null);
    protected static final String SPECIAL_EVENTS = "(WAC|Degree|Military|Mission|Stillborn|Illness|Living|Elected|Excomm|Namesake|Separation|AltName|_DNA|Misc|Race|Civi|Arrival|Departure|CongressionalDistrict|Locati|ARI|PLC_Orgin)";
    protected static final Pattern SPECIAL_EVENTS_PATTERN = Pattern.compile("(WAC|Degree|Military|Mission|Stillborn|Illness|Living|Elected|Excomm|Namesake|Separation|AltName|_DNA|Misc|Race|Civi|Arrival|Departure|CongressionalDistrict|Locati|ARI|PLC_Orgin)");
    private int folderIndex = 0;

    public boolean isGeneric() {
        return false;
    }

    public String toString() {
        return Bundle.importrootsmagic_name();
    }

    protected String getImportComment() {
        return Bundle.importrootsmagic_note();
    }

    public void showDetails(Context context, boolean extract) {
        new FixesWindow(this.summary, context, this.fixes).displayFixes(extract);
    }

    protected void init() {
        super.init();
    }

    protected void firstPass() {
        super.firstPass();
    }

    protected boolean process() throws IOException {
        TagPath path = this.input.getPath();
        String pathBefore = path.getShortName();
        if (this.input.getLevel() == 0 && ("_TASK".equals(this.input.getTag()) || "_FOLDER".equals(this.input.getTag()))) {
            String valueBefore = this.input.getValue();
            String pathAfter = "NOTE";
            String xref = this.currentXref;
            if ("_FOLDER".equals(this.input.getTag()) && xref.isEmpty()) {
                ++this.folderIndex;
                xref = "FOLDER" + this.folderIndex;
            }
            this.output.writeLine(this.input.getLevel(), xref, "NOTE", valueBefore);
            this.fixes.add(new ImportFix(xref, "invalidEntity.01", pathBefore, pathAfter, valueBefore, valueBefore));
            return true;
        }
        if ("_FOLDER:NOTE".equalsIgnoreCase(pathBefore)) {
            String valueBefore = this.input.getValue();
            this.output.writeLine(1, "CONT", valueBefore);
            String xref = "FOLDER" + this.folderIndex;
            this.fixes.add(new ImportFix(xref, "invalidEntity.02", pathBefore, "NOTE:CONT", valueBefore, valueBefore));
            return true;
        }
        if ("_FOLDER:NOTE:CONC".equalsIgnoreCase(pathBefore) || "_FOLDER:NOTE:CONT".equalsIgnoreCase(pathBefore)) {
            String valueBefore = this.input.getValue();
            this.output.writeLine(1, this.input.getTag(), valueBefore);
            String xref = "FOLDER" + this.folderIndex;
            this.fixes.add(new ImportFix(xref, "invalidEntity.02", pathBefore, "NOTE:" + this.input.getTag(), valueBefore, valueBefore));
            return true;
        }
        if (this.input.getLevel() == 0 && (this.input.getTag().equals("_PLAC") || this.input.getTag().equals("_EVDEF"))) {
            this.input.getNextLine(false);
            while (this.input.getLevel() != 0) {
                this.input.getNextLine(true);
                this.input.getNextLine(false);
            }
            return true;
        }
        if (this.input.getLevel() == 1 && SPECIAL_EVENTS_PATTERN.matcher(this.input.getTag()).matches()) {
            String valueBefore = this.input.getValue();
            String valueAfter = this.input.getTag() + (valueBefore.isEmpty() ? "" : " - " + valueBefore);
            this.output.writeLine(1, "EVEN", valueAfter);
            this.fixes.add(new ImportFix(this.currentXref, "invalidTag.2", pathBefore, path.getParent().getShortName() + ":EVEN", valueBefore, valueAfter));
            return true;
        }
        return super.process();
    }

    protected void finalise() throws IOException {
        super.finalise();
    }

    public boolean fixGedcom(Gedcom gedcom) {
        boolean ret = super.fixGedcom(gedcom);
        return ret;
    }

    public void complete() {
        super.complete();
    }

    public boolean fixOther(Gedcom gedcom) {
        return false;
    }
}

