/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.generator;

import org.graphstream.algorithm.generator.BaseGenerator;

public class PetersenGraphGenerator
extends BaseGenerator {
    private int[][] nodes = new int[][]{{0, 2, 4, 1, 3}, {7, 6, 5, 9, 8}};

    @Override
    public void begin() {
        this.makeCycle(0, 4);
        this.makeCycle(5, 9);
        double a = 1.5707963267948966;
        double d = 1.2566370614359172;
        for (int i = 0; i < 5; ++i) {
            String id1 = this.getNodeId(this.nodes[0][i]);
            String id2 = this.getNodeId(this.nodes[1][i]);
            this.addEdge(this.getEdgeId(this.nodes[0][i], this.nodes[1][i]), id1, id2);
            double x = Math.cos(a);
            double y = Math.sin(a);
            this.sendNodeAttributeAdded(this.sourceId, id1, "x", x);
            this.sendNodeAttributeAdded(this.sourceId, id1, "y", y);
            this.sendNodeAttributeAdded(this.sourceId, id2, "x", 2.0 * x);
            this.sendNodeAttributeAdded(this.sourceId, id2, "y", 2.0 * y);
            a += d;
        }
    }

    @Override
    public boolean nextEvents() {
        return false;
    }

    protected void makeCycle(int i, int j) {
        for (int k = i; k <= j; ++k) {
            this.addNode(this.getNodeId(k));
            if (k <= i) continue;
            this.addEdge(this.getEdgeId(k - 1, k), this.getNodeId(k - 1), this.getNodeId(k));
        }
        this.addEdge(this.getEdgeId(i, j), this.getNodeId(i), this.getNodeId(j));
    }

    protected String getNodeId(int i) {
        return String.format("%02d", i);
    }

    protected String getEdgeId(int i, int j) {
        if (i > j) {
            j += i;
            i = j - i;
            j -= i;
        }
        return String.format("(%s;%s)", this.getNodeId(i), this.getNodeId(j));
    }
}

