/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.generator;

import org.graphstream.algorithm.generator.BaseGenerator;

public class WattsStrogatzGenerator
extends BaseGenerator {
    protected int n;
    protected int k;
    protected double beta;
    protected int current;

    public WattsStrogatzGenerator(int n, int k, double beta) {
        this.setUseInternalGraph(true);
        if (n <= k) {
            throw new RuntimeException("parameter n must be >> k");
        }
        if (beta < 0.0 || beta > 1.0) {
            throw new RuntimeException("parameter beta must be between 0 and 1");
        }
        if (k % 2 != 0) {
            throw new RuntimeException("parameter k must be even");
        }
        if (k < 2) {
            throw new RuntimeException("parameter k must be >= 2");
        }
        this.n = n;
        this.k = k;
        this.beta = beta;
    }

    @Override
    public void begin() {
        double step = Math.PI * 2 / (double)this.n;
        double x = 0.0;
        for (int i = 0; i < this.n; ++i) {
            this.addNode(this.nodeId(i), Math.cos(x), Math.sin(x));
            x += step;
        }
        int kk = this.k / 2;
        for (int i = 0; i < this.n; ++i) {
            for (int j = 1; j <= kk; ++j) {
                int jj = (i + j) % this.n;
                this.addEdge(this.edgeId(i, jj), this.nodeId(i), this.nodeId(jj));
            }
        }
        this.current = 0;
    }

    @Override
    public boolean nextEvents() {
        int kk = this.k / 2;
        if (this.current < this.n) {
            for (int j = 1; j <= kk; ++j) {
                int jj = (this.current + j) % this.n;
                if (!(this.random.nextDouble() < this.beta)) continue;
                this.delEdge(this.edgeId(this.current, jj));
                int newTarget = this.chooseNewNode(this.current, jj);
                String edgeId = this.edgeId(this.current, newTarget);
                if (this.internalGraph.getEdge(edgeId) != null) continue;
                this.addEdge(edgeId, this.nodeId(this.current), this.nodeId(newTarget));
            }
            ++this.current;
            return true;
        }
        return false;
    }

    @Override
    public void end() {
        super.end();
    }

    protected String nodeId(int id) {
        return String.format("%d", id);
    }

    protected String edgeId(int from, int to) {
        if (from > to) {
            to += from;
            from = to - from;
            to -= from;
        }
        return String.format("%d_%d", from, to);
    }

    protected int chooseNewNode(int avoid, int old) {
        int newId = 0;
        boolean exists = true;
        do {
            boolean bl = exists = this.internalGraph.getEdge(this.edgeId(avoid, newId = this.random.nextInt(this.n))) != null;
        } while (newId == avoid || exists);
        return newId;
    }
}

