/*
 * Decompiled with CFR 0.152.
 */
package genj.tree;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GridCache {
    private static final List EMPTY = new ArrayList(0);
    private Object[][] grid;
    private Rectangle2D system;
    private double resolution;

    public GridCache(Rectangle2D syStem, double resolUtion) {
        this.system = syStem;
        this.resolution = resolUtion;
        int cols = (int)Math.ceil(this.system.getWidth() / this.resolution);
        int rows = (int)Math.ceil(this.system.getHeight() / this.resolution);
        this.grid = new Object[rows][cols];
    }

    public void put(Object object, Rectangle2D range, Point2D pos) {
        int scol = (int)Math.floor((range.getMinX() + pos.getX() - this.system.getMinX()) / this.resolution);
        int srow = (int)Math.floor((range.getMinY() + pos.getY() - this.system.getMinY()) / this.resolution);
        int ecol = (int)Math.ceil((range.getMaxX() + pos.getX() - this.system.getMinX()) / this.resolution);
        int erow = (int)Math.ceil((range.getMaxY() + pos.getY() - this.system.getMinY()) / this.resolution);
        if (scol > this.grid[0].length || srow > this.grid.length || ecol < 0 || erow < 0) {
            return;
        }
        if (srow < 0) {
            srow = 0;
        }
        if (erow > this.grid.length) {
            erow = this.grid.length;
        }
        if (scol < 0) {
            scol = 0;
        }
        if (ecol > this.grid[0].length) {
            ecol = this.grid[0].length;
        }
        for (int row = srow; row < erow; ++row) {
            for (int col = scol; col < ecol; ++col) {
                this.put(object, row, col);
            }
        }
    }

    public void put(Object object, int row, int col) {
        Object old = this.grid[row][col];
        if (old == null) {
            this.grid[row][col] = object;
        } else if (old instanceof EntryList) {
            ((EntryList)old).add(object);
        } else {
            EntryList l = new EntryList();
            l.add(old);
            l.add(object);
            this.grid[row][col] = l;
        }
    }

    public Set get(Rectangle2D range) {
        HashSet result = new HashSet();
        int scol = (int)Math.floor((range.getMinX() - this.system.getMinX()) / this.resolution);
        int srow = (int)Math.floor((range.getMinY() - this.system.getMinY()) / this.resolution);
        int ecol = (int)Math.ceil((range.getMaxX() - this.system.getMinX()) / this.resolution);
        int erow = (int)Math.ceil((range.getMaxY() - this.system.getMinY()) / this.resolution);
        if (scol > this.grid[0].length || srow > this.grid.length || ecol < 0 || erow < 0) {
            return result;
        }
        if (srow < 0) {
            srow = 0;
        }
        if (erow > this.grid.length) {
            erow = this.grid.length;
        }
        if (scol < 0) {
            scol = 0;
        }
        if (ecol > this.grid[0].length) {
            ecol = this.grid[0].length;
        }
        for (int row = srow; row < erow; ++row) {
            for (int col = scol; col < ecol; ++col) {
                this.get(result, row, col);
            }
        }
        return result;
    }

    public void get(Set set, int row, int col) {
        Object o = this.grid[row][col];
        if (o == null) {
            return;
        }
        if (o instanceof EntryList) {
            set.addAll((EntryList)o);
        } else {
            set.add(o);
        }
    }

    private class EntryList
    extends ArrayList {
        private EntryList() {
            super(8);
        }
    }
}

