/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.gedcomvalidate;

import ancestris.modules.gedcom.gedcomvalidate.GedcomValidate;
import ancestris.modules.gedcom.gedcomvalidate.Test;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;
import genj.view.ViewContext;
import java.util.List;
import org.openide.util.NbBundle;

class TestSpouseGender
extends Test {
    TestSpouseGender() {
        super(new String[]{"FAM"}, Property.class);
    }

    @Override
    void test(Property prop, TagPath path, List<ViewContext> issues, GedcomValidate report) {
        Indi wife;
        Fam fam = (Fam)prop;
        Indi husband = fam.getHusband();
        if (!this.testSex(husband, 1)) {
            this.addIssue(issues, fam, "HUSB", report);
        }
        if (!this.testSex(wife = fam.getWife(), 2)) {
            this.addIssue(issues, fam, "WIFE", report);
        }
    }

    private boolean testSex(Indi indi, int sex) {
        return indi == null ? true : indi.getSex() == sex;
    }

    private void addIssue(List<ViewContext> issues, Fam fam, String role, GedcomValidate report) {
        PropertyXRef xref = (PropertyXRef)fam.getProperty(role);
        Indi indi = (Indi)xref.getTargetEntity();
        issues.add(new ViewContext((Property)xref).setCode(this.getCode()).setText(NbBundle.getMessage(this.getClass(), (String)("err.spouse." + role), (Object)Gedcom.getName((String)role), (Object)(indi == null ? "" : indi.toString()))));
    }

    @Override
    String getCode() {
        return "11";
    }
}

