/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.htmlui;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.netbeans.modules.htmlui.Buttons;
import org.netbeans.modules.htmlui.HtmlToolkit;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public final class HTMLDialogImpl
implements Runnable {
    private volatile int state;
    private JComponent p;
    private DialogDescriptor dd;
    private Object webView;
    private String url;
    private Runnable onPageLoad;
    private List<String> techIds = new ArrayList<String>();
    private boolean nestedLoop;

    public void setUrl(String url) {
        this.url = url;
    }

    public void setOnPageLoad(Runnable onPageLoad) {
        this.onPageLoad = onPageLoad;
    }

    public void addTechIds(String[] ids) {
        this.techIds.addAll(Arrays.asList(ids));
    }

    @Override
    public void run() {
        switch (this.state) {
            case 0: {
                this.initPanel();
                break;
            }
            case 1: {
                this.state = 2;
                this.webView = HtmlToolkit.getDefault().initHtmlDialog(this.url, this.dd, this.p, this, this.techIds);
                break;
            }
            case 2: {
                this.initPage();
                if (this.nestedLoop) {
                    this.state = 3;
                    EventQueue.invokeLater(this);
                    break;
                }
                this.state = -1;
                break;
            }
            case 3: {
                this.showDialog();
                this.state = 4;
                HtmlToolkit.getDefault().execute(this);
                break;
            }
            case 4: {
                this.state = -1;
                HtmlToolkit.getDefault().exitNestedLoop(this);
                break;
            }
            default: {
                throw new IllegalStateException("State: " + this.state);
            }
        }
    }

    public String showAndWait() {
        if (EventQueue.isDispatchThread()) {
            this.run();
            this.showDialog();
        } else if (HtmlToolkit.getDefault().isApplicationThread()) {
            this.nestedLoop = true;
            EventQueue.invokeLater(this);
            HtmlToolkit.getDefault().enterNestedLoop(this);
        } else {
            try {
                EventQueue.invokeAndWait(this);
            }
            catch (InterruptedException | InvocationTargetException ex) {
                throw new IllegalStateException(ex);
            }
            this.showDialog();
        }
        Object val = this.dd.getValue();
        return val instanceof JButton ? ((JButton)val).getName() : null;
    }

    private void showDialog() {
        this.p.setPreferredSize(new Dimension(600, 400));
        Dialog d = DialogDisplayer.getDefault().createDialog(this.dd);
        d.setVisible(true);
    }

    private void initPanel() {
        this.p = HtmlToolkit.getDefault().newPanel();
        this.dd = new DialogDescriptor((Object)this.p, "");
        this.dd.setOptions(new Object[0]);
        this.state = 1;
        HtmlToolkit.getDefault().execute(this);
    }

    private void initPage() {
        try {
            this.onPageLoad.run();
        }
        catch (Throwable t) {
            Exceptions.printStackTrace((Throwable)t);
        }
        Object[] buttons = Buttons.buttons();
        this.dd.setOptions(buttons);
    }

    public <C> C component(Class<C> type) {
        URL pageUrl;
        this.state = -1;
        ClassLoader loader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        if (loader == null) {
            loader = HTMLDialogImpl.class.getClassLoader();
        }
        try {
            pageUrl = new URL(this.url);
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException(ex);
        }
        return HtmlToolkit.getDefault().convertToComponent(type, pageUrl, loader, this.onPageLoad, this.techIds);
    }
}

