/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.webbook.creator;

import ancestris.modules.webbook.WebBookParams;
import ancestris.modules.webbook.creator.Ancestor;
import ancestris.modules.webbook.creator.WebHelper;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyPlace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;

class GedcomStats {
    public WebHelper wh = null;
    public Indi indiDeCujus = null;
    public int nbAncestors = 0;
    public int nbGen = 0;
    public Indi indiOlder = null;
    public Indi longIndiG = null;
    public int nbGenG = 0;
    public Indi longIndiA = null;
    public int nbAncestorsA = 0;
    public int nbIndis = 0;
    public int nbFams = 0;
    public int nbNames = 0;
    public int nbPlaces = 0;
    public int nbAscendants = 0;
    public int nbCousins = 0;
    public int nbOthers = 0;
    public int nbFamsWithKids = 0;
    public double avgKids = 0.0;
    public String place = "";
    public Property propertyPlace;
    private int nbGenTemp = 0;
    private int nbAncestorsTemp = 0;

    public GedcomStats(WebBookParams wp, WebHelper wh) {
        this.wh = wh;
        this.indiDeCujus = wh.getIndiDeCujus(wp.param_decujus);
        this.update(wh.gedcom, wp.param_dispStatAncestor.equals("1"));
    }

    private final boolean update(Gedcom gedcom, boolean dispLonguest) {
        this.calcGenAncestors(this.indiDeCujus, true);
        this.nbGen = this.nbGenTemp - 1;
        this.nbAncestors = this.nbAncestorsTemp - 1;
        this.nbIndis = this.wh.getNbIndis();
        this.nbAscendants = this.wh.getAncestors(this.indiDeCujus).size();
        this.nbCousins = this.wh.getCousins(this.indiDeCujus).size();
        this.nbOthers = this.nbIndis - this.nbAscendants - this.nbCousins;
        this.nbAscendants = Math.max(this.nbAscendants - 1, 0);
        List entities = gedcom.getEntities();
        ArrayList<Property> placesProps = new ArrayList<Property>();
        for (Entity ent : entities) {
            this.wh.getPropertiesRecursively((Property)ent, placesProps, PropertyPlace.class);
        }
        this.nbPlaces = this.wh.getTotalCitiesCount();
        int max = 0;
        Integer val = 0;
        String juridic = "";
        TreeMap<String, Integer> placeTop = new TreeMap<String, Integer>();
        for (Property prop : placesProps) {
            if (prop instanceof PropertyPlace) {
                juridic = ((PropertyPlace)prop).getCity().trim();
            }
            if (juridic == null || juridic.length() <= 0) continue;
            val = 1;
            if (placeTop.get(juridic) != null) {
                val = (Integer)placeTop.get(juridic) + 1;
            }
            placeTop.put(juridic, val);
            if (val <= max) continue;
            max = val;
            this.place = juridic;
            this.propertyPlace = prop;
        }
        Collection families = gedcom.getEntities("FAM");
        this.nbFams = families.size();
        int cptKids = 0;
        int cptFams = 0;
        for (Fam family : families) {
            int nb = family.getNoOfChildren();
            if (nb <= 0) continue;
            ++cptFams;
            cptKids += nb;
        }
        this.nbFamsWithKids = cptFams;
        this.avgKids = this.nbFamsWithKids > 0 ? (double)(cptKids * 100 / this.nbFamsWithKids) : 0.0;
        this.avgKids /= 100.0;
        this.nbNames = this.wh.getTotalNamesCount();
        return true;
    }

    private void calcGenAncestors(Indi indiStart, boolean calcOlder) {
        List<Ancestor> ancestorsList = this.wh.getAncestorsList(indiStart);
        this.nbGenTemp = 1;
        this.nbAncestorsTemp = 0;
        this.indiOlder = indiStart;
        PropertyDate propDateMin = new PropertyDate(9999);
        HashSet<Indi> listDifferent = new HashSet<Indi>();
        for (Ancestor ancestor : ancestorsList) {
            PropertyDate propDate;
            if (ancestor.gen > this.nbGenTemp) {
                this.nbGenTemp = ancestor.gen;
                if (calcOlder) {
                    this.indiOlder = ancestor.indi;
                }
            }
            listDifferent.add(ancestor.indi);
            if (!calcOlder || (propDate = ancestor.indi.getBirthDate()) == null || !propDate.isValid() || propDate.compareTo((Property)propDateMin) >= 0) continue;
            propDateMin = propDate;
            this.indiOlder = ancestor.indi;
        }
        this.nbAncestorsTemp = listDifferent.size();
    }

    public void calcLonguestLine(Indi indiRef) {
        int nbG = 0;
        int nbA = 0;
        List<Indi> indis = this.wh.getIndividuals(indiRef.getGedcom(), null);
        for (Indi indi : indis) {
            this.calcGenAncestors(indi, false);
            if (this.nbGenTemp > nbG) {
                nbG = this.nbGenTemp;
                this.longIndiG = indi;
            }
            if (this.nbGenTemp == nbG && indi == indiRef) {
                this.longIndiG = indi;
            }
            if (this.nbAncestorsTemp > nbA) {
                nbA = this.nbAncestorsTemp;
                this.longIndiA = indi;
            }
            if (this.nbAncestorsTemp != nbA || indi != indiRef) continue;
            this.longIndiA = indi;
        }
        this.nbGenG = nbG - 1;
        this.nbAncestorsA = nbA - 1;
    }
}

