/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.geo;

import ancestris.api.place.Place;
import ancestris.api.place.PlaceFactory;
import ancestris.modules.geo.GeoFilter;
import ancestris.modules.geo.GeoListTopComponent;
import ancestris.modules.geo.GeoPlacesList;
import ancestris.modules.place.geonames.GeonamesResearcher;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyLatitude;
import genj.gedcom.PropertyLongitude;
import genj.gedcom.PropertyPlace;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.PointInTime;
import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.jxmapviewer.viewer.GeoPosition;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class GeoNodeObject {
    private final GeoPlacesList gplOwner;
    public boolean isEvent;
    public static final int GEO_SEARCH_LOCAL_ONLY = 0;
    public static final int GEO_SEARCH_LOCAL_THEN_WEB = 1;
    public static final int GEO_SEARCH_WEB_ONLY = 2;
    private static final int GEO_CONFIRMED = 2;
    private static final int GEO_PROPOSED = 1;
    private static final int GEO_UNKNOWN = 0;
    private static final String COLOR_CONFIRMED = "color='!textText'";
    private static final String COLOR_PROPOSED = "color='#0066ff'";
    private static final String COLOR_UNKNOWN = "color='#ff2300'";
    private static final String EMPTY_PLACE = NbBundle.getMessage(GeoListTopComponent.class, (String)"GeoEmpty");
    private GeonamesResearcher geonamesResearcher = null;
    public Place defaultPlace = null;
    private int geo_type = 0;
    private final PropertyPlace propertyPlace;
    private Double latitude = null;
    private Double longitude = null;
    private Place toponym = null;
    public boolean isInError = false;
    private String placeDisplayFormat = "";
    private String placeKey = "";
    private final Property property;
    private List<GeoNodeObject> events = new ArrayList<GeoNodeObject>();
    private final List<PropertyChangeListener> listeners;

    public GeoNodeObject(GeonamesResearcher geonamesResearcher, GeoPlacesList gplOwner, PropertyPlace pPlace, int internetSearchType) {
        this.geonamesResearcher = geonamesResearcher;
        this.defaultPlace = geonamesResearcher.defaultPlace();
        this.listeners = Collections.synchronizedList(new LinkedList());
        this.gplOwner = gplOwner;
        this.propertyPlace = pPlace;
        this.placeDisplayFormat = gplOwner.getPlaceDisplayFormat(pPlace);
        this.placeKey = gplOwner.getPlaceKey(pPlace);
        this.property = pPlace.getParent();
        this.isEvent = false;
        if (this.placeDisplayFormat.equals(EMPTY_PLACE)) {
            this.toponym = this.defaultPlace;
        } else {
            this.toponym = this.getToponymFromPlace(pPlace, internetSearchType);
            if (this.toponym == null || this.toponym == this.defaultPlace) {
                this.toponym = new PlaceFactory(pPlace);
            }
        }
        this.setGedcomCoordinates();
        this.events.add(new GeoNodeObject(gplOwner, pPlace.getParent(), pPlace));
    }

    public GeoNodeObject(GeoPlacesList gplOwner, Property event, PropertyPlace pp) {
        this.listeners = Collections.synchronizedList(new LinkedList());
        this.isEvent = true;
        this.events = null;
        this.property = event;
        this.propertyPlace = pp;
        this.gplOwner = gplOwner;
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.listeners.add(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.listeners.remove(pcl);
    }

    public final Place getToponymFromPlace(PropertyPlace place, int internetSearchType) {
        Place retPlace = null;
        boolean foundLocally = false;
        String placePieces = place.getPlaceToLocalFormat();
        if (placePieces.isEmpty()) {
            return this.defaultPlace;
        }
        String city = place.getCity();
        if (city.isEmpty()) {
            return this.defaultPlace;
        }
        if (internetSearchType != 2) {
            retPlace = PlaceFactory.getLocalPlace((PropertyPlace)place);
            boolean bl = foundLocally = retPlace != null;
        }
        if (!foundLocally && internetSearchType != 0 || internetSearchType == 2) {
            retPlace = this.geonamesResearcher.searchMassPlace(placePieces, city, this.defaultPlace);
            boolean bl = this.isInError = retPlace == null;
        }
        if (!foundLocally && retPlace != null && retPlace != this.defaultPlace) {
            PlaceFactory.putLocalPlace((PropertyPlace)place, (Place)retPlace);
        }
        return retPlace;
    }

    private void setGedcomCoordinates() {
        PropertyLongitude lon;
        this.latitude = null;
        this.longitude = null;
        PropertyLatitude lat = this.propertyPlace.getLatitude(true);
        if (lat != null && lat.isValid()) {
            this.latitude = lat.getDoubleValue();
        }
        if ((lon = this.propertyPlace.getLongitude(true)) != null && lon.isValid()) {
            this.longitude = lon.getDoubleValue();
        }
        if (this.latitude == null || this.longitude == null) {
            if (this.toponym == null) {
                this.toponym = this.geonamesResearcher.defaultPlace();
            }
            this.geo_type = this.toponym.getLatitude().compareTo(this.defaultPlace.getLatitude()) == 0 && this.toponym.getLongitude().compareTo(this.defaultPlace.getLongitude()) == 0 ? 0 : 1;
            this.latitude = this.toponym.getLatitude();
            this.longitude = this.toponym.getLongitude();
        } else {
            this.geo_type = 2;
        }
    }

    public boolean areCoordinatesUnknown() {
        return this.geo_type == 0;
    }

    public boolean isMissingLocalInformation() {
        return this.toponym == null || this.toponym.getCountryCode().isEmpty() || this.toponym.getAdminCode(1).isEmpty() || this.toponym.getAdminCode(2).isEmpty();
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public GeoPosition getGeoPosition() {
        return new GeoPosition(this.latitude.doubleValue(), this.longitude.doubleValue());
    }

    public String getTextCoordinates() {
        Double lat = this.getLatitude();
        Double lon = this.getLongitude();
        char we = 'E';
        char ns = 'N';
        if (lat < 0.0) {
            lat = -lat.doubleValue();
            ns = 'S';
        }
        if (lon < 0.0) {
            lon = -lon.doubleValue();
            we = 'W';
        }
        DecimalFormat format = new DecimalFormat("0.0");
        return ns + format.format(lat) + " " + we + format.format(lon);
    }

    public Image getIcon() {
        if (this.isEvent) {
            return this.property.getImage(true).getImage();
        }
        if (this.geo_type == 0) {
            return ImageUtilities.loadImage((String)"ancestris/modules/geo/geo_red.png");
        }
        return ImageUtilities.loadImage((String)"ancestris/modules/geo/geo12.png");
    }

    public String getColor() {
        String color = COLOR_UNKNOWN;
        switch (this.geo_type) {
            case 2: {
                color = COLOR_CONFIRMED;
                break;
            }
            case 1: {
                color = COLOR_PROPOSED;
                break;
            }
            case 0: {
                color = COLOR_UNKNOWN;
            }
        }
        return color;
    }

    public String getNbOfEvents() {
        return "" + this.events.size();
    }

    public String toString() {
        if (this.isEvent) {
            return this.toDisplayString();
        }
        return this.placeKey;
    }

    public String toDisplayString() {
        if (this.isEvent && this.property != null && this.property.getEntity() != null) {
            return this.property.getPropertyName() + " - " + this.property.getEntity().toString();
        }
        return this.placeDisplayFormat;
    }

    public Gedcom getGedcom() {
        return this.propertyPlace != null ? this.propertyPlace.getGedcom() : (this.property != null ? this.property.getGedcom() : null);
    }

    public Property getProperty() {
        return this.property;
    }

    public PropertyPlace getFirstPropertyPlace() {
        return this.propertyPlace;
    }

    public Place getPlace() {
        return this.toponym;
    }

    public String getCity() {
        return this.propertyPlace == null || this.propertyPlace.toString().trim().isEmpty() ? NbBundle.getMessage(GeoListTopComponent.class, (String)"GeoEmpty") : this.propertyPlace.getCity();
    }

    public String getPopulation() {
        return this.getPopulation(this.toponym);
    }

    public String getPopulation(Place topo) {
        if (topo == null) {
            return "0";
        }
        Long pop = topo.getPopulation();
        DecimalFormat format = new DecimalFormat("#,##0");
        return pop != null ? format.format(pop) : "0";
    }

    public GeoNodeObject[] getAllEvents() {
        if (this.events != null) {
            Collections.sort(this.events, GeoListTopComponent.sortEvents);
            return this.events.toArray(new GeoNodeObject[this.events.size()]);
        }
        return null;
    }

    public List<Property> getEventsProperties() {
        ArrayList<Property> ret = new ArrayList<Property>();
        for (GeoNodeObject gno : this.events) {
            ret.add(gno.property);
        }
        return ret;
    }

    public Set<Indi> getFilteredIndisFromEvents(GeoFilter filter) {
        HashSet<Indi> list = new HashSet<Indi>();
        GeoNodeObject[] eventsOfNode = this.getFilteredEvents(filter);
        if (eventsOfNode != null) {
            for (GeoNodeObject eventOfNode : eventsOfNode) {
                list.addAll(this.getFilteredIndisFromProp(eventOfNode.property, filter));
            }
        }
        return list;
    }

    public GeoNodeObject[] getFilteredEvents(GeoFilter filter) {
        ArrayList list = new ArrayList();
        if (this.events != null) {
            this.events.stream().filter(event -> filter.compliesEvent((GeoNodeObject)event)).forEachOrdered(event -> list.add(event));
            Collections.sort(list, GeoListTopComponent.sortEvents);
            return list.toArray(new GeoNodeObject[list.size()]);
        }
        return null;
    }

    public Set<Indi> getFilteredIndisFromProp(Property prop, GeoFilter filter) {
        Entity ent;
        HashSet<Indi> indis = new HashSet<Indi>();
        Entity entity = ent = prop != null ? prop.getEntity() : this.property.getEntity();
        if (ent instanceof Indi) {
            Indi indi = (Indi)ent;
            if (filter == null || filter.compliesIndi(indi)) {
                indis.add(indi);
            }
        } else if (ent instanceof Fam) {
            Indi indi = ((Fam)ent).getHusband();
            if (indi != null && (filter == null || filter.compliesIndi(indi))) {
                indis.add(indi);
            }
            if ((indi = ((Fam)ent).getWife()) != null && (filter == null || filter.compliesIndi(indi))) {
                indis.add(indi);
            }
        }
        return indis;
    }

    public List<PropertyPlace> getEventsPlaces() {
        if (this.events != null) {
            ArrayList<PropertyPlace> propPlaces = new ArrayList<PropertyPlace>();
            this.events.forEach(geoNodeObject -> propPlaces.add(geoNodeObject.getFirstPropertyPlace()));
            return propPlaces;
        }
        return null;
    }

    public void updateAllEventsPlaces(PropertyPlace place) {
        if (place != null) {
            this.gplOwner.setMapCoord(place, this.getEventsPlaces());
            this.gplOwner.launchPlacesSearch(1, false, false, null, null);
        }
    }

    public int getEventsMaxDate() {
        int date = -99999;
        Property dateProp = this.property.getProperty("DATE");
        if (dateProp != null && dateProp instanceof PropertyDate) {
            int year = 0;
            PropertyDate p = (PropertyDate)dateProp;
            try {
                year = p.isRange() ? p.getEnd().getPointInTime((Calendar)PointInTime.GREGORIAN).getYear() : p.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN).getYear();
            }
            catch (GedcomException gedcomException) {
                // empty catch block
            }
            if (date < year) {
                date = year;
            }
        }
        return date;
    }

    public int getEventsMinDate() {
        int date = 99999;
        Property dateProp = this.property.getProperty("DATE");
        if (dateProp != null && dateProp instanceof PropertyDate) {
            int year = 0;
            PropertyDate p = (PropertyDate)dateProp;
            try {
                year = p.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN).getYear();
            }
            catch (GedcomException gedcomException) {
                // empty catch block
            }
            if (date > year) {
                date = year;
            }
        }
        return date;
    }

    public String getEventTag() {
        return this.property.getTag();
    }

    public String[] getEventsInfo(GeoFilter filter) {
        if (filter == null) {
            return null;
        }
        GeoNodeObject[] eventsOfNode = this.getFilteredEvents(filter);
        if (eventsOfNode == null) {
            return null;
        }
        String[] str = new String[]{"nb individus", "patronyme le plus fr\u00e9quent", "nb events", "births", "marriages", "deaths", "other events", "date min", "date max"};
        HashSet<Indi> allIndis = new HashSet<Indi>();
        TreeMap<String, Integer> pat = new TreeMap<String, Integer>();
        int dateMin = 99999;
        int dateMax = -99999;
        int eBirths = 0;
        int eMarriages = 0;
        int eDeaths = 0;
        int eOther = 0;
        for (GeoNodeObject eventOfNode : eventsOfNode) {
            Property prop = eventOfNode.property;
            Entity ent = prop.getEntity();
            String tag = prop.getTag();
            if (filter.isBirth(tag)) {
                ++eBirths;
            } else if (filter.isMarriage(tag)) {
                ++eMarriages;
            } else if (filter.isDeath(tag)) {
                ++eDeaths;
            } else {
                ++eOther;
            }
            Set<Indi> indis = this.getFilteredIndisFromProp(prop, filter);
            for (Indi indi : indis) {
                String patronym = indi.getLastName();
                Integer nb = (Integer)pat.get(patronym);
                if (nb == null) {
                    nb = 0;
                }
                Integer n = nb;
                Integer n2 = nb = Integer.valueOf(nb + 1);
                pat.put(patronym, nb);
                allIndis.add(indi);
            }
            Property dateProp = prop.getProperty("DATE");
            if (dateProp == null || !(dateProp instanceof PropertyDate)) continue;
            int year1 = 0;
            int year2 = 0;
            PropertyDate p = (PropertyDate)dateProp;
            try {
                if (p.isRange()) {
                    year1 = p.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN).getYear();
                    year2 = p.getEnd().getPointInTime((Calendar)PointInTime.GREGORIAN).getYear();
                } else {
                    year2 = year1 = p.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN).getYear();
                }
            }
            catch (GedcomException gedcomException) {
                // empty catch block
            }
            if (dateMin > year1) {
                dateMin = year1;
            }
            if (dateMax >= year2) continue;
            dateMax = year2;
        }
        Iterator it = pat.keySet().iterator();
        Integer max = 0;
        String patMax = "";
        while (it.hasNext()) {
            String key = (String)it.next();
            Integer nb = (Integer)pat.get(key);
            if (nb <= max) continue;
            max = nb;
            patMax = key;
        }
        str[0] = "" + allIndis.size();
        str[1] = "" + patMax + " (" + max + ")";
        str[2] = "" + eventsOfNode.length;
        str[3] = "" + eBirths;
        str[4] = "" + eMarriages;
        str[5] = "" + eDeaths;
        str[6] = "" + eOther;
        str[7] = "" + (dateMin == 99999 ? "-" : Integer.valueOf(dateMin));
        str[8] = "" + (dateMax == -99999 ? "-" : Integer.valueOf(dateMax));
        return str;
    }

    void addEvent(Property parent, PropertyPlace pp) {
        this.events.add(new GeoNodeObject(this.gplOwner, parent, pp));
    }
}

