/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.exports.website;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Html {
    Document doc = null;
    Element body = null;
    Element headNode;
    private static String LINK = "((?i)https{0,1}(?-i):\\/\\/\\S*)";

    public Html(String title, String linkPrefix, String lang) {
        String sPublicId = "-//W3C//DTD XHTML 1.0 Strict//EN";
        String sSystemId = "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd";
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            DOMImplementation domImpl = builder.getDOMImplementation();
            DocumentType doctype = domImpl.createDocumentType("html", sPublicId, sSystemId);
            this.doc = domImpl.createDocument("http://www.w3.org/1999/xhtml", "html", doctype);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.doc.getDocumentElement().setAttribute("xmlns", "http://www.w3.org/1999/xhtml");
        this.doc.getDocumentElement().setAttribute("lang", lang);
        this.doc.getDocumentElement().setAttribute("xml:lang", lang);
        this.headNode = this.doc.createElement("head");
        Element titleNode = this.doc.createElement("title");
        titleNode.appendChild(this.doc.createTextNode(title));
        this.body = this.doc.createElement("body");
        this.doc.getDocumentElement().appendChild(this.headNode);
        this.headNode.appendChild(titleNode);
        this.doc.getDocumentElement().appendChild(this.body);
        Element cssLink = this.doc.createElement("link");
        cssLink.setAttribute("href", linkPrefix + "style.css");
        cssLink.setAttribute("rel", "stylesheet");
        cssLink.setAttribute("type", "text/css");
        this.headNode.appendChild(cssLink);
        Element meta = this.doc.createElement("meta");
        meta.setAttribute("http-equiv", "Content-Type");
        meta.setAttribute("content", "text/html; charset=utf-8");
        this.headNode.appendChild(meta);
    }

    public void addJSFile(String url) {
        Element script = this.doc.createElement("script");
        script.setAttribute("type", "text/javascript");
        script.setAttribute("src", url);
        script.appendChild(this.text(" "));
        this.headNode.appendChild(script);
    }

    public void setDescription(String description) {
        Element meta = this.doc.createElement("meta");
        meta.setAttribute("name", "description");
        meta.setAttribute("content", description);
        this.headNode.appendChild(meta);
    }

    public Document getDoc() {
        return this.doc;
    }

    public Element getBody() {
        return this.body;
    }

    public Element form(String id, String action, String onsubmit) {
        Element form = this.doc.createElement("form");
        if (id != null) {
            form.setAttribute("id", id);
        }
        if (action != null) {
            form.setAttribute("action", action);
        }
        if (onsubmit != null) {
            form.setAttribute("onsubmit", onsubmit);
        }
        return form;
    }

    public Element input(String id, String name) {
        Element input = this.doc.createElement("input");
        input.setAttribute("id", id);
        input.setAttribute("name", name);
        return input;
    }

    public Element input(String id, String name, int size) {
        Element input = this.input(id, name);
        input.setAttribute("size", Integer.toString(size));
        return input;
    }

    public Element input(String id, String name, String type) {
        Element input = this.input(id, id);
        input.setAttribute("type", type);
        input.appendChild(this.doc.createTextNode(name));
        return input;
    }

    public Element button(String value, String onclick) {
        Element input = this.doc.createElement("input");
        input.setAttribute("type", "button");
        input.setAttribute("value", value);
        input.setAttribute("onclick", onclick);
        return input;
    }

    public Element anchor(String anchor) {
        Element link = this.doc.createElement("a");
        link.setAttribute("name", anchor);
        return link;
    }

    public Element link(String href, String text) {
        return this.link(href, this.doc.createTextNode(text));
    }

    public Element link(String href, Node linkNode) {
        Element link = this.doc.createElement("a");
        link.setAttribute("href", href);
        link.appendChild(linkNode);
        return link;
    }

    public Element img(String src, String desc) {
        Element img = this.doc.createElement("img");
        img.setAttribute("src", src);
        img.setAttribute("alt", desc);
        img.setAttribute("title", desc);
        return img;
    }

    public Element span(String className) {
        Element span = this.tag("span");
        span.setAttribute("class", className);
        return span;
    }

    public Element span(String className, String text) {
        Element span = this.span(className);
        span.appendChild(this.text(text));
        return span;
    }

    public Element spanNewlines(String className, String text) {
        Element span = this.span(className);
        this.handleNewlines(span, text);
        return span;
    }

    public void handleNewlines(Element appendTo, String text) {
        String[] lines;
        for (String line : lines = text.split("\r\n|\r|\n")) {
            appendTo.appendChild(this.text(line));
            appendTo.appendChild(this.br());
        }
    }

    public Element divId(String id) {
        Element div = this.tag("div");
        div.setAttribute("id", id);
        return div;
    }

    public Element div(String className) {
        Element div = this.tag("div");
        div.setAttribute("class", className);
        return div;
    }

    public Element div(String className, String content) {
        Element div = this.tag("div");
        div.setAttribute("class", className);
        div.appendChild(this.text(content));
        return div;
    }

    public Element sup(String className) {
        Element sup = this.tag("sup");
        sup.setAttribute("class", className);
        return sup;
    }

    public Element br() {
        return this.tag("br");
    }

    public Element p() {
        return this.tag("p");
    }

    public Element p(String text) {
        return this.tag("p", text);
    }

    public Element pNewlines(String text) {
        Element p = this.tag("p");
        this.handleNewlines(p, text);
        return p;
    }

    public Element p(Node node) {
        return this.tag("p", node);
    }

    public Element h1(String text) {
        return this.tag("h1", text);
    }

    public Element h2(String text) {
        return this.tag("h2", text);
    }

    public Element h2(String imageUrl, String text) {
        Element h2 = this.tag("h2", this.img(imageUrl, ""));
        h2.appendChild(this.text(" " + text));
        return h2;
    }

    public Element li(String text) {
        return this.tag("li", text);
    }

    public Element ul() {
        return this.tag("ul");
    }

    public Element ul(String text) {
        Element ul = this.tag("ul");
        ul.setAttribute("style", text);
        return ul;
    }

    public Node text(String text) {
        if (text.toLowerCase().contains("http")) {
            return this.processLinksInText(text);
        }
        return this.doc.createTextNode(text);
    }

    private Node processLinksInText(String text) {
        Element e = this.tag("span");
        Pattern p = Pattern.compile(LINK);
        Matcher m = p.matcher(text);
        int start = 0;
        while (m.find()) {
            String bit = m.group();
            String txt = text.substring(start, m.start());
            if (!txt.isEmpty()) {
                e.appendChild(this.doc.createTextNode(txt));
            }
            if (!bit.isEmpty()) {
                e.appendChild(this.link(bit, bit));
            }
            start = m.end();
        }
        return e;
    }

    private Element tag(String tagname) {
        return this.doc.createElement(tagname);
    }

    private Element tag(String tagname, Node node) {
        Element tag = this.tag(tagname);
        tag.appendChild(node);
        return tag;
    }

    private Element tag(String tagname, String text) {
        return this.tag(tagname, this.doc.createTextNode(text));
    }

    public void toFile(File file, boolean omitXmlDeclaration) {
        DOMSource source = null;
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("doctype-public", "-//W3C//DTD XHTML 1.0 Strict//EN");
            transformer.setOutputProperty("doctype-system", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd");
            if (omitXmlDeclaration) {
                transformer.setOutputProperty("omit-xml-declaration", "yes");
            }
            StreamResult result = new StreamResult(file);
            source = new DOMSource(this.doc);
            this.deleteNullNode(file, this.doc);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteNullNode(File file, Node root) {
        NodeList nl = root.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeType() == 3 && (nl.item(i).getNodeValue() == null || nl.item(i).getNodeValue().isEmpty())) {
                Node parent = nl.item(i).getParentNode();
                parent.removeChild(nl.item(i));
                continue;
            }
            this.deleteNullNode(file, nl.item(i));
        }
    }
}

