/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcomcompare.tools;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.CubicCurve2D;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;

public class GraphicDesktopPane
extends JDesktopPane {
    private static final Stroke s = new BasicStroke(2.0f);
    private CubicCurve2D cubcurve;
    private List<Link> listOfLinks = new LinkedList<Link>();

    public void addLink(JInternalFrame f1, JInternalFrame f2) {
        boolean found = false;
        for (Link link : this.listOfLinks) {
            if ((link.f1 != f1 || link.f2 != f2) && (link.f1 != f2 || link.f2 != f1)) continue;
            found = true;
        }
        if (!found) {
            this.listOfLinks.add(new Link(f1, f2));
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(Color.LIGHT_GRAY);
        g2d.setStroke(s);
        Link[] array = this.listOfLinks.toArray(new Link[this.listOfLinks.size()]);
        for (int i = 0; i < array.length; ++i) {
            Link link = array[i];
            if (link.f1.isIcon() || link.f2.isIcon()) continue;
            int x1 = link.f1.getX() + link.f1.getWidth() * 4 / 5;
            int y1 = link.f1.getY() + link.f1.getHeight() / 2;
            int x2 = link.f2.getX() + link.f2.getWidth() * 1 / 5;
            int y2 = link.f2.getY() + link.f2.getHeight() / 2;
            this.cubcurve = new CubicCurve2D.Float(x1, y1, x1 + link.f1.getWidth() * 1 / 5, y1 + 10, x2 - link.f2.getWidth() * 1 / 5, y2 + 10, x2, y2);
            g2d.draw(this.cubcurve);
        }
    }

    public void removeLink(JInternalFrame f) {
        LinkedList<Link> linksToRemove = new LinkedList<Link>();
        for (Link link : this.listOfLinks) {
            if (link.f1 != f && link.f2 != f) continue;
            linksToRemove.add(link);
        }
        this.listOfLinks.removeAll(linksToRemove);
    }

    private class Link {
        public JInternalFrame f1;
        public JInternalFrame f2;

        private Link(JInternalFrame f1, JInternalFrame f2) {
            this.f1 = f1;
            this.f2 = f2;
        }
    }
}

