/*
 * Decompiled with CFR 0.152.
 */
package gj.layout.tree;

import gj.awt.geom.Geometry;
import gj.awt.geom.Path;
import gj.layout.tree.ArcOptions;
import gj.layout.tree.Branch;
import gj.layout.tree.Contour;
import gj.layout.tree.NodeOptions;
import gj.layout.tree.Orientation;
import gj.layout.tree.Tree;
import gj.model.Arc;
import gj.model.Node;
import gj.util.ArcHelper;
import gj.util.ArcIterator;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;

class Algorithm {
    private Orientation orientn;
    private NodeOptions nodeop;
    private ArcOptions arcop;
    private double latalign;
    private boolean balance;
    private boolean bendarcs;

    Algorithm(Orientation orientation, NodeOptions nodeOptions, ArcOptions arcOptions, double latAlignment, boolean isBalanceChildrenEnable, boolean isBendedArcs) {
        this.orientn = orientation;
        this.nodeop = nodeOptions;
        this.arcop = arcOptions;
        this.latalign = latAlignment;
        this.balance = isBalanceChildrenEnable;
        this.bendarcs = isBendedArcs;
    }

    Rectangle layout(Tree tree, Collection debugShapes) {
        Node root = tree.getRoot();
        int rootLat = this.orientn.getLatitude(root.getPosition());
        int rootLon = this.orientn.getLongitude(root.getPosition());
        Branch branch = this.layout(root, null, tree, 0);
        int dlat = rootLat - this.orientn.getLatitude(root.getPosition());
        int dlon = rootLon - this.orientn.getLongitude(root.getPosition());
        Contour result = branch.finalize(dlat, dlon, this.orientn);
        if (debugShapes != null) {
            debugShapes.add(new DebugShape(this, result));
        }
        return this.orientn.getBounds(result);
    }

    private Branch layout(Node node, Node parent, Tree tree, int generation) {
        Branch[] children = this.calcChildren(node, parent, tree, generation);
        Contour contour = this.calcParentPosition(node, children, tree, generation);
        this.calcArcs(node, contour);
        contour = Contour.merge(Branch.getCountoursForMerge(contour, children));
        return new Branch(node, parent, contour);
    }

    private Branch[] calcChildren(Node root, Node parent, Tree tree, int generation) {
        ArrayList children = new ArrayList(root.getArcs().size());
        ArcIterator it = new ArcIterator(root);
        while (it.next()) {
            if (!it.isFirst || it.isLoop || it.dest == parent) continue;
            this.layout(it.dest, root, tree, generation + 1).insertEastOf(children, this.orientn);
        }
        Branch[] result = (Branch[])children.toArray((Object[])new Branch[children.size()]);
        return result;
    }

    private Contour calcParentPosition(Node root, Branch[] children, Tree tree, int generation) {
        Shape shape = root.getShape();
        Contour result = this.orientn.getContour(shape != null ? shape.getBounds2D() : new Rectangle2D.Double());
        result.pad(this.nodeop.getPadding(root, this.orientn));
        int lat = 0;
        int lon = 0;
        if (children.length > 0) {
            lon = this.nodeop.getLongitude(root, children, this.orientn);
            lat = children[0].getLatitude() - result.south;
        }
        if (this.latalign >= 0.0 && this.latalign <= 1.0) {
            lat = tree.getLatitude(generation);
            int min = lat - result.north;
            int max = lat + tree.getHeight(generation) - result.south;
            lat = (int)((double)min + (double)(max - min) * Math.min(1.0, Math.max(0.0, this.latalign)));
        }
        root.getPosition().setLocation(this.orientn.getPoint(lat, lon));
        result.translate(lat, lon);
        if (this.latalign >= 0.0 && this.latalign <= 1.0) {
            result.north = tree.getLatitude(generation);
        }
        return result;
    }

    private void calcArcs(Node node, Contour parent) {
        ArcIterator it = new ArcIterator(node);
        while (it.next()) {
            if (it.arc.getPath() == null) continue;
            if (it.isLoop) {
                ArcHelper.update(it.arc);
                continue;
            }
            if (this.bendarcs) {
                this.calcBendedArc(it.arc, parent);
                continue;
            }
            this.calcStraightArc(it.arc);
        }
    }

    private void calcStraightArc(Arc arc) {
        Node n1 = arc.getStart();
        Node n2 = arc.getEnd();
        Point2D p1 = this.arcop.getPort(arc, n1, this.orientn);
        Point2D p2 = this.arcop.getPort(arc, n2, this.orientn);
        Shape s1 = n1.getShape();
        Shape s2 = n2.getShape();
        p1 = Geometry.getIntersection(p1, (Point2D)this.orientn.getPoint(this.orientn.getLatitude(p2), this.orientn.getLongitude(p1)), p1, s1);
        p2 = Geometry.getIntersection(p2, (Point2D)this.orientn.getPoint(this.orientn.getLatitude(p1), this.orientn.getLongitude(p2)), p2, s2);
        Path path = arc.getPath();
        path.reset();
        path.moveTo(p1);
        path.lineTo(p2);
    }

    private void calcBendedArc(Arc arc, Contour parent) {
        Node n1 = arc.getStart();
        Node n2 = arc.getEnd();
        Point2D p1 = this.arcop.getPort(arc, n1, this.orientn);
        Point2D.Double p2 = new Point2D.Double();
        Point2D.Double p3 = new Point2D.Double();
        Point2D p4 = this.arcop.getPort(arc, n2, this.orientn);
        p2.setLocation(this.orientn.getPoint(parent.south, this.orientn.getLongitude(p1)));
        p3.setLocation(this.orientn.getPoint(parent.south, this.orientn.getLongitude(p4)));
        ArcHelper.update(arc.getPath(), new Point2D[]{p1, p2, p3, p4}, n1.getShape(), n2.getShape());
    }

    private class DebugShape
    extends Path {
        private final Algorithm algo;

        private DebugShape(Algorithm this$0, Contour contour) {
            this.algo = this$0;
            Contour.Iterator it = contour.getIterator(0);
            Point a = Algorithm.this.orientn.getPoint(it.north, it.longitude);
            this.moveTo(a);
            do {
                this.lineTo(Algorithm.this.orientn.getPoint(it.north, it.longitude));
                this.lineTo(Algorithm.this.orientn.getPoint(it.south, it.longitude));
            } while (it.next());
            Point2D b = this.getLastPoint();
            this.moveTo(a);
            it = contour.getIterator(1);
            do {
                this.lineTo(Algorithm.this.orientn.getPoint(it.north, it.longitude));
                this.lineTo(Algorithm.this.orientn.getPoint(it.south, it.longitude));
            } while (it.next());
            this.lineTo(b);
        }
    }
}

