/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.views.graph;

import genj.gedcom.Property;
import java.awt.Color;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.apache.fop.afp.util.StringUtils;

public class DisplayPathElement {
    private static final Logger LOG = Logger.getLogger("ancestris.app", null);
    private static final SimpleAttributeSet PLAIN = new SimpleAttributeSet();
    private static final SimpleAttributeSet BOLD = new SimpleAttributeSet();
    private static final Color[] FG_COLORS = new Color[2];
    private Property property;
    private ImageIcon img;
    private StyledDocument doc;
    private int entity;

    public DisplayPathElement(Property setProp, int setEntity) {
        this.property = setProp;
        this.img = this.property.getImage(false);
        this.entity = setEntity;
        this.doc = new DefaultStyledDocument();
        Color c = FG_COLORS[setEntity & 1];
        StyleConstants.setForeground(PLAIN, c);
        StyleConstants.setForeground(BOLD, c);
        try {
            int offset = 0;
            this.doc.insertString(offset++, " ", PLAIN);
            String value = setProp.getDisplayTitle();
            this.doc.insertString(offset, value, PLAIN);
            offset += value.length();
            SimpleAttributeSet localImg = new SimpleAttributeSet();
            StyleConstants.setIcon(localImg, (Icon)setProp.getImage(false));
            this.doc.insertString(0, " ", localImg);
            String id = "[" + setProp.getEntity().getId() + "] ";
            id = StringUtils.rpad((String)id, (char)' ', (int)10);
            this.doc.insertString(0, id, PLAIN);
        }
        catch (BadLocationException e) {
            LOG.log(Level.INFO, "Error during hit creation", e);
        }
    }

    public StyledDocument getDocument() {
        return this.doc;
    }

    public Property getProperty() {
        return this.property;
    }

    public ImageIcon getImage() {
        return this.img;
    }

    public int getEntity() {
        return this.entity;
    }

    public String toString() {
        return this.doc.toString();
    }

    static {
        StyleConstants.setBold(BOLD, true);
        DisplayPathElement.FG_COLORS[0] = Color.BLACK;
        DisplayPathElement.FG_COLORS[1] = new Color(0, 51, 241);
    }
}

