/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.views.graph;

import ancestris.modules.views.graph.GraphTopComponent;
import ancestris.modules.views.graph.ModifEntity;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomListenerAdapter;
import genj.gedcom.Property;

public class GrapheGedcomListenerAdapter
extends GedcomListenerAdapter {
    private final ModifEntity entities = new ModifEntity();
    private final GraphTopComponent graph;

    public GrapheGedcomListenerAdapter(GraphTopComponent graphe) {
        this.graph = graphe;
    }

    public void gedcomWriteLockAcquired(Gedcom gedcom) {
        this.entities.clear();
    }

    public void gedcomWriteLockReleased(Gedcom gedcom) {
        this.graph.changeDisplay(this.entities);
    }

    public void gedcomEntityAdded(Gedcom gedcom, Entity entity) {
        if (this.checkGedcom(gedcom)) {
            this.entities.addEntity(entity);
        }
    }

    public void gedcomEntityDeleted(Gedcom gedcom, Entity entity) {
        if (this.checkGedcom(gedcom)) {
            this.entities.deleteEntity(entity);
        }
    }

    public void gedcomPropertyChanged(Gedcom gedcom, Property property) {
        Entity entity;
        if (this.checkGedcom(gedcom) && (entity = property.getEntity()) != null) {
            this.entities.modifyEntity(entity);
        }
    }

    public void gedcomPropertyAdded(Gedcom gedcom, Property property, int pos, Property added) {
        Entity entity;
        if (this.checkGedcom(gedcom) && (entity = property.getEntity()) != null) {
            this.entities.modifyEntity(entity);
        }
    }

    public void gedcomPropertyDeleted(Gedcom gedcom, Property property, int pos, Property removed) {
        Entity entity;
        if (this.checkGedcom(gedcom) && (entity = property.getEntity()) != null) {
            this.entities.modifyEntity(entity);
        }
    }

    private boolean checkGedcom(Gedcom gedcom) {
        Gedcom graphGedcom = this.graph.getGedcom();
        return graphGedcom != null && graphGedcom.equals(gedcom);
    }
}

