/*
 * Decompiled with CFR 0.152.
 */
package ancestris.api.imports;

import ancestris.api.imports.ImportFactory;
import ancestris.api.imports.ImportFix;
import ancestris.api.imports.ImportPanel;
import ancestris.api.imports.ImportRunner;
import ancestris.core.TextOptions;
import ancestris.gedcom.GedcomDirectory;
import ancestris.gedcom.GedcomMgr;
import ancestris.modules.console.Console;
import ancestris.util.ProgressListener;
import ancestris.util.Utilities;
import ancestris.util.swing.DialogManager;
import ancestris.util.swing.FileChooserBuilder;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomConstants;
import genj.gedcom.GedcomException;
import genj.gedcom.GedcomOptions;
import genj.gedcom.Grammar;
import genj.gedcom.Indi;
import genj.gedcom.Media;
import genj.gedcom.MetaProperty;
import genj.gedcom.Property;
import genj.gedcom.PropertyAssociation;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyEvent;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyMedia;
import genj.gedcom.PropertyMultilineValue;
import genj.gedcom.PropertyName;
import genj.gedcom.PropertyNote;
import genj.gedcom.PropertyPlace;
import genj.gedcom.PropertyRelationship;
import genj.gedcom.PropertyRepository;
import genj.gedcom.PropertySource;
import genj.gedcom.PropertyXRef;
import genj.gedcom.Source;
import genj.gedcom.TagPath;
import genj.io.GedcomFileReader;
import genj.io.GedcomFileWriter;
import genj.io.GedcomFormatException;
import genj.io.InputSource;
import genj.util.Origin;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import org.apache.commons.lang.StringUtils;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import spin.Spin;

public abstract class Import
implements ImportRunner {
    public static final Logger LOG = Logger.getLogger("ancestris.app", null);
    protected static String EOL = System.getProperty("line.separator");
    protected static final String INDI_TAG_YES = "BIRT|CHR|DEAT|BURI|CREM|ADOP|BAPM|BARM|BASM|BLES|CHRA|CONF|FCOM|ORDN|NATU|EMIG|IMMI|CENS|PROB|WILL|GRAD|RETI|";
    protected static final String FAM_TAG_YES = "ANUL|CENS|DIV|DIVF|ENGA|MARR|MARB|MARC|MARL|MARS";
    protected static Pattern tag_y = Pattern.compile("(BIRT|CHR|DEAT|BURI|CREM|ADOP|BAPM|BARM|BASM|BLES|CHRA|CONF|FCOM|ORDN|NATU|EMIG|IMMI|CENS|PROB|WILL|GRAD|RETI|ANUL|CENS|DIV|DIVF|ENGA|MARR|MARB|MARC|MARL|MARS)");
    protected static final String GEDCOM55_TAG = "ABBR|ADDR|ADR1|ADR2|ADOP|AFN|AGE|AGNC|ALIA|ANCE|ANCI|ANUL|ASSO|AUTH|BAPL|BAPM|BARM|BASM|BIRT|BLES|BLOB|BURI|CALN|CAST|CAUS|CENS|CHAN|CHAR|CHIL|CHR|CHRA|CITY|CONC|CONF|CONL|CONT|COPR|CORP|CREM|CTRY|DATA|DATE|DEAT|DESC|DESI|DEST|DIV|DIVF|DSCR|EDUC|EMIG|ENDL|ENGA|EVEN|FAM|FAMC|FAMF|FAMS|FCOM|FILE|FORM|GEDC|GIVN|GRAD|HEAD|HUSB|IDNO|IMMI|INDI|LANG|LEGA|MARB|MARC|MARL|MARR|MARS|MEDI|NAME|NATI|NATU|NCHI|NICK|NMR|NOTE|NPFX|NSFX|OBJE|OCCU|ORDI|ORDN|PAGE|PEDI|PHON|PLAC|POST|PROB|PROP|PUBL|QUAY|REFN|RELA|RELI|REPO|RESI|RESN|RETI|RFN|RIN|ROLE|SEX|SLGC|SLGS|SOUR|SPFX|SSN|STAE|STAT|SUBM|SUBN|SURN|TEMP|TEXT|TIME|TITL|TRLR|TYPE|VERS|WIFE|WILL";
    protected static final String GEDCOM551_TAG = "|EMAIL|FAX|FACT|FONE|ROMN|WWW|MAP|LATI|LONG|ADR3|";
    protected static Pattern tag55_valid = Pattern.compile("(ABBR|ADDR|ADR1|ADR2|ADOP|AFN|AGE|AGNC|ALIA|ANCE|ANCI|ANUL|ASSO|AUTH|BAPL|BAPM|BARM|BASM|BIRT|BLES|BLOB|BURI|CALN|CAST|CAUS|CENS|CHAN|CHAR|CHIL|CHR|CHRA|CITY|CONC|CONF|CONL|CONT|COPR|CORP|CREM|CTRY|DATA|DATE|DEAT|DESC|DESI|DEST|DIV|DIVF|DSCR|EDUC|EMIG|ENDL|ENGA|EVEN|FAM|FAMC|FAMF|FAMS|FCOM|FILE|FORM|GEDC|GIVN|GRAD|HEAD|HUSB|IDNO|IMMI|INDI|LANG|LEGA|MARB|MARC|MARL|MARR|MARS|MEDI|NAME|NATI|NATU|NCHI|NICK|NMR|NOTE|NPFX|NSFX|OBJE|OCCU|ORDI|ORDN|PAGE|PEDI|PHON|PLAC|POST|PROB|PROP|PUBL|QUAY|REFN|RELA|RELI|REPO|RESI|RESN|RETI|RFN|RIN|ROLE|SEX|SLGC|SLGS|SOUR|SPFX|SSN|STAE|STAT|SUBM|SUBN|SURN|TEMP|TEXT|TIME|TITL|TRLR|TYPE|VERS|WIFE|WILL)");
    protected static Pattern tag551_valid = Pattern.compile("(ABBR|ADDR|ADR1|ADR2|ADOP|AFN|AGE|AGNC|ALIA|ANCE|ANCI|ANUL|ASSO|AUTH|BAPL|BAPM|BARM|BASM|BIRT|BLES|BLOB|BURI|CALN|CAST|CAUS|CENS|CHAN|CHAR|CHIL|CHR|CHRA|CITY|CONC|CONF|CONL|CONT|COPR|CORP|CREM|CTRY|DATA|DATE|DEAT|DESC|DESI|DEST|DIV|DIVF|DSCR|EDUC|EMIG|ENDL|ENGA|EVEN|FAM|FAMC|FAMF|FAMS|FCOM|FILE|FORM|GEDC|GIVN|GRAD|HEAD|HUSB|IDNO|IMMI|INDI|LANG|LEGA|MARB|MARC|MARL|MARR|MARS|MEDI|NAME|NATI|NATU|NCHI|NICK|NMR|NOTE|NPFX|NSFX|OBJE|OCCU|ORDI|ORDN|PAGE|PEDI|PHON|PLAC|POST|PROB|PROP|PUBL|QUAY|REFN|RELA|RELI|REPO|RESI|RESN|RETI|RFN|RIN|ROLE|SEX|SLGC|SLGS|SOUR|SPFX|SSN|STAE|STAT|SUBM|SUBN|SURN|TEMP|TEXT|TIME|TITL|TRLR|TYPE|VERS|WIFE|WILL|EMAIL|FAX|FACT|FONE|ROMN|WWW|MAP|LATI|LONG|ADR3|)");
    protected static final String typerepo = "REPO";
    protected int parentLevel = 0;
    protected String parentLevelTag = "";
    protected static final Pattern ALLOW_CONT_TAGS = Pattern.compile("(NOTE|TEXT|AUTH|TITL|PUBL|DSCR|SOUR)");
    protected int levelBeingRepaired = 100;
    private boolean revertAsso = false;
    private boolean headerzone = false;
    private boolean grammarZone = false;
    private boolean noteFound = false;
    private boolean headNoteWritten = false;
    public String GEDCOM_VERSION = "5.5.1";
    private String software_name = "";
    private String software_vers = "";
    private static final int TAG_MISSING = 0;
    private static final int TAG_INVALID = 1;
    private static final int TAG_VALID = 2;
    private int destination_found = 0;
    private static final int PLACE_MAX_LENGTH = 20;
    private int place_found = 0;
    private int char_found = 1;
    private final Integer[] place_format_sizes = new Integer[20];
    private static HashMap<String, ImportEnt> hashIndis;
    private static HashMap<String, ImportEnt> hashFams;
    private static HashMap<String, ImportEnt> hashNotes;
    private static HashMap<String, ImportEnt> hashObjes;
    private static HashMap<String, ImportEnt> hashSours;
    private static HashMap<String, ImportEnt> hashRepos;
    private static HashMap<String, ImportEnt> hashSubms;
    private static HashMap<String, ImportEnt> hashAssos;
    private String tabName = "";
    public GedcomFileReader input;
    public GedcomFileWriter output;
    protected Console console;
    public int nbChanges = 0;
    public HashMap<String, String> summary = new HashMap();
    public String currentXref = "";
    public String previousXref = "";
    public TagPath currentPath = null;
    public TagPath previousPath = null;
    public List<ImportFix> fixes = new ArrayList<ImportFix>();
    private boolean cancelProcess = false;
    private static final int READLINES = 0;
    private static final int CONVERTLINES = 1;
    private static final int CONVERTGEDCOM = 2;
    private int nbOfFileLines = 0;
    private int state = 0;
    private int progress;
    private boolean cancel = false;
    public Set<String> invalidPaths;
    protected static final Pattern SPANISH_MONTHS_PATTERN;

    public abstract String toString();

    public abstract boolean isGeneric();

    protected abstract String getImportComment();

    public void launch(File inputFile, File outputFile) {
        this.cancel = false;
        this.cancelProcess = false;
        this.fixes.clear();
        final Boolean previousUppercaseFlag = GedcomOptions.getInstance().isUpperCaseNames();
        GedcomOptions.getInstance().setUpperCaseNames(false);
        ImportPanel importPanel = new ImportPanel(new Callable(){

            public Object call() throws Exception {
                Import.this.cancelProcess();
                GedcomOptions.getInstance().setUpperCaseNames(previousUppercaseFlag);
                return null;
            }
        });
        String title = NbBundle.getMessage(Import.class, (String)"Import.progress.importing", (Object)inputFile.getName());
        DialogManager dialog = DialogManager.create(title, importPanel, false).setMessageType(-1).setOptions(new Object[0]).setResizable(false);
        dialog.show();
        ImportRunner importTask = (ImportRunner)Spin.off((Object)ImportFactory.createImport(this));
        ProgressListener.Dispatcher.processStarted(importTask);
        boolean taskOk = importTask.run(inputFile, outputFile);
        ProgressListener.Dispatcher.processStopped(importTask);
        if (this.cancelProcess || !taskOk) {
            dialog.cancel();
            GedcomOptions.getInstance().setUpperCaseNames(previousUppercaseFlag);
            return;
        }
        importPanel.increment();
        GedcomMgr.getDefault().setQuiet(true);
        Context context = GedcomDirectory.getDefault().openAncestrisGedcom(FileUtil.toFileObject((File)outputFile));
        GedcomMgr.getDefault().setQuiet(false);
        if (this.cancelProcess || context == null) {
            this.closeProcess(dialog, previousUppercaseFlag);
            return;
        }
        importPanel.increment();
        Gedcom importedGedcom = context.getGedcom();
        importedGedcom.setName(inputFile.getName());
        ProgressListener.Dispatcher.processStarted(importTask);
        PropertyFile.suspendExistenceCheck = true;
        importTask.fixGedcom(importedGedcom);
        PropertyFile.suspendExistenceCheck = false;
        importTask.complete();
        ProgressListener.Dispatcher.processStopped(importTask);
        importPanel.increment();
        if (this.cancelProcess) {
            this.closeProcess(dialog, previousUppercaseFlag);
            return;
        }
        Origin o = GedcomMgr.getDefault().saveGedcomAs(context, null, FileUtil.toFileObject((File)outputFile));
        GedcomDirectory.getDefault().closeGedcom(context);
        if (this.cancelProcess || o == null) {
            this.closeProcess(dialog, previousUppercaseFlag);
            return;
        }
        importPanel.increment();
        Context newContext = GedcomDirectory.getDefault().openAncestrisGedcom(FileUtil.toFileObject((File)o.getFile()));
        if (this.cancelProcess) {
            this.closeProcess(dialog, previousUppercaseFlag);
            return;
        }
        importPanel.requestFocusInWindow();
        importPanel.increment();
        this.closeProcess(dialog, previousUppercaseFlag);
        JButton buttonFull = new JButton(NbBundle.getMessage(Import.class, (String)"mode.displayFullList"));
        JButton buttonExtract = new JButton(NbBundle.getMessage(Import.class, (String)"mode.displayExtractOnly"));
        Object[] buttons = new Object[]{buttonFull, buttonExtract, DialogManager.NO_OPTION};
        int nbI = newContext.getGedcom().getEntities("INDI").size();
        int nbF = newContext.getGedcom().getEntities("FAM").size();
        int nbN = newContext.getGedcom().getEntities("NOTE").size();
        int nbO = newContext.getGedcom().getEntities("OBJE").size();
        int nbS = newContext.getGedcom().getEntities("SOUR").size();
        int nbR = newContext.getGedcom().getEntities(typerepo).size();
        int nbSu = newContext.getGedcom().getEntities("SUBM").size();
        Object rc = DialogManager.create(NbBundle.getMessage(Import.class, (String)"Import.completed"), NbBundle.getMessage(Import.class, (String)"cc.importResults?", (Object)inputFile.getName(), (Object)this.software_name, (Object)nbI, (Object)nbF, (Object[])new Object[]{nbN, nbO, nbS, nbR, nbSu, this.fixes.size()})).setMessageType(1).setOptions(buttons).show();
        if (rc != DialogManager.NO_OPTION) {
            this.summary.put("a.software", this.software_name + (this.software_vers.isEmpty() ? "" : " - " + this.software_vers));
            this.summary.put("b.gedcomversion", this.GEDCOM_VERSION);
            this.summary.put("c.oldgedcom", inputFile.getName());
            this.summary.put("e.newgedcom", outputFile.getName());
            this.summary.put("f.newnumlines", "" + newContext.getGedcom().getLines());
            this.summary.put("g.nbindis", "" + nbI);
            this.summary.put("h.nbfams", "" + nbF);
            this.summary.put("i.nbnotes", "" + nbN);
            this.summary.put("j.nbobjes", "" + nbO);
            this.summary.put("k.nbsources", "" + nbS);
            this.summary.put("l.nbrepos", "" + nbR);
            this.summary.put("m.nbsubms", "" + nbSu);
            this.summary.put("n.nbfixes", "" + this.fixes.size());
            importTask.showDetails(newContext, rc == buttonExtract);
        }
    }

    public void closeProcess(DialogManager dialog, boolean flag) {
        dialog.cancel();
        GedcomOptions.getInstance().setUpperCaseNames(flag);
    }

    public void cancelProcess() {
        ProgressListener.Dispatcher.processStopAll();
        this.cancelProcess = true;
    }

    @Override
    public void cancelTrackable() {
        this.cancel = true;
    }

    @Override
    public int getProgress() {
        switch (this.state) {
            case 0: 
            case 1: {
                if (this.nbOfFileLines == 0 || this.input == null) {
                    return 1;
                }
                this.progress = (this.state * 50 * this.nbOfFileLines + this.input.getLines()) / this.nbOfFileLines;
                return this.progress;
            }
            case 2: {
                return this.progress;
            }
        }
        return 1;
    }

    @Override
    public String getState() {
        switch (this.state) {
            case 0: {
                return NbBundle.getMessage(Import.class, (String)"Import.progress.readlines", (Object)this.tabName);
            }
            case 1: {
                return NbBundle.getMessage(Import.class, (String)"Import.progress.convertlines", (Object)this.tabName);
            }
        }
        return NbBundle.getMessage(Import.class, (String)"Import.progress.convertgedcom", (Object)this.tabName);
    }

    @Override
    public String getTaskName() {
        return NbBundle.getMessage(Import.class, (String)"Import.progress.importing", (Object)this.tabName);
    }

    public void incrementProgress() {
        this.progress += 5;
        if (this.progress > 100) {
            this.progress = 95;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean run(File fileIn, File fileOut) {
        String l;
        this.tabName = fileIn.getName();
        this.init();
        this.state = 0;
        try {
            FileReader in = new FileReader(fileIn);
            LineNumberReader count = new LineNumberReader(in);
            while (count.skip(Long.MAX_VALUE) > 0L) {
            }
            this.nbOfFileLines = (count.getLineNumber() + 1) / 50;
            this.summary.put("d.oldnumlines", "" + count.getLineNumber());
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, "Error during File Reading.", ex);
        }
        try {
            this.input = GedcomFileReader.create(fileIn);
            try {
                while (!this.cancel && this.input.getRawLine() != null) {
                    this.firstPass();
                }
            }
            finally {
                if (this.input != null) {
                    this.input.close();
                }
            }
        }
        catch (FileNotFoundException e1) {
            JOptionPane.showMessageDialog(null, NbBundle.getMessage(Import.class, (String)"file.not.found", (Object)fileIn.getName()));
            return false;
        }
        catch (GedcomFormatException e) {
            l = "" + e.getLine();
            JOptionPane.showMessageDialog(null, e.getMessage() + "\n" + NbBundle.getMessage(Import.class, (String)"error.line", (Object)l));
            return false;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, NbBundle.getMessage(Import.class, (String)"error.other", (Object)e.getMessage()));
            LOG.log(Level.INFO, "Error during new file creation.", e);
            return false;
        }
        ++this.state;
        try {
            this.output = new GedcomFileWriter(fileOut, this.input.getCharset(), this.getEOL(fileIn));
        }
        catch (IOException e1) {
            JOptionPane.showMessageDialog(null, NbBundle.getMessage(Import.class, (String)"file.create.error", (Object)fileOut.getName()));
            LOG.log(Level.INFO, "Error during new file creation.", e1);
            return false;
        }
        try {
            this.input = GedcomFileReader.create(fileIn);
            this.currentXref = "";
            this.currentPath = null;
            boolean EOFfound = false;
            try {
                while (!this.cancel && this.input.getRawLine() != null) {
                    this.previousPath = this.currentPath;
                    this.currentPath = this.input.getPath();
                    if (this.input.getLevel() == 0) {
                        this.previousXref = this.currentXref;
                        this.currentXref = this.input.getXref();
                    }
                    if (this.input.getLevel() == 0 && this.input.getTag().equals("HEAD")) {
                        this.currentXref = "HEAD";
                        this.output.writeLine(this.input);
                        continue;
                    }
                    if (this.process()) continue;
                    if (this.input.getTag().equals("TRLR")) {
                        EOFfound = true;
                        this.finalise();
                        this.output.writeLine(0, "TRLR", null);
                        continue;
                    }
                    this.output.writeLine(this.input);
                }
                if (!EOFfound) {
                    this.finalise();
                    this.output.writeLine(0, "TRLR", null);
                }
            }
            finally {
                this.input.close();
                this.output.close();
            }
        }
        catch (FileNotFoundException e1) {
            JOptionPane.showMessageDialog(null, NbBundle.getMessage(Import.class, (String)"file.not.found", (Object)fileIn.getName()));
            return false;
        }
        catch (GedcomFormatException e) {
            l = "" + e.getLine();
            JOptionPane.showMessageDialog(null, e.getMessage() + "\n" + NbBundle.getMessage(Import.class, (String)"error.line", (Object)l));
            return false;
        }
        catch (IOException | MissingResourceException e) {
            JOptionPane.showMessageDialog(null, e.getMessage());
            LOG.log(Level.SEVERE, "Error during new file reading.", e);
            return false;
        }
        return true;
    }

    protected void init() {
        this.nbChanges = 0;
        this.headerzone = false;
        this.destination_found = 0;
        this.place_found = 0;
        for (int i = 0; i < 20; ++i) {
            this.place_format_sizes[i] = 0;
        }
        this.char_found = 1;
        hashIndis = new HashMap();
        hashFams = new HashMap();
        hashNotes = new HashMap();
        hashObjes = new HashMap();
        hashSours = new HashMap();
        hashRepos = new HashMap();
        hashSubms = new HashMap();
        hashAssos = new HashMap();
        this.parentLevel = 0;
        this.parentLevelTag = "";
        this.levelBeingRepaired = 100;
        this.invalidPaths = new HashSet<String>();
    }

    protected void firstPass() {
        int length;
        if (this.headerzone && this.input.getLevel() == 0 && !this.input.getTag().equals("HEAD")) {
            this.headerzone = false;
        }
        if (this.input.getLevel() == 0 && this.input.getTag().equals("HEAD")) {
            this.headerzone = true;
        }
        if (this.headerzone && this.input.getLevel() == 1 && "GEDC".equals(this.input.getTag())) {
            this.grammarZone = true;
        }
        if (this.headerzone && this.input.getLevel() == 1 && "SOUR".equals(this.input.getTag())) {
            this.grammarZone = false;
        }
        if (this.headerzone && (this.input.getPath().toString().equals("HEAD:SOUR") || this.input.getPath().toString().equals("HEAD:SOUR:NAME"))) {
            this.software_name = this.input.getValue();
        }
        if (this.headerzone && this.input.getPath().toString().equals("HEAD:SOUR:VERS")) {
            this.software_vers = this.input.getValue();
        }
        if (this.headerzone && this.input.getLevel() == 1 && "CHAR".equals(this.input.getTag())) {
            this.char_found = this.input.getValue().equals("UTF-8") && this.input.getValue().equals(this.input.getCharset().name()) ? 2 : 1;
            this.grammarZone = false;
        }
        if (this.grammarZone && this.headerzone && this.input.getLevel() == 2 && this.input.getTag().equals("VERS")) {
            this.GEDCOM_VERSION = this.input.getValue();
            this.summary.put("b.gedcomversion", this.GEDCOM_VERSION);
        }
        if (this.headerzone && "NOTE".equals(this.input.getTag())) {
            this.noteFound = true;
        }
        if (this.input.getLevel() == 1 && this.input.getTag().equals("DEST")) {
            String value = this.input.getValue();
            this.destination_found = value != null && (value.equals("ANSTFILE") || value.equals("TempleReady") || value.equals("ANY")) ? 2 : 1;
        }
        if (this.headerzone && this.input.getLevel() == 1 && this.input.getTag().equals("PLAC")) {
            try {
                this.input.getNextLine(false);
            }
            catch (IOException value) {
                // empty catch block
            }
            if (this.input.getTag().equals("FORM") && this.input.getValue() != null) {
                String form = this.input.getValue().replaceAll(" ", "").replaceAll(",", "");
                this.place_found = (form = form.toUpperCase(TextOptions.getInstance().getOutputLocale(Locale.getDefault()))).matches("\\p{L}*") ? 2 : 1;
            }
        }
        if (this.input.getTag().equals("PLAC") && !this.input.getValue().isEmpty() && (length = this.input.getValue().split(",").length) < 20) {
            Integer[] integerArray = this.place_format_sizes;
            int n = length;
            Integer n2 = integerArray[n];
            Integer n3 = integerArray[n] = Integer.valueOf(integerArray[n] + 1);
        }
        this.memorizeEntities();
    }

    protected boolean process() throws IOException {
        if (this.repairNonGedcomLines()) {
            return true;
        }
        if (this.processHeader()) {
            return true;
        }
        if (this.processInvalidTag(this.input.getTag())) {
            return true;
        }
        if (this.processInvalidPath(this.input.getPath())) {
            return true;
        }
        if (this.processEventValues(this.input.getPath())) {
            return true;
        }
        if (this.processInvalidDates(this.input.getValue(), "")) {
            return true;
        }
        return this.processInvalidAges();
    }

    protected void finalise() throws IOException {
        this.checkAssociationEntities();
        this.addMissingEntities();
        this.state = 2;
        this.progress = 1;
    }

    @Override
    public boolean fixGedcom(Gedcom gedcom) {
        gedcom.setEncoding(GedcomConstants.Encodings.UTF8);
        boolean ret = false;
        ret |= this.fixNames(gedcom);
        this.incrementProgress();
        ret |= this.fixPlaces(gedcom);
        this.incrementProgress();
        ret |= this.fixEventsCardinality(gedcom);
        this.incrementProgress();
        ret |= this.fixObje(gedcom);
        this.incrementProgress();
        ret |= this.fixAddr(gedcom);
        this.incrementProgress();
        ret |= this.fixSources(gedcom);
        this.incrementProgress();
        ret |= this.fixSourceCitations(gedcom);
        this.incrementProgress();
        ret |= this.fixNoteCitations(gedcom);
        this.incrementProgress();
        ret |= this.fixConcCont(gedcom);
        this.incrementProgress();
        ret |= this.fixTexts(gedcom);
        this.incrementProgress();
        if (this.revertAsso) {
            ret |= this.convertAssociations(gedcom);
        }
        return ret;
    }

    @Override
    public void complete() {
        this.progress = 100;
    }

    @Override
    public void showDetails(Context context, boolean extract) {
    }

    private void memorizeEntities() {
        this.memorizeEntity("INDI", hashIndis);
        this.memorizeProperty("HUSB", hashIndis);
        this.memorizeProperty("WIFE", hashIndis);
        this.memorizeProperty("CHIL", hashIndis);
        this.memorizeProperty("ALIA", hashIndis);
        this.memorizeAssociation();
        this.memorizeEntity("FAM", hashFams);
        this.memorizeProperty("FAMS", hashFams);
        this.memorizeProperty("FAMC", hashFams);
        this.memorizeEntity("NOTE", hashNotes);
        this.memorizeProperty("NOTE", hashNotes);
        this.memorizeEntity("OBJE", hashObjes);
        this.memorizeProperty("OBJE", hashObjes);
        this.memorizeEntity("SOUR", hashSours);
        this.memorizeProperty("SOUR", hashSours);
        this.memorizeEntity(typerepo, hashRepos);
        this.memorizeProperty(typerepo, hashRepos);
        this.memorizeEntity("SUBM", hashSubms);
        this.memorizeProperty("SUBM", hashSubms);
        this.memorizeProperty("SUBN", hashSubms);
        this.memorizeProperty("ANCI", hashSubms);
        this.memorizeProperty("DESI", hashSubms);
    }

    private boolean repairNonGedcomLines() throws IOException {
        int input_level = this.input.getLevel();
        String input_tag = this.input.getTag();
        boolean invalidLine = false;
        boolean invalidTag = false;
        if (input_level == -1) {
            invalidLine = true;
        } else {
            String input_xref = this.input.getXref();
            TagPath input_path = this.input.getPath();
            if (input_tag == null || input_tag.isEmpty() || input_xref == null || input_path == null) {
                invalidLine = true;
            } else if (input_tag.startsWith("_")) {
                if (!input_tag.substring(1).replaceAll("_", "").matches("[A-Z0-9]+")) {
                    invalidLine = true;
                }
            } else if (input_tag.length() > 5 && input_tag.length() < 15 && input_tag.matches("[A-Z]+")) {
                invalidTag = true;
            } else if (input_tag.length() < 3 || input_tag.length() > 5 || !input_tag.replaceAll("_", "").matches("[A-Z0-9]+")) {
                invalidLine = true;
            }
        }
        if (invalidLine) {
            String xref = this.currentXref;
            if (this.input.getLevel() == 0) {
                xref = this.previousXref;
            }
            this.levelBeingRepaired = this.parentLevel + 1;
            if (ALLOW_CONT_TAGS.matcher(this.parentLevelTag).matches()) {
                this.output.writeLine(this.levelBeingRepaired, "CONT", this.input.getLine());
                String pathAfter = this.previousPath.toString().endsWith("CONC") ? this.previousPath.getParent().getShortName() + ":CONT" : this.previousPath.getShortName() + ":CONT";
                this.fixes.add(new ImportFix(xref, "repairLine.1", "", pathAfter, this.input.getLine(), this.input.getLine()));
            } else {
                this.levelBeingRepaired = this.parentLevel;
                String newtag = ":NOTE";
                if (this.levelBeingRepaired == 0) {
                    this.levelBeingRepaired = 1;
                    newtag = "NOTE";
                }
                if (!this.input.getLine().trim().isEmpty()) {
                    this.output.writeLine(this.levelBeingRepaired, "NOTE", this.input.getLine());
                    this.fixes.add(new ImportFix(xref, "repairLine.2", "", this.previousPath.getParent().getShortName() + newtag, this.input.getLine(), this.input.getLine()));
                } else {
                    this.fixes.add(new ImportFix(xref, "repairLine.3", "", this.previousPath.getParent().getShortName(), this.input.getLine(), this.input.getLine()));
                }
            }
            return true;
        }
        if (invalidTag) {
            String newTag = "_" + this.input.getTag().replaceAll("[^A-Za-z0-9]", "");
            this.output.writeLine(this.input.getLevel(), this.input.getXref(), newTag, this.input.getValue());
            this.fixes.add(new ImportFix(this.currentXref, "invalidTag.1", this.input.getPath().getShortName(), this.input.getPath().getParent().getShortName() + ":" + newTag, this.input.getValue(), this.input.getValue()));
            return true;
        }
        if (!input_tag.equals("CONC") && !input_tag.equals("CONT") && input_level < this.levelBeingRepaired) {
            this.parentLevel = input_level;
            this.parentLevelTag = input_tag;
            this.levelBeingRepaired = 100;
        }
        return false;
    }

    public boolean processHeader() throws IOException {
        if (!this.headNoteWritten) {
            if (this.noteFound) {
                if ("NOTE".equals(this.input.getTag())) {
                    this.output.writeLine(1, "NOTE", this.getImportComment());
                    this.fixes.add(new ImportFix("HEAD", "header.NoteInserted", this.input.getPath().getShortName(), "HEAD:NOTE", this.input.getValue(), this.getImportComment() + this.input.getValue()));
                    this.headNoteWritten = true;
                    this.output.writeLine(2, "CONT", this.input.getValue());
                    return true;
                }
            } else {
                this.output.writeLine(1, "NOTE", this.getImportComment());
                this.fixes.add(new ImportFix("HEAD", "header.NoteAdded", "", "HEAD:NOTE", "", this.getImportComment()));
                this.headNoteWritten = true;
            }
        }
        if (this.destination_found == 0 && this.input.getLevel() == 1 && this.input.getTag().equals("GEDC")) {
            this.output.writeLine(1, "DEST", "ANY");
            this.output.writeLine(1, "GEDC", "");
            this.destination_found = 2;
            this.fixes.add(new ImportFix("HEAD", "header.DestinationAdded", "", "HEAD:DEST", "", "ANY"));
            return true;
        }
        if (this.destination_found == 1 && this.input.getLevel() == 1 && this.input.getTag().equals("DEST")) {
            this.output.writeLine(1, "DEST", "ANY");
            this.destination_found = 2;
            this.fixes.add(new ImportFix("HEAD", "header.DestinationChanged", this.input.getPath().getShortName(), "HEAD:DEST", this.input.getValue(), "ANY"));
            return true;
        }
        if (this.place_found == 0 && this.input.getLevel() == 1 && this.input.getTag().equals("PLAC")) {
            this.output.writeLine(this.input.getLevel(), this.input.getTag(), this.input.getValue());
            this.output.writeLine(2, "FORM", this.getPlaceFormat(false));
            this.place_found = 2;
            this.fixes.add(new ImportFix("HEAD", "header.PlaceAdded", "", "HEAD:PLAC:FORM", "", this.getPlaceFormat(false)));
            return true;
        }
        if (this.place_found == 1 && this.input.getLevel() == 1 && this.input.getTag().equals("PLAC")) {
            this.output.writeLine(this.input.getLevel(), this.input.getTag(), this.input.getValue());
            this.input.getNextLine(true);
            this.output.writeLine(this.input.getLevel(), this.input.getTag(), this.input.getValue());
            this.place_found = 2;
            this.fixes.add(new ImportFix("HEAD", "header.PlaceInvalid", this.input.getPath().getShortName(), "HEAD:PLAC:FORM", this.input.getValue(), this.input.getValue()));
            return true;
        }
        if (this.input.getLevel() == 1 && this.input.getTag().equals("CHAR")) {
            boolean ret = false;
            if (this.char_found == 1) {
                String valueBefore = this.input.getValue();
                String valueAfter = "UTF-8";
                String correction = "";
                if (this.input.isCharsetDeterministic()) {
                    valueBefore = valueBefore + " (" + this.input.getCharset().name() + ")";
                    correction = "header.CharChanged";
                } else {
                    correction = "header.CharInvalid";
                }
                this.output.writeLine(this.input.getLevel(), this.input.getTag(), this.input.getValue());
                this.char_found = 2;
                this.fixes.add(new ImportFix("HEAD", correction, this.input.getPath().getShortName(), "HEAD:CHAR", valueBefore, valueAfter));
                ret = true;
            }
            if (this.place_found == 0) {
                this.output.writeLine(1, "PLAC", "");
                this.output.writeLine(2, "FORM", this.getPlaceFormat(false));
                this.output.writeLine(this.input.getLevel(), this.input.getXref(), this.input.getTag(), this.input.getValue());
                this.place_found = 2;
                this.fixes.add(new ImportFix("HEAD", "header.PlaceAdded", "", "HEAD:PLAC:FORM", "", this.getPlaceFormat(false)));
                ret = true;
            }
            if (ret) {
                return ret;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean processEventValues(TagPath path) throws IOException {
        String tag = path.getLast();
        Matcher matcher = tag_y.matcher(tag);
        if (matcher.matches()) {
            int level = this.input.getLevel();
            String localxref = this.currentXref;
            String tagBefore = this.input.getTag();
            String pathBefore = this.input.getPath().getShortName();
            String valueBefore = this.input.getValue();
            if (!valueBefore.isEmpty()) {
                if (valueBefore.equalsIgnoreCase("y")) {
                    return false;
                }
                if (valueBefore.length() <= 90) return false;
                this.output.writeLine(level, tag, null);
                String newTag = "NOTE";
                String correction = "eventValue.2";
                this.output.writeLine(level + 1, newTag, valueBefore);
                this.fixes.add(new ImportFix(localxref, correction, pathBefore, path.getShortName() + ":" + newTag, valueBefore, valueBefore));
                return true;
            }
            try {
                String temp = this.input.getNextLine(false);
                if (temp != null && this.input.getLevel() == level + 1) {
                    this.output.writeLine(level, tag, null);
                    if (tag.equals(tagBefore)) return true;
                    this.fixes.add(new ImportFix(localxref, "invalidTagLocation.2", pathBefore, path.getShortName(), valueBefore, valueBefore));
                    return true;
                }
                this.output.writeLine(level, tag, "Y");
                this.fixes.add(new ImportFix(localxref, "eventValue.3", pathBefore, path.getShortName(), "", "Y"));
                return true;
            }
            catch (GedcomFormatException e) {
                this.output.writeLine(level, tag, null);
            }
            return true;
        }
        if (!"RESI".equals(tag)) return false;
        int level = this.input.getLevel();
        String localxref = this.currentXref;
        String valueBefore = this.input.getValue();
        String pathBefore = this.input.getPath().getShortName();
        if (valueBefore.isEmpty()) return false;
        if (valueBefore.length() <= 90) {
            return false;
        }
        this.output.writeLine(level, tag, null);
        String newTag = "NOTE";
        String correction = "eventValue.2";
        this.output.writeLine(level + 1, newTag, valueBefore);
        this.fixes.add(new ImportFix(localxref, correction, pathBefore, path.getShortName() + ":" + newTag, valueBefore, valueBefore));
        return true;
    }

    public boolean processInvalidTag(String tag) throws IOException {
        Pattern tag_valid;
        TagPath path = this.input.getPath();
        String valueBefore = this.input.getValue();
        if (this.input.getLevel() == 2 && this.input.getTag().equals("_SHAR")) {
            this.output.writeLine(2, "ASSO", this.input.getValue());
            this.fixes.add(new ImportFix(this.currentXref, "invalidTag.3", path.getShortName(), path.getParent().getShortName() + ":ASSO", valueBefore, valueBefore));
            this.revertAsso = true;
            return true;
        }
        if (this.input.getLevel() == 1 && (this.input.getTag().equals("_MILT") || this.input.getTag().equals("_EVT") || this.input.getTag().equals("_PCS") || this.input.getTag().equals("_CCB"))) {
            String valueAfter = this.input.getTag().substring(1) + (valueBefore.isEmpty() ? "" : " - " + valueBefore);
            this.output.writeLine(this.input.getLevel(), "EVEN", valueAfter);
            this.fixes.add(new ImportFix(this.currentXref, "invalidTag.3", path.getShortName(), path.getParent().getShortName() + ":EVEN", valueBefore, valueAfter));
            return true;
        }
        if (this.input.getLevel() == 1 && (this.input.getTag().equals("_DNA") || this.input.getTag().equals("_DPC") || this.input.getTag().equals("_REL"))) {
            this.output.writeLine(this.input.getLevel(), "FACT", valueBefore);
            this.fixes.add(new ImportFix(this.currentXref, "invalidTag.3", path.getShortName(), path.getParent().getShortName() + ":FACT", valueBefore, valueBefore));
            return true;
        }
        if (this.input.getLevel() == 1 && (this.input.getTag().equals("_MDCL") || this.input.getTag().equals("_HEIG") || this.input.getTag().equals("_WEIG"))) {
            this.output.writeLine(this.input.getLevel(), "DSCR", valueBefore);
            this.output.writeLine(this.input.getLevel() + 1, "TYPE", this.input.getTag().substring(1));
            this.fixes.add(new ImportFix(this.currentXref, "invalidTag.3", path.getShortName(), path.getParent().getShortName() + ":DSCR", valueBefore, valueBefore));
            return true;
        }
        if (this.input.getLevel() == 1 && (this.input.getTag().equals("DEED") || this.input.getTag().equals("MISE") || this.input.getTag().equals("MILI"))) {
            String valueAfter = this.input.getTag() + (valueBefore.isEmpty() ? "" : " - " + valueBefore);
            this.output.writeLine(this.input.getLevel(), "EVEN", valueAfter);
            this.fixes.add(new ImportFix(this.currentXref, "invalidTag.2", path.getShortName(), path.getParent().getShortName() + ":EVEN", valueBefore, valueAfter));
            return true;
        }
        if (this.input.getLevel() == 1 && this.input.getTag().equals("PACS")) {
            this.output.writeLine(this.input.getLevel(), "MARC", valueBefore);
            this.fixes.add(new ImportFix(this.currentXref, "invalidTag.2", path.getShortName(), path.getParent().getShortName() + ":MARC", valueBefore, valueBefore));
            return true;
        }
        if (this.input.getLevel() == 1 && this.input.getTag().equals("INHU")) {
            this.output.writeLine(this.input.getLevel(), "BURI", valueBefore);
            this.fixes.add(new ImportFix(this.currentXref, "invalidTag.2", path.getShortName(), path.getParent().getShortName() + ":BURI", valueBefore, valueBefore));
            return true;
        }
        if (this.input.getLevel() == 1 && this.input.getTag().equals("URL")) {
            this.output.writeLine(this.input.getLevel(), "FILE", valueBefore);
            this.fixes.add(new ImportFix(this.currentXref, "invalidTag.2", path.getShortName(), path.getParent().getShortName() + ":FILE", valueBefore, valueBefore));
            return true;
        }
        if (tag.startsWith("_")) {
            return false;
        }
        Pattern pattern = tag_valid = this.GEDCOM_VERSION.startsWith("5.5.1") ? tag551_valid : tag55_valid;
        if (!tag_valid.matcher(tag).matches()) {
            this.output.writeLine(this.input.getLevel(), "_" + tag, this.input.getValue());
            this.fixes.add(new ImportFix(this.currentXref, "invalidTag.1", path.getShortName(), path.getParent().getShortName() + ":_" + tag, valueBefore, valueBefore));
            return true;
        }
        return false;
    }

    public boolean processInvalidPath(TagPath path) throws IOException {
        for (String p : this.invalidPaths) {
            if (!path.endsWith(new TagPath(p))) continue;
            this.renameTag();
            return true;
        }
        if (this.input.getLevel() == 2 && this.input.getTag().equals("ASSO")) {
            this.revertAsso = true;
        }
        return false;
    }

    public void renameTag() throws IOException {
        String newTag = "_" + this.input.getTag();
        this.output.writeLine(this.input.getLevel(), newTag, this.input.getValue());
        this.fixes.add(new ImportFix(this.currentXref, "invalidTagLocation.1", this.input.getPath().getShortName(), this.input.getPath().getParent().getShortName() + ":" + newTag, this.input.getValue(), this.input.getValue()));
    }

    public boolean processInvalidDates(String date, String correction) throws IOException {
        if ("DATE".equals(this.input.getTag())) {
            String valueBefore;
            String valueAfter = valueBefore = date;
            if (valueBefore.contains("/") && !(valueAfter = this.convertDate(valueBefore)).equals(valueBefore)) {
                correction = "invalidDate.1";
            }
            if (!(valueAfter = (valueBefore = valueAfter).toUpperCase()).equals(valueBefore)) {
                correction = "invalidDate.2";
            }
            if (!(valueBefore = valueAfter).equals(valueAfter = this.julianCalCheck(valueBefore))) {
                correction = "invalidDate.4";
            }
            if (!(valueBefore = valueAfter).equals(valueAfter = this.frenchCalCheck(valueBefore))) {
                correction = "invalidDate.5";
            }
            PropertyDate pDate = new PropertyDate();
            pDate.setValue(valueAfter);
            if (!pDate.isValid()) {
                valueBefore = valueAfter;
                if (!(valueAfter = this.fixDate(valueBefore)).equals(valueBefore)) {
                    pDate.setValue(valueAfter);
                    correction = "invalidDate.6";
                }
                if (!pDate.isValid()) {
                    correction = "invalidDate.3";
                }
            }
            if (!correction.isEmpty()) {
                this.output.writeLine(this.input.getLevel(), "DATE", valueAfter);
                String tagPathBefore = this.input.getPath().getShortName();
                this.fixes.add(new ImportFix(this.currentXref, correction, tagPathBefore, tagPathBefore, this.input.getValue(), valueAfter));
                return true;
            }
        }
        return false;
    }

    public String convertDate(String date) {
        date = date.contains("@#DHEBREW@") ? date.replaceAll("/01/", " TSH ").replaceAll("/02/", " CSH ").replaceAll("/03/", " KSL ").replaceAll("/04/", " TVT ").replaceAll("/05/", " SHV ").replaceAll("/06/", " ADR ").replaceAll("/07/", " ADS ").replaceAll("/08/", " NSN ").replaceAll("/09/", " IYR ").replaceAll("/10/", " SVN ").replaceAll("/11/", " TMZ ").replaceAll("/12/", " AAV ").replaceAll("/13/", " ELL ").replaceAll("/1/", " TSH ").replaceAll("/2/", " CSH ").replaceAll("/3/", " KSL ").replaceAll("/4/", " TVT ").replaceAll("/5/", " SHV ").replaceAll("/6/", " ADR ").replaceAll("/7/", " ADS ").replaceAll("/8/", " NSN ").replaceAll("/9/", " IYR ") : (date.contains("@#DFRENCH R@") ? date.replaceAll("/01/", " VEND ").replaceAll("/02/", " BRUM ").replaceAll("/03/", " FRIM ").replaceAll("/04/", " NIVO ").replaceAll("/05/", " PLUV ").replaceAll("/06/", " VENT ").replaceAll("/07/", " GERM ").replaceAll("/08/", " FLOR ").replaceAll("/09/", " PRAI ").replaceAll("/10/", " MESS ").replaceAll("/11/", " THER ").replaceAll("/12/", " FRUC ").replaceAll("/12/", " COMP ").replaceAll("/1/", " VEND ").replaceAll("/2/", " BRUM ").replaceAll("/3/", " FRIM ").replaceAll("/4/", " NIVO ").replaceAll("/5/", " PLUV ").replaceAll("/6/", " VENT ").replaceAll("/7/", " GERM ").replaceAll("/8/", " FLOR ").replaceAll("/9/", " PRAI ") : date.replaceAll("/01/", " JAN ").replaceAll("/02/", " FEB ").replaceAll("/03/", " MAR ").replaceAll("/04/", " APR ").replaceAll("/05/", " MAY ").replaceAll("/06/", " JUN ").replaceAll("/07/", " JUL ").replaceAll("/08/", " AUG ").replaceAll("/09/", " SEP ").replaceAll("/10/", " OCT ").replaceAll("/11/", " NOV ").replaceAll("/12/", " DEC ").replaceAll("/1/", " JAN ").replaceAll("/2/", " FEB ").replaceAll("/3/", " MAR ").replaceAll("/4/", " APR ").replaceAll("/5/", " MAY ").replaceAll("/6/", " JUN ").replaceAll("/7/", " JUL ").replaceAll("/8/", " AUG ").replaceAll("/9/", " SEP "));
        return date;
    }

    private String julianCalCheck(String in) {
        String JULIAN_TAG = "@#DJULIAN@";
        Pattern julian_cal = Pattern.compile("(@#DJULIAN@ )(.*)");
        Pattern date_value = Pattern.compile("(FROM|BEF|AFT|BET|AND|TO|ABT|CAL|EST) (.*)");
        Pattern date_range = Pattern.compile("(FROM|BEF|AFT|BET|AND|TO) (.*) (TO|AND) (.*)");
        String result = "";
        Matcher matcher = julian_cal.matcher(in);
        if (matcher.matches() && matcher.groupCount() > 1) {
            String date_parameter = matcher.group(2);
            Matcher m1 = date_range.matcher(date_parameter);
            if (m1.matches()) {
                result = result + m1.group(1) + " " + "@#DJULIAN@" + " " + m1.group(2);
                result = result + " " + m1.group(3) + " " + "@#DJULIAN@" + " " + m1.group(4);
                return result;
            }
            m1 = date_value.matcher(date_parameter);
            if (m1.matches()) {
                result = result + m1.group(1) + " " + "@#DJULIAN@" + " " + m1.group(2);
                return result;
            }
            result = result + "@#DJULIAN@ " + matcher.group(2);
            return result;
        }
        return in;
    }

    private String frenchCalCheck(String in) {
        String FRENCH_TAG = "@#DFRENCH R@";
        Pattern french_cal = Pattern.compile("(@#DFRENCH R@ )(.*)");
        Pattern date_value = Pattern.compile("(FROM|BEF|AFT|BET|AND|TO|ABT|CAL|EST) (.*)");
        Pattern date_range = Pattern.compile("(FROM|BEF|AFT|BET|AND|TO) (.*) (TO|AND) (.*)");
        String result = "";
        Matcher matcher = french_cal.matcher(in);
        if (matcher.matches() && matcher.groupCount() > 1) {
            String date_parameter = matcher.group(2);
            Matcher m1 = date_range.matcher(date_parameter);
            if (m1.matches()) {
                result = result + m1.group(1) + " " + "@#DFRENCH R@" + " " + Import.convDateFormat(m1.group(2));
                result = result + " " + m1.group(3) + " " + "@#DFRENCH R@" + " " + Import.convDateFormat(m1.group(4));
                return result;
            }
            m1 = date_value.matcher(date_parameter);
            if (m1.matches()) {
                result = result + m1.group(1) + " " + "@#DFRENCH R@" + " " + Import.convDateFormat(m1.group(2));
                return result;
            }
            result = result + "@#DFRENCH R@ " + Import.convDateFormat(matcher.group(2));
            return result;
        }
        return in;
    }

    private static String convDateFormat(String from) {
        HashMap<String, String> repmonconvtable = new HashMap<String, String>(){
            {
                this.put("I", "1");
                this.put("II", "2");
                this.put("III", "3");
                this.put("IV", "4");
                this.put("V", "5");
                this.put("VI", "6");
                this.put("VII", "7");
                this.put("VIII", "8");
                this.put("IX", "9");
                this.put("X", "10");
                this.put("XI", "11");
                this.put("XII", "12");
                this.put("XIII", "13");
            }
        };
        Pattern french_date = Pattern.compile("(.*) (.*) AN (\\w*)(.*)");
        Matcher m = french_date.matcher(from);
        if (m.matches() && m.groupCount() > 3) {
            String gp2 = m.group(2).substring(0, 4).replaceAll("JOUR", "COMP").replaceAll("NIV\u00d4", "NIVO");
            String gp3 = (String)repmonconvtable.get(m.group(3));
            if (gp3 == null) {
                return from;
            }
            String result = m.group(1) + " " + gp2 + " " + gp3;
            if (m.groupCount() > 4) {
                result = result + m.group(4);
            }
            return result;
        }
        return from;
    }

    public String fixDate(String date) {
        if (SPANISH_MONTHS_PATTERN.matcher(date).find()) {
            date = date.replaceAll(" DE ", "").replaceAll("ENERO", " JAN ").replaceAll("FEBRERO", " FEB ").replaceAll("MARZO", " MAR ").replaceAll("ABRIL", " APR ").replaceAll("MAYO", " MAY ").replaceAll("JUNIO", " JUN ").replaceAll("JULIO", " JUL ").replaceAll("AGOSTO", " AUG ").replaceAll("SEPTIEMBRE", " SEP ").replaceAll("OCTUBRE", " OCT ").replaceAll("NOVIEMBRE", " NOV ").replaceAll("DICIEMBRE", " DEC ").replaceAll("\\s+", " ");
        }
        if ((date = date.trim().replaceAll("\\.", " ").replaceAll("\\:", " ").replaceAll("ABOUT", "ABT ").replaceAll("CIRCA", "ABT ").replaceAll("AFTER", "AFT ").replaceAll("BEFORE", "BEF ").replaceAll("ESTIMATED", "EST ").replaceAll("JANUARY", "JAN").replaceAll("FEBRUARY", "FEB").replaceAll("FEBUARY", "FEB").replaceAll("MARCH", "MAR").replaceAll("APRIL", "APR").replaceAll("JUNE", "JUN").replaceAll("JULY", "JUL").replaceAll("AUGUST", "AUG").replaceAll("SEPTEMBER", "SEP").replaceAll("SEPT", "SEP").replaceAll("OCTOBER", "OCT").replaceAll("NOVEMBER", "NOV").replaceAll("DECEMBER", "DEC").replaceAll("\\s+", " ")).matches("([0-9]{1,2}[A-Z]{1,3}[0-9]{3,4})")) {
            date = date.replaceAll("JAN", " JAN ").replaceAll("FEB", " FEB ").replaceAll("MAR", " MAR ").replaceAll("APR", " APR ").replaceAll("MAY", " MAY ").replaceAll("JUN", " JUN ").replaceAll("JUL", " JUL ").replaceAll("AUG", " AUG ").replaceAll("SEP", " SEP ").replaceAll("OCT", " OCT ").replaceAll("NOV", " NOV ").replaceAll("DEC", " DEC ");
        }
        if (date.matches("([0-9]{8})")) {
            date = this.convertDate(date.substring(6, 8) + "/" + date.substring(4, 6) + "/" + date.substring(0, 4));
        }
        if (date.matches("[0-9]{4}-[0-9]{4}") || date.matches("[0-9]{4}\\/[0-9]{4}")) {
            date = "BET " + date.substring(0, 4) + " AND " + date.substring(5, 9);
        }
        if (date.matches("[0-9]{4}-[0-9]{2}")) {
            date = this.convertDate("/" + date.substring(5, 7) + "/" + date.substring(0, 4)).trim();
        }
        return date;
    }

    public boolean processInvalidAges() throws IOException {
        String age;
        if ("AGE".equals(this.input.getTag()) && StringUtils.isNumeric((String)(age = this.input.getValue()))) {
            age = age + "y";
            String tagPathBefore = this.input.getPath().getShortName();
            this.output.writeLine(this.input.getLevel(), "AGE", age);
            this.fixes.add(new ImportFix(this.currentXref, "invalidAge.1", tagPathBefore, tagPathBefore, this.input.getValue(), age));
            return true;
        }
        return false;
    }

    private void checkAssociationEntities() {
        for (String k : hashAssos.keySet()) {
            if (hashIndis.containsKey(k) || hashFams.containsKey(k)) continue;
            hashIndis.put(k, new ImportEnt());
        }
    }

    private void addMissingEntities() throws IOException {
        for (String k : hashIndis.keySet()) {
            if (Import.hashIndis.get((Object)k).seen) continue;
            this.output.writeLine(0, k, "INDI", null);
            this.fixes.add(new ImportFix(k, "missingEntity.Indi", "", "INDI", "", ""));
        }
        for (String k : hashFams.keySet()) {
            if (Import.hashFams.get((Object)k).seen) continue;
            this.output.writeLine(0, k, "FAM", null);
            this.fixes.add(new ImportFix(k, "missingEntity.Fam", "", "FAM", "", ""));
        }
        for (String k : hashNotes.keySet()) {
            if (Import.hashNotes.get((Object)k).seen) continue;
            this.output.writeLine(0, k, "NOTE", null);
            this.fixes.add(new ImportFix(k, "missingEntity.Note", "", "NOTE", "", ""));
        }
        for (String k : hashObjes.keySet()) {
            if (Import.hashObjes.get((Object)k).seen) continue;
            this.output.writeLine(0, k, "OBJE", null);
            this.fixes.add(new ImportFix(k, "missingEntity.Obje", "", "OBJE", "", ""));
        }
        for (String k : hashSours.keySet()) {
            if (Import.hashSours.get((Object)k).seen) continue;
            this.output.writeLine(0, k, "SOUR", null);
            this.fixes.add(new ImportFix(k, "missingEntity.Sour", "", "SOUR", "", ""));
        }
        for (String k : hashRepos.keySet()) {
            if (Import.hashRepos.get((Object)k).seen) continue;
            this.output.writeLine(0, k, typerepo, null);
            this.fixes.add(new ImportFix(k, "missingEntity.Repo", "", typerepo, "", ""));
        }
        for (String k : hashSubms.keySet()) {
            if (Import.hashSubms.get((Object)k).seen) continue;
            this.output.writeLine(0, k, "SUBM", null);
            this.fixes.add(new ImportFix(k, "missingEntity.Subm", "", "SUBM", "", ""));
        }
    }

    public boolean fixNames(Gedcom gedcom) {
        LOG.fine("Import processing - Fixing names...");
        boolean hasErrors = false;
        HashSet<String> nameTags = new HashSet<String>(Arrays.asList("NPFX", "GIVN", "SPFX", "SURN", "NSFX"));
        Collection<Indi> indis = gedcom.getIndis();
        int increment = indis.size() / 10 + 1;
        int counter = 0;
        for (Indi indi : indis) {
            Property[] rawNames;
            if (++counter % increment == 0 && this.progress < 100) {
                ++this.progress;
            }
            for (Property rawName : rawNames = indi.getProperties("NAME", false)) {
                if (!(rawName instanceof PropertyName)) continue;
                PropertyName propName = (PropertyName)rawName;
                for (Property subprop : propName.getProperties()) {
                    String subTag = subprop.getTag();
                    String pathBefore = subprop.getPath(true).getShortName();
                    if (!nameTags.contains(subTag) || !subprop.getValue().isEmpty() || subprop.getNoOfProperties() != 0) continue;
                    propName.delProperty(subprop);
                    hasErrors = true;
                    this.fixes.add(new ImportFix(indi.getId(), "invalidName.2", pathBefore, "", "", ""));
                }
                if (!propName.isValid() || propName.hasWarning()) {
                    String valueBefore = propName.getNameTagValue();
                    String pathBefore = propName.getPath(true).getShortName();
                    propName.fixNameValue();
                    String valueAfter = propName.getValue();
                    if (!valueBefore.equals(valueAfter)) {
                        hasErrors = true;
                        this.fixes.add(new ImportFix(indi.getId(), "invalidName.1", pathBefore, pathBefore, valueBefore, valueAfter));
                    }
                }
                String first = propName.getPropertyValue("GIVN");
                String last = propName.getPropertyValue("SURN");
                propName.setName(first, last);
            }
        }
        return hasErrors;
    }

    public boolean fixPlaces(Gedcom gedcom) {
        LOG.fine("Import processing - Fixing places...");
        boolean hasErrors = false;
        String[] locs = null;
        int nbLocs = PropertyPlace.getFormat(gedcom.getPlaceFormat()).length;
        List<? extends Property> places = gedcom.getPropertiesByClass(PropertyPlace.class);
        int increment = places.size() / 10 + 1;
        int counter = 0;
        for (PropertyPlace propertyPlace : places) {
            String valueAfter;
            String pathBefore;
            if (++counter % increment == 0 && this.progress < 100) {
                ++this.progress;
            }
            if ((locs = propertyPlace.getJurisdictions()).length == 1) {
                int cityIndex = propertyPlace.getCityIndex();
                Object[] locs2 = new String[nbLocs];
                Arrays.fill(locs2, "");
                locs2[cityIndex] = locs[0];
                String valueBefore = propertyPlace.getValue();
                String pathBefore2 = propertyPlace.getPath(true).getShortName();
                propertyPlace.setJurisdictions(gedcom, (String[])locs2);
                String valueAfter2 = propertyPlace.getValue();
                if (valueAfter2.equals(valueBefore)) continue;
                hasErrors = true;
                this.fixes.add(new ImportFix(propertyPlace.getEntity().getId(), "invalidPlace.1", pathBefore2, pathBefore2, valueBefore, valueAfter2));
                continue;
            }
            if (locs.length < nbLocs) {
                String valueBefore = propertyPlace.getValue();
                pathBefore = propertyPlace.getPath(true).getShortName();
                propertyPlace.setJurisdictions(gedcom, locs);
                valueAfter = propertyPlace.getValue();
                if (valueAfter.equals(valueBefore)) continue;
                hasErrors = true;
                this.fixes.add(new ImportFix(propertyPlace.getEntity().getId(), "invalidPlace.1", pathBefore, pathBefore, valueBefore, valueAfter));
                continue;
            }
            String valueBefore = propertyPlace.getValue();
            pathBefore = propertyPlace.getPath(true).getShortName();
            valueAfter = propertyPlace.getValue();
            hasErrors = true;
            this.fixes.add(new ImportFix(propertyPlace.getEntity().getId(), "invalidPlace.2", pathBefore, pathBefore, valueBefore, valueAfter));
        }
        return hasErrors;
    }

    public boolean fixEventsCardinality(Gedcom gedcom) {
        LOG.fine("Import processing - Fixing events cardinality...");
        boolean ret = false;
        for (Entity entity : gedcom.getEntities()) {
            if (!entity.getTag().equals("INDI") && !entity.getTag().equals("FAM")) continue;
            HashSet<String> tags = new HashSet<String>();
            for (Property event : entity.getAllProperties(null)) {
                String tag = event.getTag();
                Matcher matcher = tag_y.matcher(tag);
                MetaProperty meta = event.getMetaProperty();
                if (!matcher.matches() || !meta.isSingleton()) continue;
                tags.add(tag);
            }
            for (String tag : tags) {
                Property[] props;
                int n = 0;
                for (Property event : props = entity.getProperties(tag, false)) {
                    if (n == 0) {
                        ++n;
                        continue;
                    }
                    String valueBefore = event.getValue();
                    String pathBefore = event.getPath(true).getShortName();
                    Property host = entity.addProperty("EVEN", valueBefore);
                    String pathAfter = host.getPath(true).getShortName();
                    for (Property p : event.getProperties()) {
                        this.movePropertiesRecursively(p, host);
                    }
                    this.fixes.add(new ImportFix(entity.getId(), "eventsCardinality.1", pathBefore, pathAfter, valueBefore, valueBefore));
                    entity.delProperty(event);
                    ret = true;
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    public boolean fixObje(Gedcom gedcom) {
        LOG.fine("Import processing - Fixing objects...");
        boolean fixed = false;
        boolean isV55 = Grammar.V55.equals(gedcom.getGrammar());
        String valueBefore = "";
        String valueAfter = "";
        String tagBefore = "";
        String tagAfter = "";
        for (Entity entity : gedcom.getEntities()) {
            String id = entity.getId();
            if (entity instanceof Media) {
                Entity obje = entity;
                if (isV55) {
                    fixed |= this.fixFileStructure(obje, "FORM");
                    continue;
                }
                List<Property> files = obje.getAllProperties("FILE");
                if (files.isEmpty()) {
                    valueBefore = "";
                    valueAfter = "unknown";
                    Iterator<Property> file = obje.addProperty("FILE", valueAfter);
                    Property property = ((Property)((Object)file)).addProperty("FORM", valueAfter);
                    fixed = true;
                    this.fixes.add(new ImportFix(id, "invalidFileStructure.1", obje.getPath(true).getShortName(), property.getPath(true).getShortName(), valueBefore, valueAfter));
                    continue;
                }
                for (Property property : files) {
                    if (property.getParent() == obje) continue;
                    valueAfter = valueBefore = property.getValue();
                    tagBefore = property.getPath(true).getShortName();
                    tagAfter = obje.getPath(true).getShortName() + ":FILE";
                    this.movePropertiesRecursively(property, obje);
                    property.getParent().delProperty(property);
                    fixed = true;
                    this.fixes.add(new ImportFix(id, "invalidFileStructure.2", tagBefore, tagAfter, valueBefore, valueAfter));
                }
                files = entity.getAllProperties("FILE");
                for (Property property : files) {
                    fixed |= this.fixFileStructure(property, "FORM");
                    fixed |= this.fixTitlStructure(property, property);
                }
                continue;
            }
            for (Property obje : entity.getAllProperties("OBJE")) {
                void var14_21;
                if (obje instanceof PropertyMedia) continue;
                if (isV55) {
                    fixed |= this.fixFileStructure(obje, "FILE");
                    fixed |= this.fixFileStructure(obje, "FORM");
                    fixed |= this.fixTitlStructure(obje, obje.getProperty("FILE", false));
                    continue;
                }
                List<Property> files = obje.getAllProperties("FILE");
                if (files.isEmpty()) {
                    Property p;
                    valueBefore = "";
                    Property property = obje.addProperty("FILE", valueAfter);
                    Property form = property.getParent().getProperty("FORM", false);
                    tagAfter = "";
                    if (form != null) {
                        valueAfter = form.getValue();
                        p = property.addProperty("FORM", valueAfter);
                        tagAfter = p.getPath(true).getShortName();
                        form.getParent().delProperty(form);
                    } else {
                        valueAfter = "unknown";
                        p = property.addProperty("FORM", valueAfter);
                        tagAfter = p.getPath(true).getShortName();
                    }
                    fixed = true;
                    this.fixes.add(new ImportFix(id, "invalidFileStructure.1", obje.getPath(true).getShortName(), tagAfter, valueBefore, valueAfter));
                    continue;
                }
                for (Property file2 : files) {
                    if (file2.getParent() == obje) continue;
                    valueAfter = valueBefore = file2.getValue();
                    tagBefore = file2.getPath(true).getShortName();
                    tagAfter = obje.getPath(true).getShortName() + ":FILE";
                    this.movePropertiesRecursively(file2, obje);
                    file2.getParent().delProperty(file2);
                    fixed = true;
                    this.fixes.add(new ImportFix(id, "invalidFileStructure.2", tagBefore, tagAfter, valueBefore, valueAfter));
                }
                files = obje.getAllProperties("FILE");
                Object var14_20 = null;
                for (Property file3 : files) {
                    if (var14_21 == null) {
                        Property property = file3;
                    }
                    fixed |= this.fixFileStructure(file3, "FORM");
                }
                fixed |= this.fixTitlStructure(obje, (Property)var14_21);
            }
        }
        return fixed;
    }

    private boolean fixFileStructure(Property host, String tag) {
        String valueBefore = "";
        String valueAfter = "";
        String tagBefore = "";
        String tagAfter = "";
        boolean fixed = false;
        String id = host.getEntity().getId();
        List<Property> ptags = host.getAllProperties(tag);
        if (ptags.isEmpty()) {
            Property ptag = null;
            if (host.getTag().equals("FILE")) {
                ptag = host.getParent().getProperty(tag, false);
            }
            if (ptag == null) {
                valueBefore = "";
                if (tag.equals("FORM")) {
                    Property file = null;
                    if (host.getTag().equals("FILE")) {
                        file = host;
                    } else if (host.getTag().equals("OBJE")) {
                        file = host.getProperty("FILE", false);
                    }
                    if (file != null) {
                        String name = file.getValue();
                        if (name.startsWith("http")) {
                            if (file instanceof PropertyFile) {
                                PropertyFile pf = (PropertyFile)file;
                                if (pf.getInput().isPresent()) {
                                    valueAfter = FileChooserBuilder.getExtension(file.getValue());
                                }
                            } else {
                                valueAfter = "web";
                            }
                        } else {
                            valueAfter = FileChooserBuilder.getExtension(file.getValue());
                        }
                    }
                    if (valueAfter == null || valueAfter.isEmpty()) {
                        valueAfter = "?";
                    }
                } else {
                    valueAfter = "unknown";
                }
                tagBefore = host.getPath(true).getShortName();
                Property p = host.addProperty(tag, valueAfter);
                tagAfter = p.getPath(true).getShortName();
                fixed = true;
                this.fixes.add(new ImportFix(id, "invalidFileStructure.1", tagBefore, tagAfter, valueBefore, valueAfter));
            } else {
                valueAfter = valueBefore = ptag.getValue();
                tagBefore = ptag.getPath(true).getShortName();
                Property p = host.addProperty(tag, valueAfter);
                tagAfter = p.getPath(true).getShortName();
                ptag.getParent().delProperty(ptag);
                fixed = true;
                this.fixes.add(new ImportFix(id, "invalidFileStructure.2", tagBefore, tagAfter, valueBefore, valueAfter));
            }
        } else {
            boolean found = false;
            for (Property ptag : ptags) {
                Property p;
                if (!found) {
                    found = true;
                    if (ptag.getParent() == host) continue;
                    valueAfter = valueBefore = ptag.getValue();
                    tagBefore = ptag.getPath(true).getShortName();
                    p = host.addProperty(tag, valueAfter);
                    tagAfter = p.getPath(true).getShortName();
                    ptag.getParent().delProperty(ptag);
                    fixed = true;
                    this.fixes.add(new ImportFix(id, "invalidFileStructure.2", tagBefore, tagAfter, valueBefore, valueAfter));
                    continue;
                }
                valueAfter = valueBefore = ptag.getValue();
                tagBefore = ptag.getPath(true).getShortName();
                p = ptag.getParent().addProperty("NOTE", valueAfter);
                tagAfter = p.getPath(true).getShortName();
                ptag.getParent().delProperty(ptag);
                fixed = true;
                this.fixes.add(new ImportFix(id, "invalidFileStructure.3", tagBefore, tagAfter, valueBefore, valueAfter));
            }
        }
        return fixed;
    }

    private boolean fixTitlStructure(Property host, Property pFile) {
        String valueBefore = "";
        String valueAfter = "";
        String tagBefore = "";
        String tagAfter = "";
        boolean fixed = false;
        String id = host.getEntity().getId();
        List<Property> titls = host.getAllProperties("TITL");
        if (titls.isEmpty() && host.getTag().equals("FILE") && host.getParent().getTag().equals("OBJE")) {
            titls = host.getParent().getAllProperties("TITL");
        }
        if (titls.isEmpty()) {
            return fixed;
        }
        boolean found = false;
        for (Property titl : titls) {
            if (!found) {
                found = true;
                if (titl.getParent() == host) continue;
                valueAfter = valueBefore = titl.getValue();
                String correction = "invalidFileStructure.2";
                if (valueAfter.isEmpty() && pFile != null && pFile instanceof PropertyFile) {
                    PropertyFile filep = (PropertyFile)pFile;
                    InputSource is = filep.getInput().orElse(null);
                    String title = is != null ? is.getName() : "";
                    int i = title.indexOf(".");
                    valueAfter = i == -1 ? title : title.substring(0, i);
                    correction = "invalidFileStructure.4";
                }
                tagBefore = titl.getPath(true).getShortName();
                Property p = host.addProperty("TITL", valueAfter);
                tagAfter = p.getPath(true).getShortName();
                titl.getParent().delProperty(titl);
                fixed = true;
                this.fixes.add(new ImportFix(id, correction, tagBefore, tagAfter, valueBefore, valueAfter));
                continue;
            }
            valueAfter = valueBefore = titl.getValue();
            tagBefore = titl.getPath(true).getShortName();
            Property p = titl.getParent().addProperty("NOTE", valueAfter);
            tagAfter = p.getPath(true).getShortName();
            titl.getParent().delProperty(titl);
            fixed = true;
            this.fixes.add(new ImportFix(id, "invalidFileStructure.3", tagBefore, tagAfter, valueBefore, valueAfter));
        }
        return fixed;
    }

    public boolean fixAddr(Gedcom gedcom) {
        LOG.fine("Import processing - Fixing addresses...");
        Property resi = null;
        String newTag = "";
        for (Entity entity : gedcom.getEntities()) {
            if (entity.getTag().equals("INDI")) {
                newTag = "RESI";
            } else {
                if (!entity.getTag().equals("FAM")) continue;
                newTag = "_RESI";
            }
            resi = this.moveAddrField(entity, null, newTag, "ADDR");
            resi = this.moveAddrField(entity, resi, newTag, "PHON");
            resi = this.moveAddrField(entity, resi, newTag, "EMAIL");
            resi = this.moveAddrField(entity, resi, newTag, "WWW");
        }
        return resi != null;
    }

    private Property moveAddrField(Entity entity, Property resi, String newTag, String fieldTag) {
        Property newResi = resi;
        String id = entity.getId();
        for (Property prop : entity.getProperties(fieldTag, false)) {
            String valueBefore = prop.getValue();
            String pathBefore = prop.getPath(true).getShortName();
            if (newResi == null) {
                newResi = entity.addProperty(newTag, "");
            }
            for (Property prop2 : prop.getProperties("NOTE", false)) {
                this.movePropertiesRecursively(prop2, newResi);
            }
            this.movePropertiesRecursively(prop, newResi);
            Property p = newResi.getProperty(fieldTag, false);
            if (p == null) {
                p = newResi.getProperty("_" + fieldTag, false);
            }
            this.fixes.add(new ImportFix(id, "invalidTagLocation.3", pathBefore, p.getPath(true).getShortName(), valueBefore, valueBefore));
        }
        return newResi;
    }

    public boolean fixSources(Gedcom gedcom) {
        LOG.fine("Import processing - Fixing sources...");
        boolean fixed = false;
        boolean moved = false;
        Property prop = null;
        PropertyXRef host = null;
        String valueBefore = "";
        String pathBefore = "";
        String pathAfter = "";
        for (Source source : gedcom.getSources()) {
            Property[] dates = source.getProperties("DATE", false);
            for (Property date : dates) {
                valueBefore = date.getValue();
                pathBefore = date.getPath(true).getShortName();
                Property p = source.addProperty("_DATE", valueBefore);
                source.delProperty(date);
                this.fixes.add(new ImportFix(source.getId(), "invalidTagLocation.1", pathBefore, p.getPath(true).getShortName(), valueBefore, valueBefore));
                fixed = true;
            }
            moved = false;
            prop = source.getProperty("QUAY");
            if (prop != null) {
                pathBefore = prop.getPath().getShortName();
                valueBefore = prop.getValue();
                if (prop != null) {
                    for (PropertyXRef xref : source.getProperties(PropertyXRef.class)) {
                        Property quay;
                        if (!xref.isValid() || !((host = xref.getTarget()) instanceof PropertySource) || (quay = host.getProperty("QUAY")) != null) continue;
                        Property p = host.addProperty("QUAY", valueBefore);
                        pathAfter = p.getPath().getShortName();
                        this.fixes.add(new ImportFix(source.getId(), "invalidTagLocation.3", pathBefore, pathAfter, valueBefore, valueBefore));
                        moved = true;
                    }
                    if (!moved) {
                        Property p = source.addProperty("_QUAY", prop.getValue());
                        pathAfter = p.getPath().getShortName();
                        this.fixes.add(new ImportFix(source.getId(), "invalidTagLocation.1", pathBefore, pathAfter, valueBefore, valueBefore));
                    }
                    source.delProperty(prop);
                    fixed = true;
                }
            }
            fixed |= this.moveTag(source, "WWW");
            fixed |= this.moveTag(source, "EMAIL");
        }
        return fixed;
    }

    private boolean moveTag(Entity source, String tag) {
        String pathAfter = "";
        boolean hasErrors = false;
        String correction = "invalidTagLocation.3";
        Property prop = source.getProperty(tag);
        if (prop != null) {
            PropertyRepository pRep;
            Entity target;
            String pathBefore = prop.getPath().getShortName();
            String valueBefore = prop.getValue();
            Property host = source.getProperty(typerepo);
            boolean found = false;
            if (host != null && host instanceof PropertyRepository && (target = (pRep = (PropertyRepository)host).getTargetEntity()) != null) {
                Property[] ps = target.getProperties(tag, false);
                int card = 1;
                for (Property p : ps) {
                    card = p.getMetaProperty().getMaxCardinality();
                    if (!p.getValue().equals(valueBefore)) continue;
                    pathAfter = p.getPath().getShortName();
                    found = true;
                    break;
                }
                if (ps.length < card && !found) {
                    Property p = target.addProperty(tag, valueBefore);
                    pathAfter = p.getPath().getShortName();
                    found = true;
                }
            }
            if (!found) {
                Property p = source.addProperty("_" + tag, prop.getValue());
                pathAfter = p.getPath().getShortName();
                correction = "invalidTagLocation.1";
            }
            source.delProperty(prop);
            this.fixes.add(new ImportFix(source.getId(), correction, pathBefore, pathAfter, valueBefore, valueBefore));
            hasErrors = true;
        }
        return hasErrors;
    }

    public boolean fixSourceCitations(Gedcom gedcom) {
        LOG.fine("Import processing - Fixing source citations...");
        boolean fixed = false;
        String valueBefore = "";
        String pathBefore = "";
        for (Entity entity : gedcom.getEntities()) {
            String id = entity.getId();
            for (Property source : entity.getAllProperties("SOUR")) {
                Property[] dates = source.getProperties("DATE", false);
                if (dates != null && dates.length > 0) {
                    Property data = source.getProperty("DATA");
                    if (data == null) {
                        data = source.addProperty("DATA", "");
                    }
                    Property[] propertyArray = dates;
                    int n = propertyArray.length;
                    for (int i = 0; i < n; ++i) {
                        Property date = propertyArray[i];
                        valueBefore = date.getValue();
                        pathBefore = date.getPath(true).getShortName();
                        Property p = data.addProperty("DATE", valueBefore);
                        source.delProperty(date);
                        this.fixes.add(new ImportFix(id, "invalidTagLocation.3", pathBefore, p.getPath(true).getShortName(), valueBefore, valueBefore));
                        fixed = true;
                    }
                }
                for (Property refn : source.getProperties("REFN", false)) {
                    valueBefore = refn.getValue();
                    pathBefore = refn.getPath(true).getShortName();
                    if (source instanceof PropertySource) {
                        PropertySource pSource = (PropertySource)source;
                        Source sourceEntity = (Source)pSource.getTargetEntity();
                        boolean valueExists = false;
                        Property p = null;
                        for (Property refn2 : sourceEntity.getProperties("REFN", false)) {
                            if (!refn2.getValue().equals(valueBefore)) continue;
                            valueExists = true;
                            p = refn2;
                            break;
                        }
                        if (!valueExists) {
                            p = sourceEntity.addProperty("REFN", valueBefore);
                        }
                        this.fixes.add(new ImportFix(id, "invalidTagLocation.3", pathBefore, sourceEntity.getId() + ":" + p.getPath(true).getShortName(), valueBefore, valueBefore));
                        fixed = true;
                    } else {
                        Property p = source.addProperty("_REFN", valueBefore);
                        this.fixes.add(new ImportFix(id, "invalidTagLocation.1", pathBefore, p.getPath(true).getShortName(), valueBefore, valueBefore));
                        fixed = true;
                    }
                    source.delProperty(refn);
                }
            }
        }
        return fixed;
    }

    public boolean fixNoteCitations(Gedcom gedcom) {
        LOG.fine("Import processing - Fixing note citations...");
        boolean fixed = false;
        String valueBefore = "";
        String pathBefore = "";
        for (Entity entity : gedcom.getEntities()) {
            String id = entity.getId();
            for (Property note : entity.getAllProperties("NOTE")) {
                Property[] sources = note.getProperties("SOUR", false);
                if (sources == null || sources.length <= 0) continue;
                for (Property sour : sources) {
                    valueBefore = sour.getValue();
                    pathBefore = sour.getPath(true).getShortName();
                    this.movePropertiesRecursively(sour, note.getParent());
                    this.fixes.add(new ImportFix(id, "invalidTagLocation.3", pathBefore, note.getParent().getPath(true).getShortName() + ":SOUR", valueBefore, valueBefore));
                    fixed = true;
                }
            }
        }
        return fixed;
    }

    public boolean fixConcCont(Gedcom gedcom) {
        LOG.fine("Import processing - Fixing line breaks...");
        boolean fixed = false;
        String valueBefore = "";
        String pathBefore = "";
        for (Entity entity : gedcom.getEntities()) {
            String id = entity.getId();
            HashSet<Property> parents = new HashSet<Property>();
            List<Property> concs = entity.getAllProperties("CONC");
            concs.addAll(entity.getAllProperties("CONT"));
            for (Property conc : concs) {
                boolean valid = false;
                Property property = conc.getParent();
                Property[] parentTag = property.getTag();
                if (!property.isValid() || parentTag.startsWith("_")) continue;
                if (parentTag.equals("ADDR") && conc.getTag().equals("CONT")) {
                    valid = true;
                } else if (parentTag.equals("NOTE") && !(property instanceof PropertyNote)) {
                    valid = true;
                } else if (parentTag.equals("TITL") && property.getParent() != null && property.getParent().getTag().equals("SOUR")) {
                    valid = true;
                } else if (parentTag.equals("TEXT") && property.getParent() != null && (property.getParent().getTag().equals("SOUR") || property.getParent().getTag().equals("DATA"))) {
                    valid = true;
                } else if (parentTag.equals("SOUR") && !(property instanceof PropertySource) && !(property instanceof Source)) {
                    valid = true;
                }
                if (valid) continue;
                parents.add(property);
            }
            for (Property parent : parents) {
                Property[] propertyArray;
                String value = parent.getValue();
                pathBefore = parent.getPath(true).getShortName();
                valueBefore = value;
                for (Property child : propertyArray = parent.getProperties()) {
                    String childTag = child.getTag();
                    value = value + (childTag.equals("CONT") ? ", " : "") + child.getValue();
                    parent.delProperty(child);
                }
                if (value.equals(valueBefore)) continue;
                parent.setValue(value);
                this.fixes.add(new ImportFix(id, "invalidTagLocation.5", pathBefore + ":CONC/T", pathBefore, valueBefore, value));
                fixed = true;
            }
            for (Iterator<Property> iterator : entity.getProperties()) {
                PropertyEvent pEvent;
                String tag = ((Property)((Object)iterator)).getTag();
                if (!tag_y.matcher(tag).matches() && !"RESI".equals(tag) && !"EVEN".equals(tag)) continue;
                valueBefore = "";
                Property type = ((Property)((Object)iterator)).getProperty("TYPE", false);
                if (type != null && type.getValue().length() > 90) {
                    Property p = null;
                    String correction = "eventValue.4";
                    valueBefore = type.getValue();
                    try {
                        p = ((Property)((Object)iterator)).addProperty("NOTE", valueBefore, ((Property)((Object)iterator)).getPropertyPosition(type));
                    }
                    catch (GedcomException ex) {
                        p = ((Property)((Object)iterator)).addProperty("NOTE", valueBefore);
                    }
                    pathBefore = type.getPath(true).getShortName();
                    String pathAfter = p.getPath(true).getShortName();
                    ((Property)((Object)iterator)).delProperty(type);
                    this.fixes.add(new ImportFix(entity.getId(), correction, pathBefore, pathAfter, valueBefore, valueBefore));
                    fixed = true;
                }
                if (!((valueBefore = ((Property)((Object)iterator)).getValue()).isEmpty() || valueBefore.length() > 90 || valueBefore.equalsIgnoreCase("y") || "EVEN".equals(tag))) {
                    Property p = null;
                    String newTag = "TYPE";
                    String correction = "eventValue.1";
                    if (type != null) {
                        newTag = "NOTE";
                        correction = "eventValue.2";
                    }
                    try {
                        p = ((Property)((Object)iterator)).addProperty(newTag, valueBefore, 0);
                    }
                    catch (GedcomException ex) {
                        p = ((Property)((Object)iterator)).addProperty(newTag, valueBefore);
                    }
                    ((Property)((Object)iterator)).setValue("");
                    pathBefore = ((Property)((Object)iterator)).getPath(true).getShortName();
                    String pathAfter = p.getPath(true).getShortName();
                    this.fixes.add(new ImportFix(entity.getId(), correction, pathBefore, pathAfter, valueBefore, valueBefore));
                    fixed = true;
                    continue;
                }
                if (!(iterator instanceof PropertyEvent) || !valueBefore.equalsIgnoreCase("y") || (pEvent = (PropertyEvent)((Object)iterator)).isValid()) continue;
                String pathAfter = pathBefore = ((Property)((Object)iterator)).getPath(true).getShortName();
                ((Property)((Object)iterator)).setValue("");
                this.fixes.add(new ImportFix(entity.getId(), "eventValue.5", pathBefore, pathAfter, valueBefore, valueBefore));
                fixed = true;
            }
        }
        return fixed;
    }

    public boolean fixTexts(Gedcom gedcom) {
        LOG.fine("Import processing - Fixing texts...");
        boolean fixed = false;
        String valueBefore = "";
        String valueAfter = "";
        String pathBefore = "";
        Pattern p = Pattern.compile("<[a-zA-Z\\/][^><\\.]*>");
        List<? extends Property> texts = gedcom.getPropertiesByClass(PropertyMultilineValue.class);
        for (Property property : texts) {
            PropertyMultilineValue pText;
            if (property.getValue().contains("\\rtf1")) {
                pText = (PropertyMultilineValue)property;
                valueBefore = pText.getValue();
                valueAfter = Utilities.rtf2text(valueBefore);
                pText.setValue(valueAfter);
                pathBefore = pText.getPath(true).getShortName();
                this.fixes.add(new ImportFix(pText.getEntity().getId(), "textformatting.2", pathBefore, pathBefore, valueBefore, valueAfter));
                fixed = true;
                continue;
            }
            pText = (PropertyMultilineValue)property;
            valueBefore = pText.getValue().trim();
            Matcher m = p.matcher(valueBefore);
            if (!m.find()) continue;
            valueAfter = valueBefore.replaceAll("<br />", "<p>").replaceAll("<br/>", "<p>").replaceAll("<br>", "<p>");
            valueAfter = Utilities.html2text(valueAfter).trim();
            pText.setValue(valueAfter);
            pathBefore = pText.getPath(true).getShortName();
            this.fixes.add(new ImportFix(pText.getEntity().getId(), "textformatting.1", pathBefore, pathBefore, valueBefore, valueAfter));
            fixed = true;
        }
        return fixed;
    }

    public boolean convertAssociations(Gedcom gedcom) {
        LOG.fine("Import processing - Fixing associations...");
        ArrayList list = new ArrayList();
        gedcom.getIndis().forEach(entity -> this.getPropertiesRecursively(list, "ASSO", (Property)entity));
        gedcom.getFamilies().forEach(entity -> this.getPropertiesRecursively(list, "ASSO", (Property)entity));
        boolean isV55 = Grammar.V55.equals(gedcom.getGrammar());
        int increment = list.size() / 10 + 1;
        int counter = 0;
        for (Property prop : list) {
            String id;
            if (++counter % increment == 0 && this.progress < 100) {
                ++this.progress;
            }
            if (prop instanceof PropertyAssociation) continue;
            String valueBefore = prop.getValue();
            String idB = id = prop.getValue().replace("@", "").trim();
            Indi indiRela = (Indi)gedcom.getEntity(id);
            if (indiRela == null) continue;
            String type = prop.getEntity().getTag();
            Property relaProp = prop.getProperty("RELA");
            String rela = "";
            if (relaProp != null) {
                rela = relaProp.getDisplayValue();
            }
            TagPath tagpath = prop.getParent().getPath(true);
            id = prop.getEntity().getId();
            String tagA = id + ":" + prop.getPath(true).getShortName();
            PropertyAssociation propAsso = (PropertyAssociation)indiRela.addProperty("ASSO", "@" + id + "@");
            String valueAfter = propAsso.getValue();
            if (isV55) {
                propAsso.addProperty("TYPE", type);
            }
            PropertyRelationship pship = (PropertyRelationship)propAsso.getProperty("RELA", false);
            rela = rela + "@" + tagpath.toString();
            if (pship == null) {
                propAsso.addProperty("RELA", rela);
            } else {
                pship.setValue(rela);
            }
            for (Property child : prop.getProperties()) {
                if (child.getTag().equals("RELA") || child.getTag().equals("TYPE") && isV55) continue;
                this.movePropertiesRecursively(child, propAsso);
            }
            try {
                propAsso.link();
            }
            catch (GedcomException ex) {
                return false;
            }
            prop.getParent().delProperty(prop);
            this.fixes.add(new ImportFix(id, "switchAssos.1", tagA, idB + ":INDI:ASSO", valueBefore, valueAfter));
        }
        return true;
    }

    public <T> void getPropertiesRecursively(List<T> props, String tag, Property parent) {
        for (Property child : parent.getProperties()) {
            if (tag.equals(child.getTag())) {
                props.add(child);
            }
            this.getPropertiesRecursively(props, tag, child);
        }
    }

    private void memorizeEntity(String tag, HashMap<String, ImportEnt> hashEntities) {
        String xref;
        if (this.input.getTag().equals(tag) && !(xref = this.input.getXref()).isEmpty()) {
            if (!hashEntities.containsKey(xref)) {
                hashEntities.put(xref, new ImportEnt());
            }
            hashEntities.get((Object)xref).seen = true;
        }
    }

    private void memorizeProperty(String tag, HashMap<String, ImportEnt> hashEntities) {
        if (this.input.getTag().equals(tag) && this.input.getValue().startsWith("@") && this.input.getValue().endsWith("@") && !this.input.getValue().startsWith("@@")) {
            String value = this.input.getValue();
            if (!hashEntities.containsKey(value = value.substring(1, value.length() - 1))) {
                hashEntities.put(value, new ImportEnt());
            }
        }
    }

    private void memorizeAssociation() {
        if (this.input.getTag().equals("ASSO") && this.input.getValue().startsWith("@") && this.input.getValue().endsWith("@") && !this.input.getValue().startsWith("@@")) {
            String value = this.input.getValue();
            if (!hashAssos.containsKey(value = value.substring(1, value.length() - 1))) {
                hashAssos.put(value, new ImportEnt());
            }
        }
    }

    public void movePropertiesRecursively(Property propertySrc, Property parentPropertyDest) {
        if (parentPropertyDest == null) {
            return;
        }
        int n = parentPropertyDest.getNoOfProperties();
        Property propertyDest = null;
        try {
            String tag = propertySrc.getTag();
            if (!(tag.equals("CONT") || tag.equals("CONC") || tag.startsWith("_") || parentPropertyDest.getMetaProperty().allows(tag))) {
                tag = "_" + tag;
            }
            propertyDest = parentPropertyDest.addProperty(tag, propertySrc.getValue(), n);
        }
        catch (GedcomException gedcomException) {
            // empty catch block
        }
        for (Property children : propertySrc.getProperties()) {
            this.movePropertiesRecursively(children, propertyDest);
        }
        propertySrc.getParent().delProperty(propertySrc);
    }

    private String getPlaceFormat(boolean freq) {
        int place_format_length = 0;
        int max = 0;
        for (int i = 0; i < 20; ++i) {
            if (freq && this.place_format_sizes[i] > max) {
                place_format_length = i;
                max = this.place_format_sizes[i];
            }
            if (freq || this.place_format_sizes[i] <= 0) continue;
            place_format_length = i;
        }
        String defaultPlaceFormat = GedcomOptions.getInstance().getPlaceFormat();
        String[] defaultPlaceFormatArray = PropertyPlace.getFormat(defaultPlaceFormat);
        int dpf_length = defaultPlaceFormatArray.length;
        if (place_format_length <= dpf_length) {
            return defaultPlaceFormat;
        }
        String place_format = "";
        for (int i = 0; i < place_format_length; ++i) {
            place_format = i < place_format_length - dpf_length ? place_format + "Jur" + (i + 1) : place_format + defaultPlaceFormatArray[i - place_format_length + dpf_length];
            if (i == place_format_length - 1) continue;
            place_format = place_format + ",";
        }
        return place_format;
    }

    public String getEOL(File input) {
        String eolMark = System.getProperty("line.separator");
        try {
            FileReader fr = new FileReader(input);
            char[] buffer = new char[200];
            fr.read(buffer);
            String line = new String(buffer);
            if (line.contains("\r\n")) {
                eolMark = "\r\n";
            } else if (line.contains("\n")) {
                eolMark = "\n";
            } else if (line.contains("\r")) {
                eolMark = "\r";
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return eolMark;
    }

    static {
        SPANISH_MONTHS_PATTERN = Pattern.compile("(ENERO|FEBRERO|MARZO|ABRIL|MAYO|JUNIO|JULIO|AGOSTO|SEPTIEMBRE|OCTUBRE|NOVIEMBRE|DICIEMBRE)");
    }

    private class ImportEnt {
        protected boolean seen = false;

        private ImportEnt() {
        }
    }
}

